<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');

require_once dirname(__DIR__) . '/controles/db.php';

// ===================================================================
//      CONFIGURAES - ATENO
// ===================================================================
// 1. Cole aqui a sua chave de API do Cutt.ly
$cuttly_api_key = '78e1efb727270d27ce63acc527e1c3a3fd9af';

// 2. Verifique se a sua URL aqui est correta (o endereo do seu get.php)
$server_url_com_porta = 'http://jrpflix.tvsbr.top:80';
// ===================================================================

/**
 * Funo para encurtar um link usando a API do Cutt.ly.
 */
function encurtarLink($long_url, $api_key) {
    if (empty($api_key) || $api_key === 'coloaque_aqui_a_api_cuttly') {
        return $long_url; // Retorna o link original se a chave no for configurada
    }
    $api_url = "https://cutt.ly/api/api.php?key={$api_key}&short=" . urlencode($long_url);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response_json = curl_exec($ch);
    curl_close($ch);
    $response_data = json_decode($response_json, true);
    if (isset($response_data['url']['status']) && $response_data['url']['status'] == 7) {
        return $response_data['url']['shortLink'];
    }
    return $long_url; // Retorna o link original em caso de falha
}

// --- Lgica principal do script ---
if (!isset($_GET['id'])) {
    http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'ID do cliente no fornecido.']));
}
try {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("SELECT name, usuario, senha, vencimento FROM clientes WHERE id = :id");
    $stmt->execute([':id' => $_GET['id']]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cliente) {
        http_response_code(404); die(json_encode(['status' => 'error', 'message' => 'Cliente no encontrado.']));
    }

    $caminhoTemplate = '../../../template_mensagem.txt';
    if (!file_exists($caminhoTemplate)) {
        http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Arquivo template_mensagem.txt no encontrado na raiz.']));
    }
    $mensagem = file_get_contents($caminhoTemplate);

    // --- PREPARAO DAS VARIVEIS E GERAO DOS LINKS ---
    $username = $cliente['usuario'];
    $password = $cliente['senha'];
    $nome_cliente = $cliente['name'];
    $exp_date = (new DateTime($cliente['vencimento']))->format('d/m/Y');

    // Gera os links longos
    $m3u_link = "{$server_url_com_porta}/get.php?username={$username}&password={$password}&type=m3u_plus&output=ts";
    $m3u_link_hls = "{$server_url_com_porta}/get.php?username={$username}&password={$password}&type=m3u_plus&output=m3u8";
    $ssiptv_link = "{$server_url_com_porta}/get.php?username={$username}&password={$password}&type=m3u_plus";

    // --- SUBSTITUIO DOS PLACEHOLDERS ---
    $placeholders = [
        '#username#'          => $username,
        '#password#'          => $password,
        '[nome]'              => $nome_cliente,
        '#exp_date#'          => $exp_date,
        '#url#'               => $server_url_com_porta,
        '#m3u_link#'          => $m3u_link,
        '#m3u_link_hls#'      => $m3u_link_hls,
        '#m3u_encurtado#'     => encurtarLink($m3u_link, $cuttly_api_key),
        '#m3u_hls_encurtado#' => encurtarLink($m3u_link_hls, $cuttly_api_key),
        '#ssiptv_encurtado#'   => encurtarLink($ssiptv_link, $cuttly_api_key)
    ];
    
    foreach ($placeholders as $key => $value) {
        $mensagem = str_replace($key, $value, $mensagem);
    }

    echo json_encode(['status' => 'success', 'data' => ['mensagem' => $mensagem]]);
} catch (Exception $e) {
    http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao gerar mensagem: ' . $e->getMessage()]));
}
?>