﻿<?php
// Configurações iniciais
ini_set('display_errors', 0);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verifica menu
if (file_exists("menu.php")) {
    require_once("menu.php");
} else {
    echo '<div class="alert alert-danger">ERRO: menu.php não encontrado.</div>';
}

// Caminho da API (ajuste se necessário)
$api_path = 'api/testes.php'; 
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Testes</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
    
    <style>
        /* Estilos Profissionais e Cards */
        div.dataTables_processing { z-index: 1050; background-color: white !important; }
        
        .card-dashboard {
            border: none; border-radius: 12px; color: #fff; position: relative;
            overflow: hidden; transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .card-dashboard:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.2) !important; }
        .card-dashboard .card-body { position: relative; z-index: 2; padding: 1.5rem; }
        .card-dashboard .icon-bg {
            position: absolute; right: 15px; bottom: 10px; font-size: 4rem;
            opacity: 0.2; z-index: 1; transform: rotate(-10deg);
        }
        .card-dashboard h5 { font-size: 0.9rem; text-transform: uppercase; font-weight: 600; opacity: 0.9; margin-bottom: 5px; }
        .card-dashboard h3 { font-size: 2.2rem; font-weight: 700; margin-bottom: 0; }
        
        /* Gradientes */
        .bg-gradient-teste-green { background: linear-gradient(135deg, #2ecc71 0%, #27ae60 100%); }
        .bg-gradient-teste-yellow { background: linear-gradient(135deg, #f1c40f 0%, #f39c12 100%); color: #fff; }
        .bg-gradient-teste-red { background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%); }

        /* Ajuste Mobile */
        @media (max-width: 768px) {
            .mobile-full-width {
                margin-left: -0.8rem !important; margin-right: -0.8rem !important;
                width: calc(100% + 1.6rem) !important; border-radius: 0 !important;
                box-shadow: none !important; border-left: 0 !important; border-right: 0 !important;
            }
        }
        
        /* Tema Escuro */
        [data-theme="dark"] .card { background-color: #2a2e33 !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
        [data-theme="dark"] .table { color: #e4e6eb !important; border-color: #3a3f44 !important; background-color: transparent !important; }
        [data-theme="dark"] .table th { background-color: #212529 !important; color: #fff !important; border-color: #3a3f44 !important; }
        [data-theme="dark"] .table td { background-color: transparent !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
        [data-theme="dark"] .modal-content { background-color: #2a2e33; color: #fff; }
    </style>
</head>
<body>

<div class="container-fluid pt-3">
    <div class="row mb-4 g-3">
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-teste-green shadow-sm">
                <div class="card-body">
                    <h5>Testes Ativos</h5>
                    <h3 id="c-testes-ativos"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-stopwatch icon-bg"></i>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-teste-yellow shadow-sm">
                <div class="card-body">
                    <h5>Testes Expirados</h5>
                    <h3 id="c-testes-vencidos"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-hourglass-end icon-bg"></i>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card card-dashboard bg-gradient-teste-red shadow-sm">
                <div class="card-body">
                    <h5>Testes Bloqueados</h5>
                    <h3 id="c-testes-bloqueados"><i class="fas fa-spinner fa-spin fa-xs"></i></h3>
                    <i class="fas fa-ban icon-bg"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow border-0 mobile-full-width" style="border-radius: 12px;">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2 bg-white border-bottom py-3">
            <h4 class="mb-0 text-primary fw-bold"><i class="fas fa-stopwatch me-2"></i>Gerenciar Testes</h4>
            <div class="d-flex gap-2 align-items-center">
                <select id="filtro_revenda" class="form-select form-select-sm shadow-none" style="width: auto; min-width: 200px; border-radius: 20px;">
                    <option value="">Meus Testes</option>
                </select>
                <button class="btn btn-primary btn-sm text-nowrap shadow-sm rounded-pill px-3" onclick="modal_master('<?php echo $api_path; ?>', 'adicionar_testes')">
                    <i class="fas fa-plus-circle me-1"></i> Novo Teste
                </button>
            </div>
        </div>
        <div class="card-body p-0"> 
            <div class="table-responsive">
                <table id="tabela_testes_v3" class="table table-hover align-middle mb-0" style="width:100%">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">#</th>
                            <th>Nome</th>
                            <th>Usuário</th>
                            <th>Status</th>
                            <th>Expira em</th>
                            <th class="text-end pe-3" style="min-width: 160px;">Ações</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_master" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header" id="modal_master-header">
                <h5 class="modal-title" id="modal_master-titulo"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div id="modal_master-body" class="modal-body"></div>
            <div id="modal_master-footer" class="modal-footer"></div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="//cdn.datatables.net/2.0.7/js/dataTables.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// --- FUNÇÕES GLOBAIS ---

// 1. Função para abrir o Modal chamando o Backend
window.modal_master = function(url, acao, id = null) {
    // Limpa e mostra carregando
    $('#modal_master-titulo').text('Carregando...');
    $('#modal_master-body').html('<div class="text-center py-4"><div class="spinner-border text-primary" role="status"></div><br>Aguarde...</div>');
    $('#modal_master-footer').html('');
    
    var myModal = new bootstrap.Modal(document.getElementById('modal_master'));
    myModal.show();

    // Faz a requisição para o PHP
    $.ajax({
        type: "POST",
        url: url,
        data: { acao: acao, id: id }, // Envia a ação (ex: editar_teste) e o ID
        dataType: "json",
        success: function(res) {
            if(res.modal_titulo) {
                $('#modal_master-titulo').html(res.modal_titulo);
                $('#modal_master-body').html(res.modal_body);
                $('#modal_master-footer').html(res.modal_footer);
            } else {
                Swal.fire('Erro', 'Resposta inválida da API', 'error');
                $('#modal_master').modal('hide');
            }
        },
        error: function(xhr) {
            Swal.fire('Erro', 'Falha ao carregar formulário. Verifique o console.', 'error');
            console.error(xhr.responseText);
            $('#modal_master').modal('hide');
        }
    });
};

// 2. Gerar senha e usuário aleatório no form
window.gerarDadosAcesso = function() {
    const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    const rand = (l) => {
        let r = ''; for(let i=0; i<l; i++) r += chars.charAt(Math.floor(Math.random() * chars.length)); return r;
    };
    $('input[name="usuario"]').val(rand(8));
    $('input[name="senha"]').val(rand(8));
};

// 3. Enviar formulário via AJAX (Salvar, Editar, Excluir)
window.enviarFormulario = function(formId, urlApi) {
    var formData = $('#' + formId).serialize();
    $('#modal_master').modal('hide');
    
    Swal.fire({ 
        title: 'Processando...', 
        allowOutsideClick: false,
        didOpen: () => { Swal.showLoading() } 
    });

    $.ajax({
        type: "POST",
        url: urlApi,
        data: formData,
        dataType: "json",
        success: function(res) {
            if (res.icon === 'success' || (res.title && res.title.toLowerCase().includes('sucesso')) || (res.title && res.title.toLowerCase().includes('atualizado'))) {
                
                // Recarrega tabela e cards
                if(window.tabelaTestes) window.tabelaTestes.ajax.reload(null, false);
                window.atualizarCardsTestes();

                // Lógica Especial: Redirecionamento (Converter)
                if (res.redirect_url) {
                    Swal.fire({ icon: 'success', title: res.title, text: res.msg, timer: 2000, showConfirmButton: false })
                        .then(() => { window.location.href = res.redirect_url; });
                    return;
                }

                // Lógica Especial: Mostrar Mensagem do Teste Criado
                if (res.dados_cliente_msg) {
                    const msgEncoded = encodeURIComponent(res.dados_cliente_msg);
                    const htmlContent = `
                        <textarea id="txtMsgFinal" class="form-control" rows="8" style="font-size:0.85rem; font-family:monospace;">${res.dados_cliente_msg}</textarea>
                        <div class="mt-3 d-flex gap-2 justify-content-center">
                            <button class="btn btn-primary btn-sm" onclick="navigator.clipboard.writeText(document.getElementById('txtMsgFinal').value); const Toast = Swal.mixin({toast: true, position: 'top-end', showConfirmButton: false, timer: 2000}); Toast.fire({icon: 'success', title: 'Copiado!'});"><i class="fas fa-copy"></i> Copiar</button>
                            <a href="https://wa.me/?text=${msgEncoded}" target="_blank" class="btn btn-success btn-sm"><i class="fab fa-whatsapp"></i> WhatsApp</a>
                        </div>
                    `;
                    Swal.fire({ icon: 'success', title: res.title || 'Sucesso!', html: htmlContent, showConfirmButton: false, showCloseButton: true });
                } else {
                    // Sucesso Padrão (Editar, Bloquear, Excluir)
                    Swal.fire({ icon: 'success', title: res.title, text: res.msg, showConfirmButton: true });
                }
            } else {
                Swal.fire({ icon: res.icon || 'error', title: res.title || 'Erro', text: res.msg || 'Erro inesperado.' });
            }
        },
        error: function(xhr) { Swal.fire('Erro no Servidor', xhr.responseText, 'error'); }
    });
};

// --- INICIALIZAÇÃO ---
$(document).ready(function() {
    const API = '<?php echo $api_path; ?>';

    // 1. Inicializa Tabela
    window.tabelaTestes = $('#tabela_testes_v3').DataTable({
        "processing": true,
        "serverSide": true,
        "destroy": true,
        "ajax": {
            "url": API + "?listar_testes=1",
            "type": "POST",
            "data": function(d) { d.filtro_revenda = $('#filtro_revenda').val(); },
            "dataSrc": function(json) { return json.data || []; }
        },
        "columns": [
            { "data": "id", "className": "ps-3" },
            { "data": "name" },
            { "data": "usuario" },
            { "data": "status" },
            { "data": "vencimento" },
            { "data": "acao", "orderable": false, "searchable": false, "className": "text-end pe-3" }
        ],
        "language": { "url": "//cdn.datatables.net/plug-ins/2.0.7/i18n/pt-BR.json" },
        "order": [[ 0, "desc" ]]
    });

    // 2. Carrega Filtro de Revendedores
    $.getJSON(API, { acao: 'listar_revendedores' }, function(res) {
        const sel = $('#filtro_revenda');
        sel.empty();
        sel.append('<option value="">Meus Testes</option>');
        sel.append('<option value="todos">--- Ver Todos (Admin) ---</option>');
        if(res.data) res.data.forEach(r => sel.append(`<option value="${r.id}">${r.user}</option>`));
    });

    // Evento de troca de filtro
    $('#filtro_revenda').change(function() { window.tabelaTestes.ajax.reload(); });

    // 3. Atualiza Cards
    window.atualizarCardsTestes = function() {
        $.getJSON(API, { acao: 'obter_contagens_testes', _: new Date().getTime() }, function(res) {
            $('#c-testes-ativos').text(res.ativos ?? 0);
            $('#c-testes-vencidos').text(res.vencidos ?? 0);
            $('#c-testes-bloqueados').text(res.bloqueados ?? 0);
        });
    };
    window.atualizarCardsTestes();

    // Aplica tema
    document.documentElement.setAttribute('data-bs-theme', localStorage.getItem('theme') || 'light');
});
</script>
</body>
</html>