<?php
// 1. Inclui o seu menu (ISSO É ESSENCIAL PARA O LOGIN)
require_once("menu.php");
?>

<style>
    /* CSS de Performance e Abas (do ZenPanel) */
    .performance-card {
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px solid #e9ecef;
    }
    .performance-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .performance-card.border-primary {
        border-color: #0d6efd !important;
        background: linear-gradient(135deg, #0d6efd, #0a58ca);
        color: white;
    }
    .performance-card.border-primary .text-muted {
        color: rgba(255,255,255,0.8) !important;
    }
    #debugConsole {
        background-color: #212529;
        color: #f8f9fa;
        font-family: monospace;
        font-size: 0.8rem;
        max-height: 150px;
        overflow-y: auto;
    }

    /* 3. Correção de Tema (Claro/Escuro) para este importador */
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important;
        color: #e4e6eb !important;
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .card-header,
    [data-theme="dark"] .card-footer,
    [data-theme="dark"] .bg-light {
        background-color: #343a40 !important;
        color: #e4e6eb !important;
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .bg-white {
         background-color: #2c2c2c !important;
    }
    [data-theme="dark"] .text-muted {
         color: #adb5bd !important;
    }
    [data-theme="dark"] .form-check-label,
    [data-theme="dark"] .form-label {
         color: #e4e6eb !important;
    }
    [data-theme="dark"] .nav-tabs .nav-link {
        color: #adb5bd;
        background-color: #2a2e33;
        border-color: #3a3f44;
    }
    [data-theme="dark"] .nav-tabs .nav-link.active {
        color: #fff;
        background-color: #343a40;
        border-color: #3a3f44;
    }
    [data-theme="dark"] .performance-card {
         border-color: #3a3f44;
    }
    [data-theme="dark"] .border {
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] #debugConsole {
         background-color: #1a1a2e;
    }
</style>

<div class="container-fluid py-4">
    <div class="page-header">
        <h1><i class="bi bi-cloud-upload me-2"></i>Importar Lista M3U (Office Xtream)</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item active">Importar M3U</li>
            </ol>
        </nav>
    </div>
    
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="bi bi-file-earmark-arrow-up me-2"></i>
                        Selecione o Arquivo M3U
                    </h5>
                </div>
                <div class="card-body">
                    <form id="uploadForm" enctype="multipart/form-data">
                        <ul class="nav nav-tabs mb-4" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-bs-toggle="tab" href="#tabFile">
                                    <i class="bi bi-file-earmark-arrow-up"></i> Upload de Arquivo
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#tabUrl">
                                    <i class="bi bi-link-45deg"></i> URL Externa
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="tabFile">
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">Arquivo M3U</label>
                                    <input type="file" class="form-control" id="m3u_file" name="m3u_file" accept=".m3u,.m3u8,.txt">
                                    <small class="text-muted">Tamanho máximo: 512MB</small>
                                    <div id="fileError" class="text-danger small mt-1" style="display: none;"></div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tabUrl">
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">URL do M3U</label>
                                    <input type="url" class="form-control" id="m3u_url" name="m3u_url"
                                            placeholder="https://exemplo.com/lista.m3u">
                                    <small class="text-muted">Cole a URL completa do arquivo M3U</small>
                                    <div id="urlError" class="text-danger small mt-1" style="display: none;"></div>
                                </div>
                            </div>
                        </div>
                        <div class="card bg-light mb-3">
                            <div class="card-header bg-primary text-white">
                                <h6 class="mb-0">
                                    <i class="bi bi-speedometer2 me-2"></i>
                                    Nível de Performance
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row g-3" id="performanceLevels">
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card performance-card" data-level="1">
                                            <div class="card-body text-center">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="radio" name="performance_level"
                                                            id="level1" value="1">
                                                    <label class="form-check-label fw-bold" for="level1">🐢 Econômico</label>
                                                </div>
                                                <small class="text-muted d-block">Velocidade: 500 itens/batch</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card performance-card" data-level="2">
                                            <div class="card-body text-center">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="radio" name="performance_level"
                                                            id="level2" value="2">
                                                    <label class="form-check-label fw-bold" for="level2">⚡ Padrão</label>
                                                </div>
                                                <small class="text-muted d-block">Velocidade: 2.000 itens/batch</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card performance-card" data-level="3">
                                            <div class="card-body text-center">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="radio" name="performance_level"
                                                            id="level3" value="3">
                                                    <label class="form-check-label fw-bold" for="level3">🚀 Turbo</label>
                                                </div>
                                                <small class="text-muted d-block">Velocidade: 8.000 itens/batch</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="card performance-card border-primary" data-level="4">
                                            <div class="card-body text-center">
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="radio" name="performance_level"
                                                            id="level4" value="4" checked> <label class="form-check-label fw-bold" for="level4">💥 Extremo</label>
                                                </div>
                                                <small class="text-muted d-block">Velocidade: 15.000 itens/batch</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-3 p-3 bg-white rounded border">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong id="currentConfig">Configuração Atual:</strong>
                                            <span id="configDetails" class="text-muted">15.000 itens por lote</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card bg-light mb-3">
                            <div class="card-header bg-info text-white">
                                <h6 class="mb-0">
                                    <i class="bi bi-sliders me-2"></i>
                                    Modo de Importação (NÃO USADO SEM TMDB)
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="form-check mb-3 p-3 border rounded bg-white">
                                    <input class="form-check-input" type="radio" name="import_mode" id="mode_add_always" value="1" checked>
                                    <label class="form-check-label d-block" for="mode_add_always">
                                        <strong class="d-flex align-items-center mb-2"><i class="bi bi-plus-circle-fill text-success me-2 fs-5"></i>Adicionar Sempre (Padrão)</strong>
                                        <small class="text-muted d-block ms-4">Adiciona <strong>todo o conteúdo</strong> como novos registros.</small>
                                    </label>
                                </div>
                                </div>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" id="btnUpload">
                                <i class="bi bi-cloud-upload me-2"></i>
                                Iniciar Processamento
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4" id="progressContainer" style="display: none;">
        <div class="col-lg-10 mx-auto">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="bi bi-hourglass-split me-2"></i>
                        Processando M3U...
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3 text-center">
                        <div class="col-md-3">
                            <div class="border rounded p-2 bg-light">
                                <small class="text-muted d-block">Modo Performance</small>
                                <strong id="statMode">Extremo</strong>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-2 bg-light">
                                <small class="text-muted d-block">Tamanho do Lote</small>
                                <strong id="statBatchSize">15000</strong>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-2 bg-light">
                                <small class="text-muted d-block">Importação</small>
                                <strong id="statRam">Rápida (Sem TMDB)</strong>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border rounded p-2 bg-light">
                                <small class="text-muted d-block">Status</small>
                                <strong id="statStatus" class="text-warning">Processando...</strong>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-2">
                            <span id="progressText">Iniciando...</span>
                            <span id="progressPercent">0%</span>
                        </div>
                        <div class="progress" style="height: 25px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated"
                                 id="progressBar" role="progressbar" style="width: 0%"></div>
                        </div>
                    </div>
                    <div class="row text-center mb-3">
                        <div class="col-3">
                            <div class="border rounded p-2">
                                <small class="text-muted d-block">Processados</small>
                                <strong id="statProcessed">0</strong>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="border rounded p-2">
                                <small class="text-muted d-block">Total</small>
                                <strong id="statTotal">0</strong>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="border rounded p-2">
                                <small class="text-muted d-block">Velocidade</small>
                                <strong id="statSpeed">0/s</strong>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="border rounded p-2">
                                <small class="text-muted d-block">Tempo</small>
                                <strong id="statTime">0s</strong>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-3 bg-dark text-light">
                        <div class="card-header">
                            <h6 class="mb-0">Console de Debug</h6>
                        </div>
                        <div class="card-body p-2" style="max-height: 150px; overflow-y: auto; font-family: monospace; font-size: 0.8rem;" id="debugConsole">
                            <div class="text-success">[INFO] Sistema iniciado</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">Log de Importação</h6>
                        </div>
                        <div class="card-body p-2" style="max-height: 250px; overflow-y: auto;" id="logContainer">
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button class="btn btn-danger" id="btnCancel" style="display: none;">
                        <i class="bi bi-x-circle me-2"></i>Cancelar
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// 5. Inclui o seu footer (que carrega Bootstrap JS, SweetAlert, etc.)
require_once("footer.php"); 
?>

<script>
// ============================================================================
// CONFIGURAÇÕES DE PERFORMANCE (SÓ ENVIA O batchSize)
// ============================================================================
const PERFORMANCE_CONFIGS = {
    1: { name: 'Econômico', batchSize: 500, ram: '128MB', delay: 100, maxInsertValues: 100 },
    2: { name: 'Padrão',  batchSize: 2000, ram: '256MB', delay: 50, maxInsertValues: 500 },
    3: { name: 'Turbo', batchSize: 8000, ram: '512MB',  delay: 25, maxInsertValues: 2000 },
    4: { name: 'Extremo', batchSize: 15000, ram: '1GB', delay: 10, maxInsertValues: 5000 }
};
// ============================================================================
// VARIÁVEIS GLOBAIS
// ============================================================================
let sessionId = null;
let currentPage = 0;
let totalItems = 0;
let processedItems = 0;
let startTime = 0;
let isProcessing = false;
let currentPerformanceLevel = 4; // Padrão Extremo
let currentBatchSize = 15000;    // Padrão Extremo
let currentImportMode = 1;
// ============================================================================
// VALIDAR URL
// ============================================================================
function validateUrl() {
    const urlInput = document.getElementById('m3u_url');
    const urlError = document.getElementById('urlError');
    const url = urlInput.value.trim();
    if (urlError) urlError.style.display = 'none';
    if (!url) return false;
    if (!url.match(/^https?:\/\//i)) {
        if (urlError) {
            urlError.textContent = 'A URL deve começar com http:// ou https://';
            urlError.style.display = 'block';
        }
        debug('Erro: URL deve começar com http:// ou https://', 'error');
        return false;
    }
    try { new URL(url); } catch (e) {
        if (urlError) {
            urlError.textContent = 'URL inválida. Verifique o formato.';
            urlError.style.display = 'block';
        }
        debug('Erro: URL com formato inválido', 'error');
        return false;
    }
    debug(`✅ URL validada: ${url}`, 'success');
    return true;
}
// ============================================================================
// VALIDAÇÃO DE ARQUIVO
// ============================================================================
function validateFile() {
    const fileInput = document.getElementById('m3u_file');
    const fileError = document.getElementById('fileError');
    const file = fileInput.files[0];
    fileError.style.display = 'none';
    if (!file) return true;
    const maxSize = 512 * 1024 * 1024;
    if (file.size > maxSize) {
        fileError.textContent = 'Arquivo muito grande. Tamanho máximo: 512MB';
        fileError.style.display = 'block';
        fileInput.value = '';
        return false;
    }
    const allowedExtensions = ['.m3u', '.m3u8', '.txt'];
    const fileName = file.name.toLowerCase();
    const hasValidExtension = allowedExtensions.some(ext => fileName.endsWith(ext));
    if (!hasValidExtension) {
        fileError.textContent = 'Tipo de arquivo inválido. Use .m3u, .m3u8 ou .txt';
        fileError.style.display = 'block';
        fileInput.value = '';
        return false;
    }
    if (file.size === 0) {
        fileError.textContent = 'Arquivo vazio. Selecione um arquivo válido.';
        fileError.style.display = 'block';
        fileInput.value = '';
        return false;
    }
    debug(`Arquivo validado: ${file.name} (${(file.size / 1024 / 1024).toFixed(2)}MB)`);
    return true;
}
// ============================================================================
// INICIALIZAÇÃO
// ============================================================================
document.addEventListener('DOMContentLoaded', function() {
    updatePerformanceCards();
    document.getElementById('btnAutoDetect').addEventListener('click', autoDetectPerformance);
    document.querySelectorAll('input[name="performance_level"]').forEach(radio => {
        radio.addEventListener('change', updatePerformanceConfig);
    });
    document.querySelectorAll('input[name="import_mode"]').forEach(radio => {
        radio.addEventListener('change', updateImportMode);
    });
    document.getElementById('m3u_file').addEventListener('change', validateFile);
    document.getElementById('m3u_url').addEventListener('blur', validateUrl);
});
// ============================================================================
// ATUALIZAR MODO DE IMPORTAÇÃO
// ============================================================================
function updateImportMode() {
    const selectedMode = document.querySelector('input[name="import_mode"]:checked').value;
    currentImportMode = parseInt(selectedMode);
    const modeNames = { 1: 'Adicionar Sempre', 2: 'Atualização Inteligente', 3: 'Balanceamento' };
    debug(`Modo de importação alterado para: ${modeNames[currentImportMode]}`);
}
// ============================================================================
// ATUALIZAR CARDS DE PERFORMANCE
// ============================================================================
function updatePerformanceCards() {
    document.querySelectorAll('.performance-card').forEach(card => {
        const level = parseInt(card.dataset.level);
        const radio = card.querySelector('input[type="radio"]');
        if (radio.checked) {
            card.classList.add('border-primary', 'bg-primary', 'text-white');
            card.classList.remove('border-light');
            currentPerformanceLevel = level;
            currentBatchSize = PERFORMANCE_CONFIGS[level].batchSize;
            updateConfigDisplay();
        } else {
            card.classList.remove('border-primary', 'bg-primary', 'text-white');
            card.classList.add('border-light');
        }
    });
}
// ============================================================================
// ATUALIZAR CONFIGURAÇÃO
// ============================================================================
function updatePerformanceConfig() {
    updatePerformanceCards();
    debug(`Modo de performance alterado para: ${PERFORMANCE_CONFIGS[currentPerformanceLevel].name}`);
}
// ============================================================================
// ATUALIZAR DISPLAY DA CONFIG
// ============================================================================
function updateConfigDisplay() {
    const config = PERFORMANCE_CONFIGS[currentPerformanceLevel];
    document.getElementById('currentConfig').textContent = `Configuração Atual: ${config.name}`;
    document.getElementById('configDetails').textContent = 
        `${config.batchSize} itens por lote`; // Removida a RAM
}
// ============================================================================
// AUTO-DETECT DE PERFORMANCE
// ============================================================================
function autoDetectPerformance() {
    const memory = navigator.deviceMemory || 4; // GB
    const cores = navigator.hardwareConcurrency || 4;
    let recommendedLevel = 1;
    if (memory >= 8 && cores >= 8) recommendedLevel = 4;
    else if (memory >= 4 && cores >= 4) recommendedLevel = 3;
    else if (memory >= 2 && cores >= 2) recommendedLevel = 2;
    else recommendedLevel = 1;
    document.getElementById(`level${recommendedLevel}`).checked = true;
    updatePerformanceConfig();
    debug(`Auto-detect: ${memory}GB RAM, ${cores} cores - Recomendado: ${PERFORMANCE_CONFIGS[recommendedLevel].name}`);
    Swal.fire('Detectado!', `Sistema detectado: ${memory}GB RAM, ${cores} cores\nRecomendado: ${PERFORMANCE_CONFIGS[recommendedLevel].name}`, 'info');
}
// ============================================================================
// DEBUG HELPER
// ============================================================================
function debug(message, type = 'info') {
    const debugConsole = document.getElementById('debugConsole');
    const time = new Date().toLocaleTimeString();
    const colors = { info: 'text-info', success: 'text-success', error: 'text-danger', warning: 'text-warning' };
    const logLine = document.createElement('div');
    logLine.className = colors[type] || 'text-light';
    logLine.textContent = `[${time}] [${type.toUpperCase()}] ${message}`;
    debugConsole.appendChild(logLine);
    debugConsole.scrollTop = debugConsole.scrollHeight;
    console.log(`[M3U] ${message}`);
}
// ============================================================================
// SUBMIT DO FORMULÁRIO
// ============================================================================
document.getElementById('uploadForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    // [ESSENCIAL] Adiciona o Token de Sessão ao FormData
    // O SESSION_TOKEN é definido no seu 'menu.php'
    const formData = new FormData(this);
    formData.append('token', typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '');

    const selectedMode = document.querySelector('input[name="import_mode"]:checked').value;
    currentImportMode = parseInt(selectedMode);
    
    debug('Formulário enviado');
    debug(`Modo de performance: ${PERFORMANCE_CONFIGS[currentPerformanceLevel].name}`);
    
    if (isProcessing) {
        Swal.fire('Atenção', 'Já existe um processamento em andamento', 'warning');
        return;
    }
    
    const activeTab = document.querySelector('.tab-pane.active').id;
    debug(`Aba ativa: ${activeTab}`);
    
    // Adiciona os parâmetros que faltavam no FormData
    formData.append('performance_level', currentPerformanceLevel);
    formData.append('batch_size', currentBatchSize);
    formData.append('import_mode', currentImportMode);
    
    if (activeTab === 'tabFile') {
        const fileInput = document.getElementById('m3u_file');
        if (!fileInput.files || !fileInput.files[0]) {
            Swal.fire('Erro', 'Selecione um arquivo M3U na aba "Upload de Arquivo"', 'error');
            debug('Erro: Nenhum arquivo selecionado', 'error');
            return;
        }
        if (!validateFile()) return;
    } else if (activeTab === 'tabUrl') {
        const urlInput = document.getElementById('m3u_url');
        const url = urlInput.value.trim();
        if (!url) {
            Swal.fire('Erro', 'Informe uma URL válida na aba "URL Externa"', 'error');
            debug('Erro: URL vazia', 'error');
            return;
        }
        if (!validateUrl()) return;
    } else {
        Swal.fire('Erro', 'Nenhuma fonte de dados selecionada', 'error');
        debug('Erro: Aba não reconhecida', 'error');
        return;
    }
    
    debug('Enviando para API...');
    document.body.style.cursor = 'wait';
    document.getElementById('btnUpload').disabled = true;
    
    try {
        // [IMPORTANTE] Este é o arquivo que precisa existir na sua pasta /api/
        const response = await fetch('api/processar_lista_m3u.php', {
            method: 'POST',
            body: formData
        });
        
        debug(`Resposta recebida: ${response.status}`);
        
        const text = await response.text();
        debug(`Resposta bruta (primeiros 500 chars): ${text.substring(0, 500)}...`);
        
        if (!response.ok) {
            try {
                const errorData = JSON.parse(text);
                throw new Error(errorData.message || `Erro HTTP: ${response.status} - ${response.statusText}`);
            } catch (e) {
                throw new Error(`Erro HTTP: ${response.status} - ${response.statusText}. Resposta não-JSON.`);
            }
        }

        let data;
        try {
            data = JSON.parse(text);
        } catch (parseError) {
            debug(`Erro ao parsear JSON: ${parseError.message}`, 'error');
            debug(`Resposta completa: ${text}`, 'error');
            throw new Error('Resposta inválida do servidor. Verifique o console de debug.');
        }
        
        debug(`JSON parseado com sucesso`);
        document.body.style.cursor = 'default';
        document.getElementById('btnUpload').disabled = false;
        
        if (data.success) {
            sessionId = data.session_id;
            totalItems = data.total;
            processedItems = 0;
            currentPage = 0;
            startTime = Date.now();
            isProcessing = true;
            debug(`✅ Sessão iniciada: ${sessionId}`, 'success');
            debug(`✅ Total de itens: ${totalItems}`, 'success');
            debug(`✅ Performance: ${PERFORMANCE_CONFIGS[currentPerformanceLevel].name}`, 'success');
            document.getElementById('progressContainer').style.display = 'block';
            document.getElementById('statTotal').textContent = totalItems;
            document.getElementById('statMode').textContent = PERFORMANCE_CONFIGS[currentPerformanceLevel].name;
            document.getElementById('statBatchSize').textContent = currentBatchSize;
            document.getElementById('statRam').textContent = "Sem TMDB"; // <-- Mudado
            document.getElementById('btnCancel').style.display = 'inline-block';
            document.getElementById('progressContainer').scrollIntoView({ behavior: 'smooth' });
            debug('🚀 Iniciando processamento de batches...', 'success');
            processNextBatch();
        } else {
            debug(`❌ Erro: ${data.message}`, 'error');
            Swal.fire('Erro', data.message || 'Erro desconhecido', 'error');
        }
    } catch (error) {
        document.body.style.cursor = 'default';
        document.getElementById('btnUpload').disabled = false;
        debug(`❌ Erro fatal: ${error.message}`, 'error');
        Swal.fire('Erro na Requisição', error.message, 'error');
    }
});
// ============================================================================
// PROCESSAR PRÓXIMO BATCH
// ============================================================================
async function processNextBatch() {
    if (!isProcessing) {
        debug('Processamento cancelado', 'warning');
        return;
    }
    debug(`Processando batch ${currentPage} (${processedItems}/${totalItems}) - Tamanho: ${currentBatchSize}`);
    try {
        const formData = new FormData();
        formData.append('process_batch', '1');
        formData.append('session_id', sessionId);
        formData.append('page', currentPage);
        formData.append('batch_size', currentBatchSize);
        formData.append('token', typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '');

        const response = await fetch('api/processar_lista_m3u.php', {
            method: 'POST',
            body: formData
        });
        debug(`Batch ${currentPage} - Status: ${response.status}`);
        
        const text = await response.text();
        let data;
        
        if (!response.ok) {
            try {
                const errorData = JSON.parse(text);
                throw new Error(errorData.message || `Erro HTTP: ${response.status}`);
            } catch (e) {
                 throw new Error(`Erro HTTP: ${response.status}. Resposta: ${text.substring(0, 100)}`);
            }
        }
        
        try {
            data = JSON.parse(text);
        } catch (parseError) {
            debug(`Erro ao parsear JSON do batch: ${parseError.message}`, 'error');
            throw new Error('Resposta inválida do servidor no batch');
        }
        if (data.success) {
            const batchProcessed = data.details.processed || 0;
            processedItems += batchProcessed;
            debug(`Batch ${currentPage} processado: ${batchProcessed} itens`, 'success');
            updateProgress();
            if (data.details.details && Array.isArray(data.details.details)) {
                data.details.details.forEach(item => {
                    addLog(item.tipo, item.nome, item.mensagem);
                });
            }
            if (data.is_complete) {
                debug('Processamento completo!', 'success');
                finishProcessing();
            } else {
                currentPage++;
                const delay = PERFORMANCE_CONFIGS[currentPerformanceLevel].delay;
                setTimeout(processNextBatch, delay);
            }
        } else {
            debug(`Erro no batch: ${data.message}`, 'error');
            isProcessing = false;
            Swal.fire('Erro', data.message, 'error');
        }
    } catch (error) {
        debug(`Erro fatal no batch: ${error.message}`, 'error');
        isProcessing = false;
        Swal.fire('Erro', error.message, 'error');
    }
}
// ============================================================================
// ATUALIZAR PROGRESSO
// ============================================================================
function updateProgress() {
    const percent = totalItems > 0 ? Math.round((processedItems / totalItems) * 100) : 100;
    const elapsed = Math.round((Date.now() - startTime) / 1000);
    const speed = elapsed > 0 ? Math.round(processedItems / elapsed) : 0;
    document.getElementById('progressBar').style.width = percent + '%';
    document.getElementById('progressPercent').textContent = percent + '%';
    document.getElementById('progressText').textContent = `Processando... ${processedItems} de ${totalItems}`;
    document.getElementById('statProcessed').textContent = processedItems;
    document.getElementById('statSpeed').textContent = speed + '/s';
    document.getElementById('statTime').textContent = elapsed + 's';
    if (percent >= 100) {
        document.getElementById('statStatus').textContent = 'Concluído';
        document.getElementById('statStatus').className = 'text-success';
    } else if (percent >= 75) {
        document.getElementById('statStatus').textContent = 'Finalizando';
        document.getElementById('statStatus').className = 'text-info';
    } else if (percent >= 50) {
        document.getElementById('statStatus').textContent = 'Metade';
        document.getElementById('statStatus').className = 'text-primary';
    }
}
// ============================================================================
// ADICIONAR LOG
// ============================================================================
function addLog(tipo, nome, mensagem) {
    const logContainer = document.getElementById('logContainer');
    const logItem = document.createElement('div');
    logItem.className = 'p-2 border-bottom';
    logItem.style.fontSize = '0.85rem';
    let icon = 'check-circle';
    let color = 'success';
    if (tipo.toLowerCase() === 'erro' || mensagem.includes('Erro')) {
        icon = 'x-circle';
        color = 'danger';
    } else if (tipo.toLowerCase() === 'aviso' || mensagem.includes('já existe')) {
        icon = 'info-circle';
        color = 'warning';
    }
    logItem.innerHTML = `
        <i class="bi bi-${icon} text-${color} me-2"></i>
        <strong>${tipo}:</strong> ${nome} - <em>${mensagem}</em>
    `;
    logContainer.appendChild(logItem);
    while (logContainer.children.length > 30) {
        logContainer.removeChild(logContainer.firstChild);
    }
    logContainer.scrollTop = logContainer.scrollHeight;
}
// ============================================================================
// FINALIZAR PROCESSAMENTO
// ============================================================================
function finishProcessing() {
    isProcessing = false;
    const elapsed = Math.round((Date.now() - startTime) / 1000);
    const speed = elapsed > 0 ? Math.round(processedItems / elapsed) : 0;
    document.getElementById('progressBar').classList.remove('progress-bar-animated');
    document.getElementById('progressBar').classList.add('bg-success');
    document.getElementById('progressText').textContent = `✅ Concluído! ${processedItems} itens em ${elapsed}s`;
    document.getElementById('btnCancel').style.display = 'none';
    document.getElementById('statStatus').textContent = 'Concluído';
    document.getElementById('statStatus').className = 'text-success';
    debug(`Importação finalizada: ${processedItems} itens em ${elapsed}s (${speed}/s)`, 'success');
    Swal.fire('Concluído!', `✅ Importação finalizada!\n${processedItems} itens processados em ${elapsed}s\nModo: ${PERFORMANCE_CONFIGS[currentPerformanceLevel].name}`, 'success');
    setTimeout(() => {
        if (confirm('Deseja fazer uma nova importação?')) {
            location.reload();
        }
    }, 1000);
}
// ============================================================================
// CANCELAR
// ============================================================================
document.getElementById('btnCancel').addEventListener('click', function() {
    if (confirm('Cancelar processamento?')) {
        isProcessing = false;
        debug('Processamento cancelado pelo usuário', 'warning');
        document.getElementById('statStatus').textContent = 'Cancelado';
        document.getElementById('statStatus').className = 'text-danger';
        Swal.fire('Cancelado', 'Processamento cancelado pelo usuário', 'warning');
    }
});
</script>