<?php
// canal.php - Versão MPEG-TS com Debug
require_once("libs/lib.php");

$user = isset($_COOKIE['xuserm']) ? $_COOKIE['xuserm'] : '';
$pwd = isset($_COOKIE['xpwdm']) ? $_COOKIE['xpwdm'] : '';
$id = trim($_REQUEST['stream']);
$canal = urldecode($_REQUEST['canal']);
$idcatg = trim($_REQUEST['catg']);
$sessao = isset($_REQUEST['sessao']) ? $_REQUEST['sessao'] : '';

$stream_url = "proxy_player.php?user=$user&pwd=$pwd&stream=$id&tipo=live";
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <?php include("inc/head.php"); ?>
    <meta charset="utf-8">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/mpegts.js/1.7.3/mpegts.min.js"></script>
    <style>
        body { background-color: #000; color: #fff; }
        .video-container {
            width: 100%; height: 100vh; max-height: 650px;
            background: #000; display: flex; justify-content: center; align-items: center;
            position: relative;
        }
        video { width: 100%; height: 100%; }
        /* Caixa de Log de Erros na Tela */
        #debug-log {
            position: absolute; top: 10px; left: 10px;
            background: rgba(0,0,0,0.8); color: #0f0;
            padding: 10px; font-family: monospace; font-size: 12px;
            max-width: 400px; z-index: 1000; display: none;
            border: 1px solid #0f0;
        }
    </style>
</head>
<body onselectstart="return false" oncontextmenu="return false">

    <div id="single-video-fullwidth" class="container-fluid standard-bg">
         <div class="row header-top"><?php include("inc/header.php"); ?></div>
         <div class="row home-mega-menu">
            <div class="col-md-12">
                <nav class="navbar navbar-default">
                   <div class="collapse navbar-collapse js-navbar-collapse megabg dropshd ">
                     <ul class="nav navbar-nav"><?php include("inc/menu.php"); ?></ul>
                   </div>
                </nav>
            </div>
         </div>

         <div class="row">
            <div class="col-lg-2 col-md-3 hidden-sm hidden-xs">
               <aside class="dark-bg">
                  <h2 class="icon" style="color:#fff;">Canais</h2>
                  <ul class="sidebar-links" style="max-height:600px; overflow-y:auto;">
                    </ul>
               </aside>
            </div>

            <div class="col-lg-10 col-md-9 col-sm-12">
               <div id="single-video-fullwidth-wrapper">
                  <article class="post-video">
                     <div class="video-info dropshd">
                        
                        <div class="video-container">
                            <div id="debug-log">Iniciando Player...</div>
                            <video id="videoElement" controls autoplay></video>
                        </div>
                        
                        <h2 class="title main-head-title" style="padding: 10px;"><?php echo $canal; ?></h2>
                        <div class="metabox" style="padding:0 10px;">
                           <span class="meta-i">Player: MpegTS.js (Direct)</span>
                        </div>

                     </div>
                  </article>
               </div>
            </div>
         </div>
    </div>

    <?php include("inc/scripts.php"); ?>

    <script>
        var videoElement = document.getElementById('videoElement');
        var logBox = document.getElementById('debug-log');
        var streamUrl = "<?php echo $stream_url; ?>";

        function log(msg) {
            logBox.style.display = 'block';
            logBox.innerHTML += msg + "<br>";
            console.log(msg);
        }

        if (mpegts.getIsSupported()) {
            var player = mpegts.createPlayer({
                type: 'mpegts', 
                isLive: true,
                url: streamUrl,
                enableStashBuffer: false,
                liveBufferLatencyChasing: true
            });
            
            player.attachMediaElement(videoElement);
            player.load();
            
            player.on(mpegts.Events.LOADING_COMPLETE, function() { log("Carregamento completado (Fim do stream?)"); });
            player.on(mpegts.Events.RECOVERED_EARLY_EOF, function() { log("Recuperando de fim de arquivo..."); });
            
            // Captura erros detalhados
            player.on(mpegts.Events.ERROR, function(type, details, data) {
                log("<span style='color:red'>ERRO: " + type + " - " + details + "</span>");
            });

            var playPromise = player.play();
            if (playPromise !== undefined) {
                playPromise.catch(error => {
                    log("Autoplay bloqueado pelo navegador. Clique no Play.");
                });
            }
        } else {
            log("Seu navegador não suporta MPEG-TS.");
        }
    </script>
</body>
</html>