<?php
// diagnostico.php - Teste de Conexão Rápida
// NÃO EDITE NADA, APENAS RODE NO NAVEGADOR

// Configurações
$DNS = "http://topiptv.tvsbr.top"; // Seu DNS
$user = $_GET['user'] ?? 'jean2';
$pass = $_GET['pwd'] ?? 'jean2';
$stream = $_GET['stream'] ?? '1779';

// URL que estamos testando (HLS)
$url_teste = "$DNS/live/$user/$pass/$stream.m3u8";

echo "<h1>Diagnóstico de Conexão</h1>";
echo "<p><strong>Testando URL:</strong> $url_teste</p>";

// Inicializa CURL com timeout curto
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url_teste);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Segue redirecionamento
curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Maximo 10 segundos
curl_setopt($ch, CURLOPT_USERAGENT, 'VLC/3.0.0-git LibVLC/3.0.0-git');

// Pega apenas os cabeçalhos primeiro para ver o tipo
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, false); // Precisamos do corpo para ver se é texto
curl_setopt($ch, CURLOPT_RANGE, "0-500"); // Baixa apenas os primeiros 500 bytes

$response = curl_exec($ch);
$info = curl_getinfo($ch);
$erro = curl_error($ch);
curl_close($ch);

echo "<hr>";

if ($erro) {
    echo "<h3 style='color:red'>ERRO DE CONEXÃO: $erro</h3>";
    echo "<p>O servidor não respondeu em 10 segundos. Pode estar offline ou bloqueando o IP da hospedagem.</p>";
} else {
    echo "<h3>Resposta do Servidor:</h3>";
    echo "<strong>Código HTTP:</strong> " . $info['http_code'] . " (200 é o correto)<br>";
    echo "<strong>Tipo de Conteúdo (Content-Type):</strong> " . $info['content_type'] . "<br>";
    echo "<strong>URL Final (caso tenha redirecionado):</strong> " . $info['url'] . "<br>";
    
    echo "<h3>Conteúdo (Primeiros 500 caracteres):</h3>";
    // Separa o header do body para mostrar limpo
    $header_size = $info['header_size'];
    $body = substr($response, $header_size);
    
    echo "<textarea style='width:100%; height:200px; background:#f0f0f0;'>" . htmlspecialchars($body) . "</textarea>";
    
    echo "<h3>Análise:</h3>";
    if (strpos($body, '#EXTM3U') !== false) {
        echo "<strong style='color:green'>SUCESSO! O servidor retornou uma lista M3U8 válida. O Proxy deveria funcionar.</strong>";
    } elseif (strpos($info['content_type'], 'video') !== false || strpos($body, 'G@') !== false) { // G@ é sinal de mpeg-ts
        echo "<strong style='color:orange'>ATENÇÃO: O servidor retornou VÍDEO DIRETO (.ts) em vez de lista (.m3u8). O Proxy precisa ser ajustado para modo Stream.</strong>";
    } else {
        echo "<strong style='color:red'>ERRO: O servidor retornou algo desconhecido ou erro HTML.</strong>";
    }
}
?>