<?php
// Arquivo: proxy_player.php
// VERSÃO: ULTRA STREAMING (CURL CALLBACK)

// Configurações do seu DNS
$DNS_IPTV = "http://topiptv.tvsbr.top"; 

// 1. Configurações Críticas de Performance
set_time_limit(0); // Sem limite de tempo
ini_set('display_errors', 0);
error_reporting(0);

// Desativa cache do Nginx/Apache (Essencial para IPTV)
header('X-Accel-Buffering: no'); 
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Limpa buffers do PHP
if (function_exists('apache_setenv')) { @apache_setenv('no-gzip', 1); }
@ini_set('zlib.output_compression', 0);
@ini_set('implicit_flush', 1);
for ($i = 0; $i < ob_get_level(); $i++) { ob_end_flush(); }
ob_implicit_flush(1);

// Captura dados
$user = $_GET['user'] ?? '';
$pwd  = $_GET['pwd']  ?? '';
$stream = $_GET['stream'] ?? '';
$tipo = $_GET['tipo'] ?? 'live';

if (empty($user) || empty($pwd) || empty($stream)) {
    http_response_code(400);
    die("Faltam dados.");
}

// Monta URL (Força .ts para LIVE para garantir vídeo bruto)
$ext = ($tipo == 'movie') ? 'mp4' : 'ts';
$url_alvo = "$DNS_IPTV/$tipo/$user/$pwd/$stream.$ext";

// Headers de Vídeo
header("Content-Type: video/mp2t");
header("Access-Control-Allow-Origin: *");

// --- CURL DE ALTA PERFORMANCE ---
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url_alvo);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'VLC/3.0.0-git LibVLC/3.0.0-git');
curl_setopt($ch, CURLOPT_BUFFERSIZE, 64000); // Buffer otimizado

// A Mágica: Função que recebe os dados e joga na tela imediatamente
curl_setopt($ch, CURLOPT_WRITEFUNCTION, function($curl, $data) {
    echo $data;
    return strlen($data);
});

curl_exec($ch);
curl_close($ch);
exit;
?>