<?php
// Usando um caminho absoluto para o arquivo de conexão
require_once $_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php';

// Ativar a exibição de erros para depuração
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 1. Validação de Segurança
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['confirmacao']) || $_POST['confirmacao'] !== 'EXCLUIR TUDO' || !isset($_POST['tipo'])) {
    die("Acesso negado ou confirmação inválida. Operação cancelada.");
}

$conn = conectar_bd();
if (!$conn) {
    die("Falha fatal: Não foi possível conectar ao banco de dados.");
}

$tipo = $_POST['tipo'];
$sql = '';

// 2. Determina qual comando SQL executar com base no tipo
switch ($tipo) {
    case 'filme':
        // Apaga todos os registros do tipo 'movie' da tabela streams
        $sql = "DELETE FROM streams WHERE stream_type = 'movie'";
        break;
    case 'serie':
        // Apaga TODOS os registros da tabela de episódios e depois de séries
        // Usamos duas queries para garantir a limpeza completa
        $conn->exec("TRUNCATE TABLE series_episodes");
        $sql = "TRUNCATE TABLE series";
        break;
    case 'canal':
        // Apaga todos os registros do tipo 'live' da tabela streams
        $sql = "DELETE FROM streams WHERE stream_type = 'live'";
        break;
    default:
        die("Tipo de conteúdo inválido. Operação cancelada.");
}

// 3. Executa a exclusão
try {
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    
    // Se chegou aqui, a operação foi bem-sucedida. Redireciona de volta para a página de gerenciamento.
    header('Location: index.php?limpeza=sucesso');
    exit();

} catch (PDOException $e) {
    // Se ocorrer um erro no banco de dados
    die("Erro ao executar a limpeza: " . $e->getMessage());
}