<?php
// Arquivo: /api/api_conexoes.php
// [CORREÇÃO v13 - Corrigido nome da coluna de nível (de 'nivel' para 'admin')]

ini_set('display_errors', 0);
error_reporting(0);
header('Content-Type: application/json; charset=utf-8');

require_once(__DIR__ . '/controles/db.php');
session_start();

function sendError($message, $http_code = 400) {
    http_response_code($http_code); 
    echo json_encode(['status' => 'error', 'message' => $message]);
    exit;
}

$conexao = conectar_bd();
if (!$conexao) { sendError('Falha ao conectar ao banco de dados.', 500); }
$conexao->exec("SET NAMES 'utf8mb4'");

$data = json_decode(file_get_contents('php://input'), true);
if (json_last_error() !== JSON_ERROR_NONE) { $data = $_POST; }

$token_enviado = $data['token'] ?? '';
if (empty($token_enviado)) { sendError('Acesso negado: Token de autenticação não fornecido.', 403); }

try {
    
    // ================================================================
    // ### CORREÇÃO AQUI ###
    // Trocamos 'nivel' por 'admin', que é o nome correto da sua coluna
    // ================================================================
    $sql_token = "SELECT id, admin FROM admin WHERE token = :token";
    // ================================================================
    
    $stmt_token = $conexao->prepare($sql_token);
    $stmt_token->bindParam(':token', $token_enviado, PDO::PARAM_STR);
    $stmt_token->execute();
    $admin_logado = $stmt_token->fetch(PDO::FETCH_ASSOC);

    if (!$admin_logado || empty($admin_logado['id'])) { 
        sendError('Acesso negado: Token inválido ou expirado.', 403); 
    }
    
    // ================================================================
    // ### CORREÇÃO AQUI ###
    // Pegamos o valor da coluna 'admin' e salvamos em $admin_nivel
    // ================================================================
    $admin_id = $admin_logado['id'];
    $admin_nivel = $admin_logado['admin']; // <-- CORRIGIDO
    // ================================================================

} catch (PDOException $e) { 
    sendError('Erro no banco de dados durante a validação do token.', 500); 
}

$action = $data['action'] ?? '';

try {
    if ($action === 'get_online_users') {
        
        $sql = "SELECT c.id, c.usuario, c.ip, c.user_agent, c.ultima_atividade,
                       cl.id AS userid,
                       s.name AS stream_display_name,
                       s.stream_type,
                       COUNT(c.id) OVER (PARTITION BY c.usuario) AS total_conexoes
                FROM conexoes c
                LEFT JOIN clientes cl ON c.usuario = cl.usuario
                LEFT JOIN streams s ON c.stream_id = s.id"; 
        
        $params = [];
        $where_clauses = [];

        // Esta lógica agora vai funcionar, pois $admin_nivel terá o valor (1 ou 0)
        if ($admin_nivel != 1) { 
            $where_clauses[] = "cl.admin_id = :admin_id";
            $params[':admin_id'] = $admin_id;
        }

        if (count($where_clauses) > 0) {
            $sql .= " WHERE " . implode(' AND ', $where_clauses);
        }
        
        $sql .= " ORDER BY c.ultima_atividade DESC";
        
        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $conexoes_ativas = count($users);
        $usuarios_unicos = count(array_unique(array_column($users, 'userid')));
        $ips_unicos = count(array_unique(array_column($users, 'ip')));

        echo json_encode([
            'status' => 'success',
            'data' => $users,
            'stats' => [
                'conexoes_ativas' => $conexoes_ativas,
                'usuarios_unicos' => $usuarios_unicos,
                'ips_unicos' => $ips_unicos
            ]
        ]);
        exit;

    } elseif ($action === 'kick_user') {
        
        $connection_id = $data['id'] ?? 0;
        if (empty($connection_id)) { sendError('ID da conexão não fornecido.'); }
        
        $sql = "DELETE FROM conexoes WHERE id = :id";
        $params = [':id' => $connection_id];
        
        // Esta lógica também está correta agora
        if ($admin_nivel != 1) {
            $sql .= " AND usuario IN (SELECT usuario FROM clientes WHERE admin_id = :admin_id)";
            $params[':admin_id'] = $admin_id;
        }
        
        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Conexão derrubada com sucesso.']);
        } else {
            sendError('Não foi possível derrubar a conexão. (Permissão negada ou conexão já caiu)', 404);
        }
        exit;

    } else {
        sendError('Ação inválida.', 400);
    }

} catch (Throwable $t) {
    sendError('Erro fatal no servidor: ' . $t->getMessage(), 500);
}
?>