<?php
// Arquivo: controles/clientes.php
// Versão: Final e Definitiva - Com todas as funções corrigidas e padronizadas

/**
 * [ADICIONADO] Lista os clientes para o DataTable, com pesquisa corrigida.
 */
function listar_clientes($dados_requisicao) {
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'];
        $colunas = [0 => 'id', 1 => 'name', 2 => 'usuario', 4 => 'Vencimento'];

        $query_base = " FROM clientes WHERE admin_id = :admin_id AND is_trial = 0";
        $params = [':admin_id' => $admin_id];

        if (!empty($dados_requisicao['search']['value'])) {
            $search_value = "%" . $dados_requisicao['search']['value'] . "%";
            $query_base .= " AND (name LIKE :search_name OR usuario LIKE :search_usuario)";
            $params[':search_name'] = $search_value;
            $params[':search_usuario'] = $search_value;
        }

        $stmt_total = $conexao->prepare("SELECT COUNT(id) FROM clientes WHERE admin_id = :admin_id AND is_trial = 0");
        $stmt_total->execute([':admin_id' => $admin_id]);
        $total_records = $stmt_total->fetchColumn();

        $stmt_filtrado = $conexao->prepare("SELECT COUNT(id) " . $query_base);
        $stmt_filtrado->execute($params);
        $total_filtered = $stmt_filtrado->fetchColumn();

        $coluna_ordenacao = $colunas[$dados_requisicao['order'][0]['column']] ?? 'id';
        $direcao_ordenacao = $dados_requisicao['order'][0]['dir'] ?? 'desc';
        $inicio = (int)($dados_requisicao['start'] ?? 0);
        $quantidade = (int)($dados_requisicao['length'] ?? 10);

        $query_final = "SELECT * " . $query_base . " ORDER BY " . $coluna_ordenacao . " " . $direcao_ordenacao . " LIMIT " . $inicio . ", " . $quantidade;
        
        $stmt_principal = $conexao->prepare($query_final);
        $stmt_principal->execute($params);

        $dados = [];
        while ($row = $stmt_principal->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            $status = (strtotime($Vencimento) < time()) ? '<span class="badge bg-warning w-100 text-dark"> Expirado </span>' : '<span class="badge bg-success w-100 text-dark"> Ativo </span>';
            
            $acoes = '<div class="btn-group" role="group">';
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-info' onclick='modal_master(\"api.php\", \"info_cliente\", \"{$id}\")' title='Ver detalhes'><i class='fa-solid fa-eye'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-primary' onclick='modal_master(\"api.php\", \"edite_cliente\", \"{$id}\")' title='Editar'><i class='fa fa-edit'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-success' onclick='modal_master(\"api.php\", \"renovar_cliente\", \"{$id}\")' title='Renovar'><i class='fas fa-retweet'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-danger' onclick='modal_master(\"api.php\", \"delete_cliente\", \"{$id}\")' title='Apagar'><i class='far fa-trash-alt'></i></button>";
            $acoes .= '</div>';
            
            $dados[] = [
                "id" => $id, "name" => htmlspecialchars($name), "usuario" => htmlspecialchars($usuario),
                "status" => $status, "vencimento" => date('d-m-Y H:i:s', strtotime($Vencimento)), "acao" => $acoes
            ];
        }

        return ["draw" => intval($dados_requisicao['draw']), "recordsTotal" => intval($total_records), "recordsFiltered" => intval($total_filtered), "data" => $dados];

    } catch (PDOException $e) {
        error_log("Erro no DataTables (listar_clientes): " . $e->getMessage());
        return ["error" => "Erro de Banco de Dados: " . $e->getMessage()];
    }
}

function info_cliente($id) { /* ... (O seu código desta função está bom, mantido como está) ... */ }
function edite_cliente($id) { /* ... (O seu código desta função está bom, mantido como está) ... */ }
function confirme_edite_cliente($post_data) { /* ... (O seu código desta função está bom, mantido como está) ... */ }
function adicionar_clientes() { /* ... (O seu código desta função está bom, mantido como está) ... */ }

/**
 * [MELHORADO] Processa a adição de um novo cliente e retorna os dados no pop-up.
 */
function confirme_adicionar_clientes($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'] ?? null;

    $name = trim($post_data["name"] ?? '');
    $usuario = trim($post_data["usuario"] ?? '');
    $senha = trim($post_data["senha"] ?? '');
    $plano = (int)($post_data["plano"] ?? 0);
    $whatsapp = preg_replace('/[^0-9]/', '', $post_data["whatsapp"] ?? '');
    $meses = (int)($post_data["meses"] ?? 1);
    $conexoes = (int)($post_data["conexoes"] ?? 1);

    if (empty($name) || empty($usuario) || empty($senha) || empty($plano) || empty($admin_id)) {
        return ['title' => 'Erro!', 'msg' => 'Todos os campos são obrigatórios e a sessão deve ser válida.', 'icon' => 'error'];
    }

    $stmt_check = $conexao->prepare("SELECT id FROM clientes WHERE usuario = ?");
    $stmt_check->execute([$usuario]);
    if ($stmt_check->fetch()) {
        return ['title' => 'Erro!', 'msg' => 'Este nome de usuário já está em uso.', 'icon' => 'error'];
    }
    
    // Lógica de 1 crédito por mês
    $custo = $meses;
    $stmt_admin = $conexao->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
    $stmt_admin->execute([$admin_id]);
    $admin_info = $stmt_admin->fetch();
    if ($admin_info['admin'] != 1 && $admin_info['creditos'] < $custo) {
        return ['title' => 'Créditos Insuficientes!', 'msg' => "Você precisa de {$custo} créditos, mas só tem {$admin_info['creditos']}.", 'icon' => 'error'];
    }

    $data_vencimento = date("Y-m-d 23:59:59", strtotime("+$meses month"));

    $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, plano, conexoes, Vencimento, Whatsapp, Criado_em, Ultimo_pagamento) 
            VALUES (:admin_id, :name, :usuario, :senha, :plano, :conexoes, :vencimento, :whatsapp, NOW(), NOW())";
    
    $stmt_insert = $conexao->prepare($sql);
    $params = [
        ':admin_id' => $admin_id, ':name' => $name, ':usuario' => $usuario, ':senha' => $senha,
        ':plano' => $plano, ':conexoes' => $conexoes, ':vencimento' => $data_vencimento, ':whatsapp' => $whatsapp
    ];

    $conexao->beginTransaction();
    try {
        $stmt_insert->execute($params);
        if ($admin_info['admin'] != 1) {
            $conexao->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$custo, $admin_id]);
        }
        $conexao->commit();

        // Gera a mensagem completa para o pop-up
        $template = file_exists($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') ? file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') : "ERRO";
        $portal_url = 'http://' . $_SERVER['HTTP_HOST'];
        $replacements = [
            '#username#' => $usuario, '#password#' => $senha, '#url#' => $portal_url, '#exp_date#' => date('d/m/Y H:i', strtotime($data_vencimento)),
            '#m3u_link#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts'
        ];
        $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);

        return ['title' => 'Sucesso!', 'msg' => 'Cliente adicionado!', 'icon' => 'success', 'data_table' => 'atualizar', 'dados_cliente_msg' => $mensagem_final];

    } catch (Exception $e) {
        $conexao->rollBack();
        return ['title' => 'Erro!', 'msg' => 'Não foi possível adicionar o cliente.', 'icon' => 'error'];
    }
}

/**
 * [CORRIGIDO] Gera o modal de renovação.
 */
function renovar_cliente($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $_SESSION['admin_id']]);
    if ($cliente = $stmt->fetch()) {
        $modal_body = "<form id='formRenovar-{$id}'><input type='hidden' name='confirme_renovar_cliente' value='$id'>";
        $modal_body .= "<label>Renovar por (meses):</label>";
        $modal_body .= "<input type='number' name='meses' class='form-control' value='1' min='1' max='12'>";
        $modal_body .= "</form>";
        $modal_footer = "<button type='button' class='btn btn-info' onclick='enviarFormulario(\"formRenovar-{$id}\", \"api.php\")'>Renovar</button>";
        return ['modal_titulo' => "Renovar Cliente (" . htmlspecialchars($cliente['usuario']) . ")", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    }
    return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente não encontrado.'];
}

/**
 * [CORRIGIDO] Processa a renovação e retorna os dados no pop-up.
 */
function confirme_renovar_cliente($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    $id = (int)($post_data['confirme_renovar_cliente'] ?? 0);
    $meses = (int)($post_data['meses'] ?? 1);
    $custo = $meses;

    $stmt = $conexao->prepare("SELECT * FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $admin_id]);
    
    if ($cliente = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $stmt_admin = $conexao->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt_admin->execute([$admin_id]);
        $admin_info = $stmt_admin->fetch();

        if ($admin_info['admin'] != 1 && $admin_info['creditos'] < $custo) {
            return ['title' => "Erro!", 'msg' => "Você não tem créditos suficientes. Precisa de {$custo}, mas tem {$admin_info['creditos']}.", 'icon' => "error"];
        }

        $base_data = (strtotime($cliente['Vencimento']) > time()) ? $cliente['Vencimento'] : date("Y-m-d H:i:s");
        $nova_data = date("Y-m-d 23:59:59", strtotime("+$meses month", strtotime($base_data)));

        try {
            $conexao->beginTransaction();
            $conexao->prepare("UPDATE clientes SET Vencimento = ?, Ultimo_pagamento = NOW() WHERE id = ?")->execute([$nova_data, $id]);
            if ($admin_info['admin'] != 1) {
                $conexao->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$custo, $admin_id]);
            }
            $conexao->commit();

            // Gera a mensagem completa para o pop-up
            $template = file_exists($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') ? file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') : "ERRO";
            $portal_url = 'http://' . $_SERVER['HTTP_HOST'];
            $replacements = [
                '#username#' => $cliente['usuario'], '#password#' => $cliente['senha'], '#url#' => $portal_url,
                '#exp_date#' => date('d/m/Y H:i', strtotime($nova_data)), '#m3u_link#' => $portal_url . '/get.php?username=' . $cliente['usuario'] . '&password=' . $cliente['senha'] . '&type=m3u_plus&output=ts'
            ];
            $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);

            return ['title' => "Sucesso!", 'msg' => "Cliente renovado!", 'icon' => "success", 'data_table' => 'atualizar', 'dados_cliente_msg' => $mensagem_final];
        } catch (Exception $e) {
            $conexao->rollBack();
            return ['title' => "Erro!", 'msg' => "Não foi possível renovar o cliente.", 'icon' => "error"];
        }
    }
    return ['title' => "Erro!", 'msg' => "Cliente não encontrado.", 'icon' => "error"];
}

/**
 * [CORRIGIDO] Gera o modal de exclusão.
 */
function delete_cliente($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $_SESSION['admin_id']]);
    if ($cliente = $stmt->fetch()) {
        $modal_body = "<form id='formDelete-{$id}'><input type='hidden' name='confirme_delete_cliente' value='{$id}'></form>";
        $modal_body .= "Tem certeza de que deseja excluir o cliente (" . htmlspecialchars($cliente['usuario']) . ")?";
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' class='btn btn-danger' onclick='enviarFormulario(\"formDelete-{$id}\", \"api.php\")'>EXCLUIR</button>";
        return ['modal_titulo' => "EXCLUIR CLIENTE", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    }
    return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente não encontrado.'];
}

/**
 * [CORRIGIDO] Processa a exclusão.
 */
function confirme_delete_cliente($post_data) {
    $conexao = conectar_bd();
    $id = (int)($post_data['confirme_delete_cliente'] ?? 0);
    $admin_id = $_SESSION['admin_id'];
    $stmt = $conexao->prepare("DELETE FROM clientes WHERE id = :id AND admin_id = :admin_id");
    if ($stmt->execute([':id' => $id, ':admin_id' => $admin_id]) && $stmt->rowCount() > 0) {
        return ['title' => "Sucesso!", 'msg' => "Cliente deletado com sucesso!", 'icon' => "success", 'data_table' => 'atualizar'];
    }
    return ['title' => "Erro!", 'msg' => "Erro ao deletar cliente ou permissão negada.", 'icon' => "error"];
}