<?php
// Arquivo: /api/controles/funcoes_clientes.php
// VERSÃƒO LIMPA (remove quaisquer espaÃ§os ou caracteres invisÃ­veis)

function encurtar_url($long_url) {
    if (empty($long_url) || !filter_var($long_url, FILTER_VALIDATE_URL)) return $long_url;
    $api_url = 'https://is.gd/api.php?longurl=' . urlencode($long_url);
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [CURLOPT_URL => $api_url, CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 5]);
        $short_url = curl_exec($ch);
        curl_close($ch);
    } else {
        $short_url = @file_get_contents($api_url);
    }
    return ($short_url && filter_var(trim($short_url), FILTER_VALIDATE_URL)) ? trim($short_url) : $long_url;
}

function obter_url_load_balance_ou_padrao($conexao) {
    $portal_url_padrao = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
    try {
        $stmt_servers = $conexao->prepare("SELECT server_ip, server_port FROM servers WHERE status = 1");
        if (!$stmt_servers || !$stmt_servers->execute()) {
             error_log("Erro ao consultar a tabela 'servers' para Load Balance.");
             return $portal_url_padrao;
        }
        $servidores_ativos = $stmt_servers->fetchAll(PDO::FETCH_ASSOC);
        if (empty($servidores_ativos)) {
             error_log("Nenhum servidor de load balance ativo (status=1) encontrado. Usando URL padrao.");
             return $portal_url_padrao;
        }
        $servidor_selecionado = $servidores_ativos[array_rand($servidores_ativos)];
        $portal_url = rtrim($servidor_selecionado['server_ip'], '/');
        $port = $servidor_selecionado['server_port']; 
        if (strpos($portal_url, 'http://') !== 0 && strpos($portal_url, 'https://') !== 0) {
            $portal_url = ($port == 443) ? 'https://' . $portal_url : 'http://' . $portal_url;
        }
        if (!empty($port) && is_numeric($port) && $port != 80 && $port != 443) {
            $portal_url = rtrim($portal_url, '/') . ':' . $port;
        }
        return $portal_url; 
    } catch (Exception $e) {
         error_log("Erro Critico ao buscar DNS (obter_url_load_balance_ou_padrao): " . $e->getMessage());
         return $portal_url_padrao;
    }
}


function listar_clientes($dados_requisicao) {
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'];
        $colunas = [0 => 'id', 1 => 'name', 2 => 'usuario', 4 => 'Vencimento'];
        $query_base = " FROM clientes WHERE admin_id = :admin_id AND is_trial = 0 AND is_p2p = 0";
        $params = [':admin_id' => $admin_id];

        if (!empty($dados_requisicao['search']['value'])) {
            $search_value = "%" . $dados_requisicao['search']['value'] . "%";
            $query_base .= " AND (name LIKE :search_name OR usuario LIKE :search_usuario)";
            $params[':search_name'] = $search_value;
            $params[':search_usuario'] = $search_value;
        }

        $stmt_total = $conexao->prepare("SELECT COUNT(id) FROM clientes WHERE admin_id = :admin_id AND is_trial = 0 AND is_p2p = 0");
        $stmt_total->execute([':admin_id' => $admin_id]);
        $total_records = $stmt_total->fetchColumn();

        $stmt_filtrado = $conexao->prepare("SELECT COUNT(id) " . $query_base);
        $stmt_filtrado->execute($params);
        $total_filtered = $stmt_filtrado->fetchColumn();

        $coluna_ordenacao = isset($colunas[$dados_requisicao['order'][0]['column']]) ? $colunas[$dados_requisicao['order'][0]['column']] : 'id';
        $direcao_ordenacao = isset($dados_requisicao['order'][0]['dir']) ? $dados_requisicao['order'][0]['dir'] : 'desc';
        $inicio = isset($dados_requisicao['start']) ? (int)($dados_requisicao['start']) : 0;
        $quantidade = isset($dados_requisicao['length']) ? (int)($dados_requisicao['length']) : 10;
        
        $query_final = "SELECT * " . $query_base . " ORDER BY " . $coluna_ordenacao . " " . $direcao_ordenacao . " LIMIT " . $inicio . ", " . $quantidade;
        
        $stmt_principal = $conexao->prepare($query_final);
        $stmt_principal->execute($params);

        $dados = [];
        while ($row = $stmt_principal->fetch(PDO::FETCH_ASSOC)) {
            $is_banned = isset($row['is_banned']) ? $row['is_banned'] : 0;
            $id = $row['id'];
            
            if ($is_banned == 1) {
                $status = '<span class="badge bg-danger">Bloqueado</span>';
            } elseif (strtotime($row['Vencimento']) < time()) {
                $status = '<span class="badge bg-warning text-dark">Expirado</span>';
            } else {
                $status = '<span class="badge bg-success">Ativo</span>';
            }

            $acoes = "<div class='btn-group' role='group'>";
            $acoes .= "<button type='button' class='btn btn-sm btn-info' onclick='modal_master(\"api/clientes.php\", \"info_cliente\", \"{$id}\")' title='Info'><i class='fas fa-eye'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-primary' onclick='modal_master(\"api/clientes.php\", \"edite_cliente\", \"{$id}\")' title='Editar'><i class='fas fa-edit'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-success' onclick='modal_master(\"api/clientes.php\", \"renovar_cliente\", \"{$id}\")' title='Renovar'><i class='fas fa-retweet'></i></button>";

            if ($is_banned == 1) {
                $acoes .= "<button type='button' class='btn btn-sm btn-outline-success' onclick='modal_master(\"api/clientes.php\", \"toggle_bloqueio_cliente\", \"{$id}\")' title='Desbloquear'><i class='fas fa-unlock'></i></button>";
            } else {
                $acoes .= "<button type='button' class='btn btn-sm btn-outline-danger' onclick='modal_master(\"api/clientes.php\", \"toggle_bloqueio_cliente\", \"{$id}\")' title='Bloquear'><i class='fas fa-lock'></i></button>";
            }
            $acoes .= "<button type='button' class='btn btn-sm btn-danger' onclick='modal_master(\"api/clientes.php\", \"delete_cliente\", \"{$id}\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $acoes .= "</div>";
            
            $dados[] = [
                "id" => $id, 
                "name" => htmlspecialchars($row['name']), 
                "usuario" => htmlspecialchars($row['usuario']), 
                "status" => $status, 
                "vencimento" => date('d/m/Y H:i', strtotime($row['Vencimento'])), 
                "acao" => $acoes
            ];
        }
        return ["draw" => isset($dados_requisicao['draw']) ? intval($dados_requisicao['draw']) : 0, "recordsTotal" => intval($total_records), "recordsFiltered" => intval($total_filtered), "data" => $dados];
    } catch (PDOException $e) {
        error_log("Erro no DataTables (listar_clientes): " . $e->getMessage());
        return ["error" => "Erro de Banco de Dados: " . $e->getMessage(), "data" => [], "recordsTotal" => 0, "recordsFiltered" => 0, "draw" => isset($dados_requisicao['draw']) ? intval($dados_requisicao['draw']) : 0];
    }
}

function info_cliente($id) {
    try {
        $conexao = conectar_bd();
        $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : 0;
        $stmt = $conexao->prepare("SELECT * FROM clientes WHERE id = :id AND admin_id = :admin_id");
        $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            $template_file = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
            $template = file_exists($template_file) ? file_get_contents($template_file) : "ERRO: template nao encontrado!";
            
            $portal_url = obter_url_load_balance_ou_padrao($conexao);
            $exp_date_formatted = date('d/m/Y H:i:s', strtotime($Vencimento));

            $pretty_m3u_ts = $portal_url . '/m3u-ts/' . $usuario . '/' . $senha;
            $pretty_m3u_hls = $portal_url . '/m3u-m3u8/' . $usuario . '/' . $senha;
            $pretty_ssiptv = $portal_url . '/ss-ts/' . $usuario . '/' . $senha;

            $replacements = [
                '#username#' => $usuario, '#password#' => $senha, '#url#' => $portal_url,
                '#exp_date#' => $exp_date_formatted,
                '#m3u_link#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts', 
                '#m3u_link_hls#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=m3u8',
                '#ssiptv_link#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts',
                '#m3u_encurtado#' => $pretty_m3u_ts, '#m3u_hls_encurtado#' => $pretty_m3u_hls, '#ssiptv_encurtado#' => $pretty_ssiptv,
            ];
            $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);
            
            $modal_body = '<div id="infoClienteTexto-'.$id.'" '; 
            $modal_body .= ' data-copy-text="' . htmlspecialchars($mensagem_final, ENT_QUOTES, 'UTF-8') . '" '; 
            $modal_body .= ' class="form-control" readonly style="font-family: monospace; font-size: 0.9rem; resize: none; border: none; white-space: pre-wrap; min-height: 150px; max-height: 300px; overflow-y: auto;"';
            $modal_body .= '>' . htmlspecialchars($mensagem_final, ENT_QUOTES, 'UTF-8') . '</div>';
            
            $modal_footer = "<button type='button' class='btn btn-primary' onclick='copiarMensagem(\"infoClienteTexto-" . $id . "\")'><i class='fas fa-copy'></i> Copiar</button>";
            $modal_footer .= "<a href='https://wa.me/?text=" . urlencode($mensagem_final) . "' target='_blank' class='btn btn-success ms-2'><i class='fab fa-whatsapp'></i> Enviar</a>";
            
            return ['modal_titulo' => "Informacoes de " . htmlspecialchars($usuario), 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
        }
        return ['title' => 'Erro!', 'msg' => 'Cliente nao encontrado.', 'icon' => 'error'];
    } catch (PDOException $e) {
        return ['modal_titulo' => 'Erro', 'modal_body' => 'Nao foi possivel buscar as informacoes: ' . $e->getMessage()];
    }
}

function adicionar_clientes() {
    $conexao = conectar_bd();
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : 0;
    $stmt_planos = $conexao->prepare("SELECT id, nome FROM planos WHERE admin_id = ? ORDER BY nome ASC");
    $stmt_planos->execute([$admin_id]);
    $planoOptions = "<option value='' selected disabled>Selecione um plano</option>";
    while ($lista_plano = $stmt_planos->fetch()) {
        $planoOptions .= '<option value="' . $lista_plano['id'] . '">' . htmlspecialchars($lista_plano['nome']) . '</option>';
    }
    $stmt_bouquets = $conexao->prepare("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC");
    $stmt_bouquets->execute();
    $bouquetOptions = "<option value='' selected disabled>Selecione um pacote</option>";
    while ($lista_bouquet = $stmt_bouquets->fetch()) {
        $bouquetOptions .= '<option value="' . $lista_bouquet['id'] . '">' . htmlspecialchars($lista_bouquet['bouquet_name']) . '</option>';
    }
    $modal_body = '<form id="formAdicionarCliente"><input type="hidden" name="confirme_adicionar_clientes" value="1">';
    $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Nome:</label><input type="text" class="form-control" name="name" required></div><div class="form-group col-md-6"><label>WhatsApp:</label><input type="tel" class="form-control" name="WhatsApp" placeholder="55119..."></div></div>';
    $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Usuario:</label><input type="text" class="form-control" name="usuario" required></div><div class="form-group col-md-6"><label>Senha:</label><input type="text" class="form-control" name="senha" required></div></div>';
    $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Plano (Tempo):</label><select class="form-select" name="plano" required>' . $planoOptions . '</select></div><div class="form-group col-md-6"><label>Pacote (Conteudo):</label><select class="form-select" name="bouquet_id" required>' . $bouquetOptions . '</select></div></div>';
    $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Validade (Meses):</label><input type="number" class="form-control" name="meses" value="1" min="1" required></div><div class="form-group col-md-6"><label>Conexoes:</label><input type="number" class="form-control" name="conexoes" value="1" min="1"></div></div>';
    $modal_body .= '</form>';
    $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' onclick='enviarFormulario(\"formAdicionarCliente\", \"api/clientes.php\")' class='btn btn-info'>Salvar</button>";
    return ['modal_header_class' => "modal-header bg-primary text-white", 'modal_titulo' => "Adicionar Novo Cliente", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
}

function confirme_adicionar_clientes($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    $name = isset($post_data["name"]) ? trim($post_data["name"]) : ''; 
    $usuario = isset($post_data["usuario"]) ? trim($post_data["usuario"]) : ''; 
    $senha = isset($post_data["senha"]) ? trim($post_data["senha"]) : '';
    $whatsapp = isset($post_data["WhatsApp"]) ? trim($post_data["WhatsApp"]) : ''; 
    $plano_id = isset($post_data["plano"]) ? (int)($post_data["plano"]) : 0; 
    $meses = isset($post_data["meses"]) ? (int)($post_data["meses"]) : 1; 
    $conexoes = isset($post_data["conexoes"]) ? (int)($post_data["conexoes"]) : 1;
    $bouquet_id = isset($post_data["bouquet_id"]) ? (int)($post_data["bouquet_id"]) : 0;

    if (empty($name) || empty($usuario) || empty($senha) || empty($plano_id) || empty($bouquet_id)) {
        return ['title' => 'Erro!', 'msg' => 'Todos os campos sao obrigatorios (incluindo Plano e Pacote).', 'icon' => 'error'];
    }
    try {
        $custo = $meses;
        $stmt_admin = $conexao->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt_admin->execute([$admin_id]);
        $admin_info = $stmt_admin->fetch(PDO::FETCH_ASSOC);
        
        if ($admin_info['admin'] != 1 && $admin_info['creditos'] < $custo) {
            return ['title' => 'Creditos Insuficientes!', 'msg' => "Precisa de {$custo} creditos, mas so tem {$admin_info['creditos']}.", 'icon' => 'warning'];
        }
        $data_vencimento = date("Y-m-d 23:59:59", strtotime("+$meses month"));
        
        $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, plano, bouquet_id, Vencimento, is_trial, Criado_em, conexoes, is_p2p) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 0, NOW(), ?, 0)";
        $conexao->prepare($sql)->execute([$admin_id, $name, $usuario, $senha, $whatsapp, $plano_id, $bouquet_id, $data_vencimento, $conexoes]);
        
        if ($admin_info['admin'] != 1) {
            $conexao->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$custo, $admin_id]);
            $reason = "Criacao Cliente: " . $usuario;
            $stmt_log = $conexao->prepare("INSERT INTO credits_log (admin_id, target_id, amount, reason, date) VALUES (:admin_id, :target_id, :amount, :reason, :date)");
            $stmt_log->execute([':admin_id' => $admin_id, ':target_id' => $admin_id, ':amount' => -$custo, ':reason' => $reason, ':date' => time()]);
        }
        
        $template = file_exists($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') ? file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt') : "ERRO";
        $portal_url = obter_url_load_balance_ou_padrao($conexao);
        $exp_date_formatted = date('d/m/Y H:i', strtotime($data_vencimento));
        $pretty_m3u_ts = $portal_url . '/m3u-ts/' . $usuario . '/' . $senha;
        $pretty_m3u_hls = $portal_url . '/m3u-m3u8/' . $usuario . '/' . $senha;
        $pretty_ssiptv = $portal_url . '/ss-ts/' . $usuario . '/' . $senha;
        $replacements = [
            '#username#' => $usuario, '#password#' => $senha, '#url#' => $portal_url, '#exp_date#' => $exp_date_formatted,
            '#m3u_link#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts', 
            '#m3u_link_hls#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=m3u8',
            '#ssiptv_link#' => $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts',
            '#m3u_encurtado#' => $pretty_m3u_ts, '#m3u_hls_encurtado#' => $pretty_m3u_hls, '#ssiptv_encurtado#' => $pretty_ssiptv,
        ];
        $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);
        
        return ['title' => 'Sucesso!', 'msg' => 'Cliente adicionado!', 'icon' => 'success', 'data_table' => 'atualizar', 'dados_cliente_msg' => $mensagem_final];
    } catch (Exception $e) {
        return ['title' => 'Erro!', 'msg' => 'Falha ao adicionar cliente: ' . $e->getMessage(), 'icon' => 'error'];
    }
}

function edite_cliente($id) {
    try {
        $conexao = conectar_bd();
        $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : 0;
        $stmt = $conexao->prepare("SELECT * FROM clientes WHERE id = :id AND admin_id = :admin_id");
        $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$cliente) return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente nao encontrado.'];
        
        $stmt_planos = $conexao->prepare("SELECT * FROM planos WHERE admin_id = ? ORDER BY nome ASC");
        $stmt_planos->execute([$admin_id]);
        $planoOptions = "";
        while ($plano = $stmt_planos->fetch(PDO::FETCH_ASSOC)) {
            $selected = ($cliente['plano'] == $plano['id']) ? "selected" : "";
            $planoOptions .= '<option value="' . $plano['id'] . '" ' . $selected . '>' . htmlspecialchars($plano['nome']) . '</option>';
        }
        $stmt_bouquets = $conexao->prepare("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC");
        $stmt_bouquets->execute();
        $bouquetOptions = "<option value=''>Nenhum Pacote</option>";
        while ($lista_bouquet = $stmt_bouquets->fetch(PDO::FETCH_ASSOC)) {
            $selected = ($cliente['bouquet_id'] == $lista_bouquet['id']) ? "selected" : "";
            $bouquetOptions .= '<option value="' . $lista_bouquet['id'] . '" ' . $selected . '>' . htmlspecialchars($lista_bouquet['bouquet_name']) . '</option>';
        }
        $whatsapp_val = isset($cliente['WhatsApp']) ? htmlspecialchars($cliente['WhatsApp']) : '';
        $conexoes_val = isset($cliente['conexoes']) ? $cliente['conexoes'] : 1;

        $modal_body = '<form id="formEditaCliente-' . $id . '"><input type="hidden" name="confirme_edite_cliente" value="1"><input type="hidden" name="id" value="' . $id . '">';
        $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Nome:</label><input type="text" class="form-control" name="name" value="' . htmlspecialchars($cliente['name']) . '"></div><div class="form-group col-md-6"><label>WhatsApp:</label><input type="tel" class="form-control" name="WhatsApp" value="' . $whatsapp_val . '"></div></div>';
        $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Usuario:</label><input type="text" class="form-control" name="usuario" value="' . htmlspecialchars($cliente['usuario']) . '"></div><div class="form-group col-md-6"><label>Senha:</label><input type="text" class="form-control" name="senha" value="' . htmlspecialchars($cliente['senha']) . '"></div></div>';
        $modal_body .= '<div class="form-group mb-2"><label>Vencimento:</label><input type="date" class="form-control" name="data_de_vencimento" value="' . date("Y-m-d", strtotime($cliente['Vencimento'])) . '"></div>';
        $modal_body .= '<div class="form-group mb-2"><label>Conexoes:</label><input type="number" class="form-control" name="conexoes" value="' . $conexoes_val . '" min="1"></div>';
        $modal_body .= '<div class="row mb-2"><div class="form-group col-md-6"><label>Plano (Tempo):</label><select class="form-select" name="plano">' . $planoOptions . '</select></div><div class="form-group col-md-6"><label>Pacote (Conteudo):</label><select class="form-select" name="bouquet_id">' . $bouquetOptions . '</select></div></div>';
        $modal_body .= '</form>';
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' onclick='enviarFormulario(\"formEditaCliente-" . $id . '", "api/clientes.php")' . "' class='btn btn-info'>Salvar</button>";
        
        return ['modal_titulo' => "Editar Cliente (" . htmlspecialchars($cliente['usuario']) . ")", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    } catch (PDOException $e) {
        return ['modal_titulo' => 'Erro', 'modal_body' => 'Erro ao carregar dados: ' . $e->getMessage()];
    }
}

function confirme_edite_cliente($post_data) {
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'];
        $id = isset($post_data['id']) ? $post_data['id'] : 0;
        $updates = []; $params = [];
        $campos_permitidos = ['name', 'usuario', 'senha', 'WhatsApp', 'conexoes', 'plano', 'bouquet_id'];
        
        foreach ($campos_permitidos as $campo) {
            if (isset($post_data[$campo])) {
                $updates[] = "$campo = :$campo";
                if ($campo == 'bouquet_id' && empty($post_data[$campo])) {
                    $params[":$campo"] = NULL;
                } else {
                    $params[":$campo"] = trim($post_data[$campo]);
                }
            }
        }
        if (!empty($post_data['data_de_vencimento'])) {
            $updates[] = "Vencimento = :Vencimento";
            $params[':Vencimento'] = date("Y-m-d 23:59:59", strtotime($post_data['data_de_vencimento']));
        }
        
        if (empty($updates)) return ['title' => "Atencao!", 'msg' => "Nenhum dado para alterar.", 'icon' => "warning"];
        
        $sql_update = "UPDATE clientes SET " . implode(', ', $updates) . " WHERE id = :id AND admin_id = :admin_id";
        $params[':id'] = $id; $params[':admin_id'] = $admin_id;
        $conexao->prepare($sql_update)->execute($params);
        
        return ['title' => "Sucesso!", 'msg' => "Cliente editado.", 'icon' => "success", 'data_table' => 'atualizar'];
    } catch (PDOException $e) {
        return ['title' => "Erro!", 'msg' => "Nao foi possivel atualizar: ".$e->getMessage(), 'icon' => "error"];
    }
}

function renovar_cliente($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $_SESSION['admin_id']]);
    if ($cliente = $stmt->fetch()) {
        $stmt_admin = $conexao->prepare("SELECT confianca_ativo FROM admin WHERE admin = 1 LIMIT 1");
        $stmt_admin->execute();
        $config_admin = $stmt_admin->fetch(PDO::FETCH_ASSOC);
        $confianca_ativa = $config_admin ? $config_admin['confianca_ativo'] : 0; 
        
        $modal_body = "<form id='formRenovar-{$id}'><input type='hidden' name='confirme_renovar_cliente' value='{$id}'>";
        $modal_body .= "<p>Usuario: <strong>" . htmlspecialchars($cliente['usuario']) . "</strong></p>"; 
        $modal_body .= "<label>Quantidade de meses:</label>";
        $modal_body .= "<input type='number' name='meses' class='form-control' value='1' min='1' max='12'>";
        $modal_body .= "<small class='form-text text-muted'>Escolha a quantidade de meses.</small><br>";
        $modal_body .= "<small class='form-text text-danger'>Fique atento, caso seja um usuario de 2 telas ir cobrar o dobro de creditos equivalente a quantidade de meses.</small>";
        $modal_body .= "</form>";
        $modal_body .= "<form id='formConfianca-{$id}' style='display:none;'><input type='hidden' name='confirme_renovar_confianca' value='{$id}'></form>";
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button>";
        $modal_footer .= "<button type='button' class='btn btn-primary' onclick='enviarFormulario(\"formRenovar-{$id}\", \"api/clientes.php\")'>Confirmar</button>";
        
        if ($confianca_ativa == 1) {
            $modal_footer .= "<button type='button' class='btn btn-outline-info ms-2' onclick='enviarFormulario(\"formConfianca-{$id}\", \"api/clientes.php\")'><i class='fas fa-handshake'></i> Renovacao de Confianca</button>";
        }
        
        return ['modal_titulo' => "Tem certeza que deseja renovar este cliente?", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    }
    return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente nao encontrado.'];
}

function confirme_renovar_confianca($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id']; 
    $id = isset($post_data['confirme_renovar_confianca']) ? (int)($post_data['confirme_renovar_confianca']) : 0; 
    try {
        $stmt_admin = $conexao->prepare("SELECT confianca_dias, confianca_ativo FROM admin WHERE admin = 1 LIMIT 1");
        $stmt_admin->execute();
        $config_admin = $stmt_admin->fetch(PDO::FETCH_ASSOC);
        $dias_confianca = $config_admin ? (int)$config_admin['confianca_dias'] : 0;
        $confianca_ativa = $config_admin ? (int)$config_admin['confianca_ativo'] : 0;

        if ($confianca_ativa == 0 || $dias_confianca <= 0) {
            return ['title' => "Atencao!", 'msg' => "A funcao de Renovacao de Confianca esta desativada ou nao configurada pelo Admin.", 'icon' => "warning"];
        }
        $stmt_cliente = $conexao->prepare("SELECT Vencimento, data_renovacao_confianca FROM clientes WHERE id = ? AND admin_id = ?");
        $stmt_cliente->execute([$id, $admin_id]);
        
        if (!($cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC))) {
             return ['title' => "Erro!", 'msg' => "Cliente nao encontrado ou nao pertence a voce.", 'icon' => "error"];
        }
        if ($cliente['data_renovacao_confianca'] !== null) {
             return ['title' => "Atencao!", 'msg' => "A Renovacao de Confianca ja foi utilizada para este ciclo. Ela sera reativada no proximo pagamento.", 'icon' => "warning"];
        }
        $base_data = (strtotime($cliente['Vencimento']) > time()) ? $cliente['Vencimento'] : date("Y-m-d H:i:s");
        $nova_data = date("Y-m-d 23:59:59", strtotime("+{$dias_confianca} days", strtotime($base_data)));

        $conexao->prepare("UPDATE clientes SET Vencimento = ?, data_renovacao_confianca = NOW() WHERE id = ? AND admin_id = ?")
                           ->execute([$nova_data, $id, $admin_id]);

        $msg_sucesso = "Cliente renovado por {$dias_confianca} dias (Confianca). Sem custo de credito.";
        return ['title' => "Sucesso!", 'msg' => $msg_sucesso, 'icon' => "success", 'data_table' => 'atualizar'];
    } catch (PDOException $e) {
        return ['title' => "Erro!", 'msg' => "Nao foi possivel renovar: " . $e->getMessage(), 'icon' => "error"];
    }
}

function confirme_renovar_cliente($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    $id = isset($post_data['confirme_renovar_cliente']) ? (int)($post_data['confirme_renovar_cliente']) : 0;
    $meses = isset($post_data['meses']) ? (int)($post_data['meses']) : 1;
    $custo = $meses;
    try {
        $stmt_admin = $conexao->prepare("SELECT admin, creditos FROM admin WHERE id = ?");
        $stmt_admin->execute([$admin_id]);
        $admin_info = $stmt_admin->fetch(PDO::FETCH_ASSOC);
        if ($admin_info['admin'] != 1 && $admin_info['creditos'] < $custo) {
            return ['title' => "Erro!", 'msg' => "Creditos insuficientes.", 'icon' => "error"];
        }
        $stmt_cliente = $conexao->prepare("SELECT * FROM clientes WHERE id = ? AND admin_id = ?");
        $stmt_cliente->execute([$id, $admin_id]);
        if ($cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC)) {
            $base_data = (strtotime($cliente['Vencimento']) > time()) ? $cliente['Vencimento'] : date("Y-m-d H:i:s");
            $nova_data = date("Y-m-d 23:59:59", strtotime("+$meses month", strtotime($base_data)));
            $conexao->prepare("UPDATE clientes SET Vencimento = ?, data_renovacao_confianca = NULL, Ultimo_pagamento = NOW() WHERE id = ?")
                             ->execute([$nova_data, $id]);
            if ($admin_info['admin'] != 1) {
                $conexao->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$custo, $admin_id]);
                $reason = "Renovacao Cliente: " . $cliente['usuario'] . " (+" . $meses . " mes)";
                $stmt_log = $conexao->prepare("INSERT INTO credits_log (admin_id, target_id, amount, reason, date) VALUES (:admin_id, :target_id, :amount, :reason, :date)");
                $stmt_log->execute([':admin_id' => $admin_id, ':target_id' => $admin_id, ':amount' => -$custo, ':reason' => $reason, ':date' => time()]);
            }
            $vencimento_formatado = date('d/m/Y', strtotime($nova_data)); 
            $mensagem_final = "*Plano IPTV renovado com sucesso!*\n\n" . "👤 Usuario: " . $cliente['usuario'] . "\n" . "🔑 Senha: " . $cliente['senha'] . "\n" . "📆 Vencimento: " . $vencimento_formatado;
            return ['title' => "Sucesso!", 'msg' => 'Cliente renovado com sucesso!', 'icon' => "success", 'data_table' => 'atualizar', 'dados_cliente_msg' => $mensagem_final];
        }
        return ['title' => "Erro!", 'msg' => "Cliente nao encontrado.", 'icon' => "error"];
    } catch (Exception $e) {
        return ['title' => "Erro!", 'msg' => "Nao foi possivel renovar: " . $e->getMessage(), 'icon' => "error"];
    }
}

function delete_cliente($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $_SESSION['admin_id']]);
    if ($cliente = $stmt->fetch()) {
        $modal_body = "<form id='formDelete-{$id}'><input type='hidden' name='confirme_delete_cliente' value='{$id}'></form>";
        $modal_body .= "Tem certeza que deseja excluir o cliente (" . htmlspecialchars($cliente['usuario']) . ")?";
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' class='btn btn-danger' onclick='enviarFormulario(\"formDelete-{$id}\", \"api/clientes.php\")'>EXCLUIR</button>";
        return ['modal_titulo' => "EXCLUIR CLIENTE", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    }
    return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente nao encontrado.'];
}

function confirme_delete_cliente($post_data) {
    $conexao = conectar_bd();
    $id = isset($post_data['confirme_delete_cliente']) ? (int)($post_data['confirme_delete_cliente']) : 0;
    $admin_id = $_SESSION['admin_id'];
    $stmt = $conexao->prepare("DELETE FROM clientes WHERE id = :id AND admin_id = :admin_id");
    if ($stmt->execute([':id' => $id, ':admin_id' => $admin_id]) && $stmt->rowCount() > 0) {
        return ['title' => "Sucesso!", 'msg' => "Cliente deletado!", 'icon' => "success", 'data_table' => 'atualizar'];
    }
    return ['title' => "Erro!", 'msg' => "Erro ao deletar ou permissao negada.", 'icon' => "error"];
}

function toggle_bloqueio_cliente($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT usuario, is_banned FROM clientes WHERE id = ? AND admin_id = ?");
    $stmt->execute([$id, $_SESSION['admin_id']]);
    if ($cliente = $stmt->fetch()) {
        $acao_texto = $cliente['is_banned'] ? "DESBLOQUEAR" : "BLOQUEAR";
        $btn_classe = $cliente['is_banned'] ? "btn-success" : "btn-danger";
        $modal_body = "<form id='formToggleBloqueio-{$id}'><input type='hidden' name='confirme_toggle_bloqueio_cliente' value='{$id}'></form>";
        $modal_body .= "<p>Tem certeza que deseja <strong>{$acao_texto}</strong> o cliente (" . htmlspecialchars($cliente['usuario']) . ")?</p>";
        if($cliente['is_banned']) {
             $modal_body .= "<p class='text-muted small'>Isso permitirÃ¡ o acesso do cliente imediatamente.</p>";
        } else {
             $modal_body .= "<p class='text-muted small'>Isso impedirÃ¡ o acesso do cliente imediatamente.</p>";
        }
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button>";
        $modal_footer .= "<button type='button' class='btn {$btn_classe}' onclick='enviarFormulario(\"formToggleBloqueio-{$id}\", \"api/clientes.php\")'>{$acao_texto}</button>";
        return ['modal_titulo' => "{$acao_texto} CLIENTE", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    }
    return ['modal_titulo' => 'Erro', 'modal_body' => 'Cliente nÃ£o encontrado.'];
}

function confirme_toggle_bloqueio_cliente($post_data) {
    $conexao = conectar_bd();
    $id = isset($post_data['confirme_toggle_bloqueio_cliente']) ? (int)($post_data['confirme_toggle_bloqueio_cliente']) : 0;
    $admin_id = $_SESSION['admin_id'];
    try {
        $stmt_cliente = $conexao->prepare("SELECT is_banned, usuario FROM clientes WHERE id = ? AND admin_id = ?");
        $stmt_cliente->execute([$id, $admin_id]);
        if ($cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC)) {
            $novo_status = $cliente['is_banned'] ? 0 : 1;
            $acao_texto = $novo_status ? "bloqueado" : "desbloqueado";
            $stmt_update = $conexao->prepare("UPDATE clientes SET is_banned = ? WHERE id = ? AND admin_id = ?");
            $stmt_update->execute([$novo_status, $id, $admin_id]);
            return ['title' => "Sucesso!", 'msg' => "Cliente " . htmlspecialchars($cliente['usuario']) . " foi {$acao_texto}!", 'icon' => "success", 'data_table' => 'atualizar'];
        }
        return ['title' => "Erro!", 'msg' => "Cliente nÃ£o encontrado ou permissÃ£o negada.", 'icon' => "error"];
    } catch (PDOException $e) {
        return ['title' => "Erro!", 'msg' => "NÃ£o foi possÃ­vel atualizar: " . $e->getMessage(), 'icon' => "error"];
    }
}
?>
