<?php
session_start();

// Supondo que você tenha um arquivo de conexão com o banco de dados
// Se o caminho for diferente, ajuste-o aqui.
require_once('../../../conexao.php'); 

header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Usuário não autenticado.'];

// Verifica se o usuário está logado pela sessão
if (isset($_SESSION['id_admin'])) {
    $id_admin = $_SESSION['id_admin'];

    // Prepara a consulta para buscar os créditos e o nível do admin
    // IMPORTANTE: Altere 'admin' para o nome da sua tabela de administradores/revendedores
    // e 'creditos' para o nome da sua coluna de créditos, se forem diferentes.
    $query = $conexao->prepare("SELECT creditos, nivel_admin FROM admin WHERE id = :id");
    $query->bindValue(':id', $id_admin, PDO::PARAM_INT);
    $query->execute();

    $usuario = $query->fetch(PDO::FETCH_ASSOC);

    if ($usuario) {
        // Define o tipo de usuário com base no nível
        $tipo_usuario = ($usuario['nivel_admin'] == 1) ? 'Admin' : 'Revendedor';

        $response = [
            'success' => true,
            'creditos' => $usuario['creditos'],
            'tipo' => $tipo_usuario
        ];
    } else {
        $response['message'] = 'Usuário não encontrado no banco de dados.';
    }
}

// Retorna os dados em formato JSON
echo json_encode($response);
exit();
?>