<?php
set_time_limit(0);
ini_set('memory_limit', '512M');
require_once('db.php');
session_start();

// =======================================================================
// MUDANÇA CRÍTICA AQUI: A função agora vai reportar o erro em vez de escondê-lo.
// =======================================================================
function executarConsulta($conexao, $query, $parametros) {
    // A cláusula try...catch foi removida daqui para permitir que a exceção
    // seja capturada pelo bloco principal, revelando o erro real.
    $stmt = $conexao->prepare($query);
    $stmt->execute($parametros);
    return $stmt;
}

function processarUrl($url) { /* ... mantido ... */ }

function adicionarLinks_Otimizado($links, $conexao) {
    $results = [
        'urls' => 0, 'movie' => 0, 'live' => 0, 'series' => 0, 'episodios' => 0,
        'temporadas' => 0, 'exists' => 0, 'error' => []
    ];

    $urlsParaVerificar = array_column($links, 'url');
    if (empty($urlsParaVerificar)) return $results;

    $placeholders = implode(',', array_fill(0, count($urlsParaVerificar), '?'));
    $queryLinks = "(SELECT link FROM streams WHERE link IN ($placeholders)) UNION (SELECT link FROM series_episodes WHERE link IN ($placeholders))";
    $stmtLinks = executarConsulta($conexao, $queryLinks, array_merge($urlsParaVerificar, $urlsParaVerificar));
    $linksExistentes = array_flip($stmtLinks->fetchAll(PDO::FETCH_COLUMN));

    $streamsParaInserir = [];
    $episodiosParaInserir = [];
    $temporadasParaInserir = [];

    foreach ($links as $link) {
        $url = trim($link['url'] ?? '');
        if (isset($linksExistentes[$url]) || empty($url)) {
            $results['exists']++;
            continue;
        }

        $groupTitle = trim($link['groupTitle'] ?? 'Sem Categoria');
        $channelName = trim($link['channelName'] ?? 'Sem Nome');
        $tvgLogo = trim($link['tvgLogo'] ?? '');
        $container = preg_match('/\.(mp4|mkv|ts|m3u8)$/i', $url, $ext) ? strtolower($ext[1]) : 'ts';

        $type = 'movie';
        if (preg_match('/\/live\b/i', $url) || preg_match('/\b(canais|live|tv)\b/i', $groupTitle)) $type = 'live';
        if (preg_match('/\/series\b/i', $url) || preg_match('/\b(series|série)\b/i', $groupTitle) || preg_match('/[Ss]\d{1,2}[EeXx]\d{1,3}/', $channelName)) $type = 'series';

        static $categoriasCache = [];
        $cacheKeyCat = $groupTitle . '_' . $type;
        if (!isset($categoriasCache[$cacheKeyCat])) {
            $stmtCat = executarConsulta($conexao, "SELECT id FROM categoria WHERE nome = ? AND type = ?", [$groupTitle, $type]);
            $categoria = $stmtCat->fetch(PDO::FETCH_ASSOC);
            if ($categoria) {
                $categoriasCache[$cacheKeyCat] = $categoria['id'];
            } else {
                executarConsulta($conexao, "INSERT INTO categoria (nome, type, admin_id) VALUES (?, ?, ?)", [$groupTitle, $type, $_SESSION['admin_id'] ?? 1]);
                $categoriasCache[$cacheKeyCat] = $conexao->lastInsertId();
            }
        }
        $category_id = $categoriasCache[$cacheKeyCat];

        if ($type === 'series' && preg_match('/^(.*?)(?:[\s._-]+)?(?:[Ss]|Temporada)?[\s._-]?(\d{1,2})[\s._-]?(?:[EeXx]|Episodio)[\s._-]?(\d{1,3})/i', $channelName, $matches)) {
            $nomeSerie = trim($matches[1]);
            $temporada = (int)$matches[2];
            $episodioNum = (int)$matches[3];

            static $seriesCache = [];
            $cacheKeySerie = $nomeSerie . '_' . $category_id;
            if (!isset($seriesCache[$cacheKeySerie])) {
                $stmtSerie = executarConsulta($conexao, "SELECT id FROM series WHERE name = ? AND category_id = ?", [$nomeSerie, $category_id]);
                $serie = $stmtSerie->fetch(PDO::FETCH_ASSOC);
                if ($serie) {
                    $seriesCache[$cacheKeySerie] = $serie['id'];
                } else {
                    executarConsulta($conexao, "INSERT INTO series (name, category_id, cover) VALUES (?, ?, ?)", [$nomeSerie, $category_id, $tvgLogo]);
                    $seriesCache[$cacheKeySerie] = $conexao->lastInsertId();
                    $results['series']++;
                }
            }
            $series_id = $seriesCache[$cacheKeySerie];

            static $seasonsCache = [];
            $cacheKeySeason = $series_id . '_' . $temporada;
            if (!isset($seasonsCache[$cacheKeySeason])) {
                $temporadasParaInserir[] = [$series_id, $temporada, 'Temporada ' . $temporada];
                $seasonsCache[$cacheKeySeason] = true;
                $results['temporadas']++;
            }
            
            $episodiosParaInserir[] = [$url, $series_id, $temporada, $episodioNum, $channelName, $container, $tvgLogo, $category_id];
            $results['episodios']++;
        }
        elseif ($type === 'live' || $type === 'movie') {
            $streamsParaInserir[] = [$url, $category_id, $channelName, $type, $container, $tvgLogo];
            $results[$type]++;
        }
        $results['urls']++;
    }

    if (!empty($streamsParaInserir)) {
        $chunkSize = 200;
        foreach (array_chunk($streamsParaInserir, $chunkSize) as $chunk) {
            $placeholders = implode(',', array_fill(0, count($chunk), '(?, ?, ?, ?, ?, ?)'));
            $params = array_merge(...$chunk);
            executarConsulta($conexao, "INSERT INTO streams (link, category_id, name, stream_type, container_extension, stream_icon) VALUES $placeholders", $params);
        }
    }

    if (!empty($temporadasParaInserir)) {
        $chunkSize = 200;
        foreach (array_chunk($temporadasParaInserir, $chunkSize) as $chunk) {
            $placeholders = implode(',', array_fill(0, count($chunk), '(?, ?, ?)'));
            $params = array_merge(...$chunk);
            executarConsulta($conexao, "INSERT IGNORE INTO series_seasons (series_id, season_number, name) VALUES $placeholders", $params);
        }
    }
    
    if (!empty($episodiosParaInserir)) {
        $chunkSize = 200;
        foreach (array_chunk($episodiosParaInserir, $chunkSize) as $chunk) {
            $placeholders = implode(',', array_fill(0, count($chunk), '(?, ?, ?, ?, ?, ?, ?, ?)'));
            $params = array_merge(...$chunk);
            executarConsulta($conexao, "INSERT IGNORE INTO series_episodes (link, series_id, season, episode_num, title, container_extension, movie_image, category_id) VALUES $placeholders", $params);
        }
    }
    
    return $results;
}

// Lógica de Roteamento Principal
header('Content-Type: application/json');
$conexao = conectar_bd();
$json_payload = file_get_contents('php://input');
$data = json_decode($json_payload, true);

if (isset($data['block'])) {
    try {
        $links = $data['block'] ?? [];
        if (empty($links)) {
            echo json_encode(['results' => ['error' => ['Bloco de links vazio.']]]);
            exit;
        }
        $conexao->beginTransaction();
        $final_results = adicionarLinks_Otimizado($links, $conexao);
        $conexao->commit();
        echo json_encode(['results' => $final_results]);
    } catch (Exception $e) {
        if ($conexao->inTransaction()) $conexao->rollBack();
        http_response_code(500);
        // Agora, se houver um erro, ele será capturado aqui e enviado para o navegador.
        echo json_encode(['results' => ['error' => ['Erro no Banco de Dados: ' . $e->getMessage()]]]);
    }
} else {
    http_response_code(400);
    echo json_encode(['results' => ['error' => ['Nenhum dado válido recebido.']]]);
}
?>