<?php
// Arquivo: /api/controles/funcoes_testes.php - VERSÃO FINAL COMPLETA E CORRIGIDA

/**
 * Encurta uma URL longa usando a API is.gd via cURL (mais robusto).
 */
function encurtar_url($long_url)
{
    if (empty($long_url) || !filter_var($long_url, FILTER_VALIDATE_URL)) {
        return $long_url;
    }
    $api_url = 'https://is.gd/api.php?longurl=' . urlencode($long_url);
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        $short_url = curl_exec($ch);
        curl_close($ch);
    } else {
        $short_url = @file_get_contents($api_url);
    }
    if ($short_url && filter_var(trim($short_url), FILTER_VALIDATE_URL)) {
        return trim($short_url);
    }
    return $long_url;
}

/**
 * Gera o modal de informações do cliente/teste, usando o template.
 */
function info_cliente($id)
{
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'] ?? 0;
        $stmt = $conexao->prepare("SELECT * FROM clientes WHERE id = :id AND admin_id = :admin_id");
        $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);

        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            
            $template_file = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
            $template = file_exists($template_file) ? file_get_contents($template_file) : "ERRO: template_mensagem.txt não encontrado!";
            
            $portal_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
            $exp_date_formatted = date('d/m/Y H:i:s', strtotime($Vencimento));

            $m3u_ts_long = $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts';
            $m3u_hls_long = $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=m3u8';
            
            $replacements = [
                '#username#'        => $usuario,
                '#password#'        => $senha,
                '#url#'             => $portal_url,
                '#exp_date#'        => $exp_date_formatted,
                '#m3u_link#'        => $m3u_ts_long,
                '#m3u_link_hls#'    => $m3u_hls_long,
                '#ssiptv_link#'     => $m3u_ts_long,
                '#m3u_encurtado#'   => encurtar_url($m3u_ts_long),
                '#m3u_hls_encurtado#' => encurtar_url($m3u_hls_long),
                '#ssiptv_encurtado#' => encurtar_url($m3u_ts_long),
            ];
            $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);

            $modal_body = '<div id="infoClienteTexto-' . $id . '" data-copy-text="' . htmlspecialchars($mensagem_final) . '" style="white-space: pre-wrap; font-family: monospace; font-size: 14px;">' . htmlspecialchars($mensagem_final) . '</div>';
            $modal_footer = "<button type='button' class='btn btn-primary' onclick='copiarMensagem(\"infoClienteTexto-" . $id . "\")'><i class='fas fa-copy'></i> Copiar</button>";
            $modal_footer .= "<a href='https://wa.me/?text=" . urlencode($mensagem_final) . "' target='_blank' class='btn btn-success ms-2'><i class='fab fa-whatsapp'></i> Enviar</a>";
            
            return ['modal_header_class' => "modal-header bg-info text-white", 'modal_titulo' => "Informações de " . htmlspecialchars($usuario), 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
        }
        return ['title' => 'Erro!', 'msg' => 'Cliente não encontrado.', 'icon' => 'error'];
    } catch (PDOException $e) {
        return ['modal_titulo' => 'Erro de BD', 'modal_body' => 'Não foi possível buscar as informações: ' . $e->getMessage()];
    }
}

/**
 * Gera o modal para adicionar tempo a um teste.
 */
function add_tempo($id)
{
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'] ?? 0;
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = :id AND admin_id = :admin_id");
    $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if(!$cliente) {
        return ['modal_titulo' => 'Erro', 'modal_body' => 'Teste não encontrado.'];
    }
    $usuario = $cliente['usuario'];

    $modal_body = "<form id='formAddTempo-{$id}' method='POST'>";
    $modal_body .= "<input type='hidden' name='confirme_add_tempo_testes' value='{$id}'>";
    $modal_body .= "<label>Adicionar Horas:</label>";
    $modal_body .= "<input type='number' name='tempo' class='form-control' value='1' min='-72' max='72'>";
    $modal_body .= "<small class='form-text text-muted'>Use valores negativos para remover horas.</small>";
    $modal_body .= "</form>";
    $modal_footer = "<button type='button' class='btn btn-success' onclick='enviarFormulario(\"formAddTempo-{$id}\", \"testes.php\")'>Confirmar</button>";
    return ['modal_header_class' => "modal-header bg-success text-white", 'modal_titulo' => "Adicionar Tempo para (".htmlspecialchars($usuario).")", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
}

/**
 * Processa a adição de tempo a um teste.
 */
function confirme_add_tempo_testes($post_data)
{
    $conexao = conectar_bd();
    $id = (int)($post_data['confirme_add_tempo_testes'] ?? 0);
    $tempo = (int)($post_data['tempo'] ?? 0);
    $admin_id = $_SESSION['admin_id'] ?? 0;
    $tempo = min(max($tempo, -72), 72);

    $stmt = $conexao->prepare("SELECT Vencimento FROM clientes WHERE id = :id AND admin_id = :admin_id");
    $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
    
    if ($cliente = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $vencimento_atual = $cliente['Vencimento'];
        $nova_data = date("Y-m-d H:i:s", strtotime("{$vencimento_atual} {$tempo} hours"));
        
        $stmt_update = $conexao->prepare("UPDATE clientes SET Vencimento = :nova_data WHERE id = :id");
        if ($stmt_update->execute([':nova_data' => $nova_data, ':id' => $id])) {
            return ['title' => 'Concluído!', 'msg' => 'Tempo alterado com sucesso.', 'icon' => 'success', 'data_table' => 'atualizar'];
        }
    }
    return ['title' => 'Erro!', 'msg' => 'Não foi possível alterar o tempo. Cliente não encontrado ou sem permissão.', 'icon' => 'error'];
}

/**
 * Gera o modal para ativar um teste.
 */
function ativar_teste($id)
{
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'] ?? 0;
    $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = :id AND admin_id = :admin_id");
    $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if(!$cliente) {
        return ['modal_titulo' => 'Erro', 'modal_body' => 'Teste não encontrado.'];
    }
    $usuario = $cliente['usuario'];

    $modal_body = "<form id='formAtivarTeste-{$id}' method='POST'>";
    $modal_body .= "<input type='hidden' name='confirme_ativar_teste' value='{$id}'>";
    $modal_body .= "<label>Ativar por (meses):</label>";
    $modal_body .= "<input type='number' name='ativar_meses' class='form-control' value='1' min='1' max='12'>";
    $modal_body .= "</form>";
    $modal_footer = "<button type='button' class='btn btn-success' onclick='enviarFormulario(\"formAtivarTeste-{$id}\", \"testes.php\")'>Ativar Cliente</button>";
    return ['modal_header_class' => "modal-header bg-success text-white", 'modal_titulo' => "Ativar Cliente (".htmlspecialchars($usuario).")", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
}

/**
 * Processa a ativação de um teste.
 */
function confirme_ativar_teste($post_data)
{
    $conexao = conectar_bd();
    $id = (int)($post_data['confirme_ativar_teste'] ?? 0);
    $meses = (int)($post_data['ativar_meses'] ?? 1);
    $admin_id = $_SESSION['admin_id'] ?? 0;

    $custo = $meses;

    $stmt_admin = $conexao->prepare("SELECT creditos FROM admin WHERE id = :admin_id");
    $stmt_admin->execute([':admin_id' => $admin_id]);
    $admin_creditos = (int)$stmt_admin->fetchColumn();

    if ($admin_creditos < $custo) {
        return ['title' => 'Créditos Insuficientes!', 'msg' => "Você precisa de {$custo} créditos para ativar este cliente, mas só tem {$admin_creditos}.", 'icon' => 'error'];
    }

    $stmt_cliente = $conexao->prepare("SELECT Vencimento FROM clientes WHERE id = :id AND admin_id = :admin_id");
    $stmt_cliente->execute([':id' => $id, ':admin_id' => $admin_id]);

    if ($cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC)) {
        $base_data = (strtotime($cliente['Vencimento']) > time()) ? $cliente['Vencimento'] : date("Y-m-d H:i:s");
        $nova_data = date("Y-m-d 23:59:59", strtotime("{$base_data} +{$meses} month"));

        $stmt_update = $conexao->prepare("UPDATE clientes SET Vencimento = :nova_data, is_trial = 0 WHERE id = :id");
        if ($stmt_update->execute([':nova_data' => $nova_data, ':id' => $id])) {
            $stmt_creditos = $conexao->prepare("UPDATE admin SET creditos = creditos - :custo WHERE id = :admin_id");
            $stmt_creditos->execute([':custo' => $custo, ':admin_id' => $admin_id]);
            return ['title' => 'Concluído!', 'msg' => "Cliente ativado por {$meses} mes(es). Custo: {$custo} crédito(s).", 'icon' => 'success', 'data_table' => 'atualizar'];
        }
    }
    return ['title' => 'Erro!', 'msg' => 'Não foi possível ativar o cliente.', 'icon' => 'error'];
}

/**
 * Gera o modal de confirmação para exclusão de um teste. (VERSÃO CORRIGIDA)
 */
function delete_cliente($id)
{
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'] ?? 0;

        $stmt = $conexao->prepare("SELECT usuario FROM clientes WHERE id = :id AND admin_id = :admin_id");
        $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$cliente) {
            return ['modal_titulo' => 'Erro', 'modal_body' => 'Teste não encontrado ou você não tem permissão para excluí-lo.'];
        }
        $usuario = $cliente['usuario'];

        $modal_body = "<form id='formDeletarTeste-{$id}' method='POST'>";
        $modal_body .= "<input type='hidden' name='confirme_delete_cliente' value='{$id}'>";
        $modal_body .= "Tem certeza que deseja excluir o teste de <b>".htmlspecialchars($usuario)."</b> permanentemente?";
        $modal_body .= "</form>";
        $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' class='btn btn-danger' onclick='enviarFormulario(\"formDeletarTeste-{$id}\", \"testes.php\")'>EXCLUIR</button>";
        
        return ['modal_header_class' => "modal-header bg-danger text-white", 'modal_titulo' => "EXCLUIR TESTE", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer];
    } catch (PDOException $e) {
        return ['modal_titulo' => 'Erro de BD', 'modal_body' => 'Ocorreu um erro ao buscar os dados do teste: ' . $e->getMessage()];
    }
}

/**
 * Processa a exclusão de um teste.
 */
function confirme_delete_cliente($post_data)
{
    $conexao = conectar_bd();
    $id = (int)($post_data['confirme_delete_cliente'] ?? 0);
    $admin_id = $_SESSION['admin_id'] ?? 0;
    
    $stmt = $conexao->prepare("DELETE FROM clientes WHERE id = :id AND admin_id = :admin_id");
    if ($stmt->execute([':id' => $id, ':admin_id' => $admin_id])) {
        if ($stmt->rowCount() > 0) {
            return ['title' => 'Sucesso!', 'msg' => 'Teste deletado com sucesso!', 'icon' => 'success', 'data_table' => 'atualizar'];
        }
    }
    return ['title' => 'Erro!', 'msg' => 'Não foi possível deletar o teste ou você não tem permissão.', 'icon' => 'error'];
}

/**
 * Gera o formulário para adicionar um novo teste.
 */
function adicionar_testes()
{
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'] ?? 0;
    
    $planoOptions = "";
    $stmt_planos = $conexao->prepare("SELECT * FROM planos WHERE admin_id = ?");
    $stmt_planos->execute([$admin_id]);
    while ($plano = $stmt_planos->fetch()) {
        $planoOptions .= "<option value='{$plano['id']}'>".htmlspecialchars($plano['nome'])."</option>";
    }
    
    $modal_body = "<form id='formAdicionarTeste' method='POST'>";
    $modal_body .= "<input type='hidden' name='confirme_adicionar_testes' value='1'>";
    $modal_body .= "<div class='form-group'><label>Nome:</label><input type='text' class='form-control' name='name' placeholder='Ex: Cliente João'></div>";
    $modal_body .= "<div class='row'><div class='form-group col-6'><label>Usuário:</label><input type='text' class='form-control' name='usuario' value='" . substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, 8) . "'></div>";
    $modal_body .= "<div class='form-group col-6'><label>Senha:</label><input type='text' class='form-control' name='senha' value='" . substr(str_shuffle('0123456789'), 0, 6) . "'></div></div>";
    $modal_body .= "<div class='form-group'><label>Duração (Horas):</label><input type='number' class='form-control' name='tempo' value='3'></div>";
    $modal_body .= "<div class='form-group'><label>Plano:</label><select class='form-select' name='plano'>{$planoOptions}</select></div>";
    $modal_body .= "<div class='form-group'><label>Whatsapp:</label><input type='text' class='form-control' name='whatsapp' placeholder='Ex: 5511999998888'></div>";
    $modal_body .= "</form>";
    $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' class='btn btn-primary' onclick='enviarFormulario(\"formAdicionarTeste\", \"testes.php\")'>Adicionar</button>";

    return ['modal_header_class'=> "modal-header bg-primary text-white", 'modal_titulo'=> "Adicionar Novo Teste", 'modal_body'=> $modal_body, 'modal_footer'=> $modal_footer];
}

/**
 * Processa a adição de um novo teste.
 */
function confirme_adicionar_testes($post_data)
{  
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'] ?? 0;
    
    if (!$admin_id) return ['title' => 'Erro!', 'msg' => 'Sessão inválida.', 'icon' => 'error'];

    $name = !empty($post_data['name']) ? $post_data['name'] : 'Teste Rápido';
    $usuario = $post_data['usuario'] ?? null;
    $senha = $post_data['senha'] ?? null;
    $plano = $post_data['plano'] ?? null;
    $Whatsapp = $post_data['whatsapp'] ?? null;
    $tempo = $post_data['tempo'] ?? 3;

    if(empty($usuario) || empty($senha) || empty($plano)) {
        return ['title' => 'Erro!', 'msg' => 'Usuário, senha e plano são obrigatórios.', 'icon' => 'error'];
    }

    $stmt_check = $conexao->prepare("SELECT id FROM clientes WHERE usuario = :usuario");
    if ($stmt_check->execute([':usuario' => $usuario]) && $stmt_check->fetch()) {
        return ['title' => 'Erro!', 'msg' => 'Usuário já cadastrado.', 'icon' => 'error'];
    }
    
    $vencimento = date("Y-m-d H:i:s", strtotime("+" . abs(intval($tempo)) . " hour"));
    
    $sql_insert = "INSERT INTO clientes (admin_id, name, usuario, senha, Criado_em, Vencimento, is_trial, plano, Whatsapp) 
                   VALUES (:admin_id, :name, :usuario, :senha, NOW(), :vencimento, 1, :plano, :whatsapp)";
    $stmt_insert = $conexao->prepare($sql_insert);
    
    $params = [
        ':admin_id'   => $admin_id, 
        ':name'       => $name, 
        ':usuario'    => $usuario, 
        ':senha'      => $senha,
        ':vencimento' => $vencimento, 
        ':plano'      => $plano,
        ':whatsapp'   => $Whatsapp
    ];

    if ($stmt_insert->execute($params)) {
        
        $template_file = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
        $template = file_exists($template_file) ? file_get_contents($template_file) : "ERRO: template_mensagem.txt não encontrado!";
        $portal_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
        $m3u_ts_long = $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=ts';
        $m3u_hls_long = $portal_url . '/get.php?username=' . $usuario . '&password=' . $senha . '&type=m3u_plus&output=m3u8';
        
        $replacements = [
            '#username#'        => $usuario,
            '#password#'        => $senha,
            '#url#'             => $portal_url,
            '#exp_date#'        => date('d/m/Y H:i', strtotime($vencimento)),
            '#m3u_link#'        => $m3u_ts_long,
            '#m3u_link_hls#'    => $m3u_hls_long,
            '#ssiptv_link#'     => $m3u_ts_long,
            '#m3u_encurtado#'   => encurtar_url($m3u_ts_long),
            '#m3u_hls_encurtado#' => encurtar_url($m3u_hls_long),
            '#ssiptv_encurtado#' => encurtar_url($m3u_ts_long),
        ];
        $mensagem_final = str_replace(array_keys($replacements), array_values($replacements), $template);

        return [
            'title'             => 'Sucesso!', 
            'msg'               => 'Teste criado com sucesso!', 
            'icon'              => 'success', 
            'data_table'        => 'atualizar', 
            'dados_cliente_msg' => $mensagem_final 
        ];

    } else {
        return ['title' => 'Erro!', 'msg' => 'Erro ao inserir o teste: ' . implode(" - ", $stmt_insert->errorInfo()), 'icon' => 'error'];
    }
}
?>