<?php
// =========================================================================
// PARTE 1: LÓGICA DE API (BACK-END) - VERSÃO COM CAMINHOS CORRIGIDOS FINAIS
// =========================================================================
if (isset($_GET['action'])) {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    header('Content-Type: application/json; charset=utf-8');

    if (empty($_SESSION['logged_in_fxtream'])) {
        echo json_encode(['error' => 'Sessão inválida ou expirada.']);
        exit();
    }
    
    $db_path = 'api/controles/db.php';
    $tmdb_model_path = 'api/tmdb.php'; 

    if (!file_exists($db_path)) {
        echo json_encode(['error' => 'ERRO CRÍTICO: O arquivo de controle db.php não foi encontrado. Caminho tentado: ' . $db_path]);
        exit();
    }
    if (!file_exists($tmdb_model_path)) {
        echo json_encode(['error' => 'ERRO CRÍTICO: O arquivo de modelo TMDB.php não foi encontrado. Caminho tentado: ' . $tmdb_model_path]);
        exit();
    }

    require_once($db_path); 
    require_once($tmdb_model_path); 

    if (!function_exists('conectar_bd')) { 
        echo json_encode(['error' => 'Função conectar_bd() não encontrada. Verifique o arquivo db.php']); 
        exit(); 
    }
    $pdo = conectar_bd();
    if ($pdo === null) {
        echo json_encode(['error' => 'Falha ao conectar com o banco de dados.']);
        exit();
    }

    $tipo = $_GET['tipo'] ?? 'filmes';
    $tabela = ($tipo === 'filmes') ? 'streams' : 'series';

    switch ($_GET['action']) {
        case 'listar':
            $stmt = $pdo->query("SELECT id, name FROM {$tabela} WHERE (tmdb_id IS NULL OR tmdb_id = '') AND category_id IS NOT NULL AND category_id > 0");
            echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
            break;
        case 'atualizar':
            $stmt = $pdo->prepare("UPDATE {$tabela} SET tmdb_id = ? WHERE id = ?");
            $stmt->execute([$_POST['tmdb_id'], (int)$_POST['id']]);
            if ($stmt->rowCount() > 0) { echo json_encode(['success' => true]); } 
            else { echo json_encode(['success' => false, 'message' => "Nenhum item encontrado com o ID local {$_POST['id']}."]); }
            break;
        case 'atualizar_infos':
            $stmt = $pdo->query("SELECT id, name, tmdb_id FROM {$tabela} WHERE tmdb_id IS NOT NULL AND tmdb_id != '' AND category_id IS NOT NULL AND category_id > 0");
            echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
            break;
        case 'get_detalhes':
            // ----> CORREÇÃO FINAL APLICADA AQUI <----
            // Removemos o "\models\" da frente para chamar a classe corretamente.
            if ($tipo === 'filmes') { echo json_encode(TMDB::getFilme($_GET['tmdb_id'])); }
            else { echo json_encode(TMDB::getSerie($_GET['tmdb_id'])); }
            break;
        case 'salvar_detalhes':
             if ($tipo === 'filmes') {
                 $stmt = $pdo->prepare("UPDATE streams SET name = :titulo, plot = :plot, stream_icon = :stream_icon, backdrop_path = :backdrop_path, releaseDate = :release_date, rating = :rating, rating_5based = :rating_5based, year = :year, genre = :genre, director = :director, actors = :actors, duration = :duration, youtube_trailer = :youtube_trailer WHERE id = :id");
                 $stmt->execute([':titulo' => $_POST['titulo'] ?? null, ':plot' => $_POST['plot'] ?? null, ':stream_icon' => $_POST['stream_icon'] ?? null, ':backdrop_path' => $_POST['backdrop_path'] ?? null, ':release_date' => $_POST['release_date'] ?? null, ':rating' => $_POST['rating'] ?? null, ':rating_5based' => $_POST['rating_5based'] ?? null, ':year' => $_POST['year'] ?? null, ':genre' => $_POST['genre'] ?? null, ':director' => $_POST['director'] ?? null, ':actors' => $_POST['actors'] ?? null, ':duration' => $_POST['duration'] ?? null, ':youtube_trailer' => $_POST['youtube_trailer'] ?? null, ':id' => $_POST['id'] ?? null ]);
            } else {
                 $stmt = $pdo->prepare("UPDATE series SET name = :titulo, plot = :plot, cover = :cover, backdrop_path = :backdrop_path, releaseDate = :release_date, rating = :rating, rating_5based = :rating_5based, year = :year, genre = :genre, director = :director, cast = :cast, youtube_trailer = :youtube_trailer WHERE id = :id");
                 $stmt->execute([':titulo' => $_POST['titulo'] ?? null, ':plot' => $_POST['plot'] ?? null, ':cover' => $_POST['cover'] ?? null, ':backdrop_path' => $_POST['backdrop_path'] ?? null, ':release_date' => $_POST['release_date'] ?? null, ':rating' => $_POST['rating'] ?? null, ':rating_5based' => $_POST['rating_5based'] ?? null, ':year' => $_POST['year'] ?? null, ':genre' => $_POST['genre'] ?? null, ':director' => $_POST['director'] ?? null, ':cast' => $_POST['cast'] ?? null, ':youtube_trailer' => $_POST['youtube_trailer'] ?? null, ':id' => $_POST['id'] ?? null]);
            }
            echo json_encode(['success' => true]);
            break;
    }
    exit();
}

// =========================================================================
// PARTE 2: PÁGINA NORMAL (FRONT-END)
// =========================================================================
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (empty($_SESSION['logged_in_fxtream'])) {
    header("Location: ./index.php");
    exit();
}
// Se você tem um menu, pode descomentar a linha abaixo
// require_once("menu.php"); 
$sessionId = session_id();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Atualização de Vods</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style> body { background-color: #f8f9fa; } .main-header { background-color: #3b7ddd; color: white; padding: 1rem 1.5rem; margin-bottom: 2rem; border-radius: 0.5rem; } .log-console { background-color: #212529; color: #f8f9fa; font-family: 'Courier New', Courier, monospace; height: 400px; overflow-y: auto; padding: 1rem; border-radius: 0.5rem; font-size: 0.85rem; white-space: pre-wrap; border: 1px solid #495057; } .log-console .log-entry { padding-bottom: 5px; } .log-success { color: #28a745; } .log-error { color: #dc3545; } .log-warning { color: #ffc107; } .log-info { color: #0dcaf0; } .log-dim { color: #6c757d; } .card-title .badge { font-size: .75rem; vertical-align: middle; } </style>
</head>
<body>
<div class="container-fluid mt-4">
    <div class="main-header shadow-sm"><h4><i class="fas fa-database"></i> Sistema de atualização de Vods</h4></div>
    <div class="row">
        <div class="col-lg-6 mb-4"><div class="card h-100 border-danger shadow-sm"><div class="card-body d-flex flex-column"><h5 class="card-title"><i class="fas fa-film"></i> Filmes<span id="status-filmes" class="badge bg-secondary float-end">Inativo</span></h5><p class="card-text text-muted">Inicia o processo completo: busca IDs faltantes e depois atualiza todas as informações.</p><div class="d-grid gap-2 mt-auto"><button id="btn-filmes" class="btn btn-danger btn-lg" onclick="adicionarTarefa('filmes')"><i class="fas fa-play-circle"></i> Iniciar Atualização Completa</button></div></div></div></div>
        <div class="col-lg-6 mb-4"><div class="card h-100 border-info shadow-sm"><div class="card-body d-flex flex-column"><h5 class="card-title"><i class="fas fa-tv"></i> Séries<span id="status-series" class="badge bg-secondary float-end">Inativo</span></h5><p class="card-text text-muted">Inicia o processo completo: busca IDs faltantes e depois atualiza todas as informações.</p><div class="d-grid gap-2 mt-auto"><button id="btn-series" class="btn btn-info btn-lg" onclick="adicionarTarefa('series')"><i class="fas fa-play-circle"></i> Iniciar Atualização Completa</button></div></div></div></div>
    </div>
    <div class="text-center my-3"><button class="btn btn-danger btn-lg mx-2" onclick="pararTodasAsBuscas()"><i class="fas fa-stop-circle"></i> Parar Todas as Buscas</button></div>
    <div id="log-console" class="shadow-sm"></div>
</div>
<script>
const SID = '<?php echo $sessionId; ?>';
const FilaDeTarefas = { filmes: { ativa: false, lista: [], processados: 0, total: 0, status: 'inativo' }, series: { ativa: false, lista: [], processados: 0, total: 0, status: 'inativo' } };
let gerenciadorAtivo = false, cancelarTudo = false, logConsole = null;
const CHUNK_SIZE = 10;
function log(message, type = 'info') { if (!logConsole) return; const timestamp = new Date().toLocaleTimeString('pt-BR'); const entry = document.createElement('div'); entry.className = `log-entry log-${type}`; entry.innerHTML = `<span class="log-dim">[${timestamp}]</span> ${message}`; logConsole.appendChild(entry); logConsole.scrollTop = logConsole.scrollHeight; }
function atualizarStatusUI(tipo) { const tarefa = FilaDeTarefas[tipo]; const badge = document.getElementById(`status-${tipo}`); const botao = document.getElementById(`btn-${tipo}`); if (!badge || !botao) return; botao.disabled = tarefa.ativa; switch(tarefa.status) { case 'inativo': badge.className = 'badge bg-secondary float-end'; badge.innerText = 'Inativo'; break; case 'buscando_ids': badge.className = 'badge bg-primary float-end'; badge.innerText = `Buscando IDs...`; break; case 'atualizando_infos': badge.className = 'badge bg-warning text-dark float-end'; badge.innerText = `Atualizando ${tarefa.processados}/${tarefa.total}`; break; case 'concluido': badge.className = 'badge bg-success float-end'; badge.innerText = 'Concluído'; break; } }
async function adicionarTarefa(tipo) { if (FilaDeTarefas[tipo].ativa) { log(`A tarefa de ${tipo} já está em andamento.`, 'warning'); return; } log(`[GERENCIADOR] Tarefa de ${tipo} adicionada à fila.`, 'info'); FilaDeTarefas[tipo].ativa = true; FilaDeTarefas[tipo].status = 'buscando_ids'; atualizarStatusUI(tipo); if (!gerenciadorAtivo) await iniciarGerenciador(); }
function pararTodasAsBuscas() { log('🔴 Comando de PARADA GERAL enviado!', 'error'); cancelarTudo = true; }
async function iniciarGerenciador() {
    gerenciadorAtivo = true; cancelarTudo = false; log('[GERENCIADOR] 🚀 Iniciado.', 'success');
    if (FilaDeTarefas.filmes.ativa) await buscarTMDB_IDs('filmes'); if (cancelarTudo) return finalizarGerenciador();
    if (FilaDeTarefas.series.ativa) await buscarTMDB_IDs('series'); if (cancelarTudo) return finalizarGerenciador();
    try {
        if (FilaDeTarefas.filmes.ativa) {
            log('[GERENCIADOR] Preparando lista de filmes para atualizar...', 'dim');
            const res = await fetch(`?action=atualizar_infos&tipo=filmes&sid=${SID}`); const items = await res.json();
            if (!Array.isArray(items)) throw new Error(`API de filmes retornou um erro: ${items.error || 'resposta inválida'}`);
            FilaDeTarefas.filmes.lista = items; FilaDeTarefas.filmes.total = items.length; FilaDeTarefas.filmes.processados = 0; FilaDeTarefas.filmes.status = 'atualizando_infos'; atualizarStatusUI('filmes');
        }
        if (FilaDeTarefas.series.ativa) {
            log('[GERENCIADOR] Preparando lista de séries para atualizar...', 'dim');
            const res = await fetch(`?action=atualizar_infos&tipo=series&sid=${SID}`); const items = await res.json();
            if (!Array.isArray(items)) throw new Error(`API de séries retornou um erro: ${items.error || 'resposta inválida'}`);
            FilaDeTarefas.series.lista = items; FilaDeTarefas.series.total = items.length; FilaDeTarefas.series.processados = 0; FilaDeTarefas.series.status = 'atualizando_infos'; atualizarStatusUI('series');
        }
    } catch (e) { log(`[GERENCIADOR] ERRO ao preparar listas: ${e.message}`, 'error'); return finalizarGerenciador(); }
    log('[GERENCIADOR] 🔄 Iniciando processamento intercalado de informações...', 'info');
    while (FilaDeTarefas.filmes.ativa || FilaDeTarefas.series.ativa) { if (cancelarTudo) break; if (FilaDeTarefas.filmes.ativa) await processarFatia('filmes'); if (FilaDeTarefas.series.ativa) await processarFatia('series'); }
    finalizarGerenciador();
}
async function processarFatia(tipo) { const tarefa = FilaDeTarefas[tipo]; const fatia = tarefa.lista.splice(0, CHUNK_SIZE); if (fatia.length > 0) { await processarBloco(fatia, tipo); tarefa.processados += fatia.length; atualizarStatusUI(tipo); } else { tarefa.ativa = false; tarefa.status = 'concluido'; log(`[GERENCIADOR] ✅ Fila de ${tipo.toUpperCase()} concluída!`, 'success'); atualizarStatusUI(tipo); } }
function finalizarGerenciador() { log(`[GERENCIADOR] ⏹️ Finalizado.`, cancelarTudo ? 'warning' : 'success'); gerenciadorAtivo = false; for (const tipo of ['filmes', 'series']) { const tarefa = FilaDeTarefas[tipo]; if (tarefa.status !== 'concluido') { tarefa.ativa = false; tarefa.status = 'inativo'; atualizarStatusUI(tipo); } } }
async function buscarTMDB_IDs(tipo) {
    const buscarIdFunc = tipo === 'filmes' ? buscarTMDBId_Filme : buscarTMDBId_Serie;
    log(`🔎 Buscando IDs de ${tipo.toUpperCase()} faltantes...`, 'info');
    try {
        const res = await fetch(`?action=listar&tipo=${tipo}&sid=${SID}`);
        if (!res.ok) throw new Error(`Servidor respondeu com erro HTTP: ${res.status}`);
        const items = await res.json();
        if (!Array.isArray(items)) { if (items && items.error) throw new Error(`Back-end retornou um erro: ${items.error}`); throw new Error('Resposta do back-end não é uma lista válida.'); }
        log(`[${tipo.toUpperCase()}] Encontrados ${items.length} itens sem TMDB ID.`);
        for (const item of items) {
            if (cancelarTudo) break;
            const tmdb_id = await buscarIdFunc(item.name);
            if (tmdb_id) {
                const updateResponse = await fetch(`?action=atualizar&tipo=${tipo}`, { method: 'POST', headers: {'Content-Type': 'application/x-www-form-urlencoded'}, body: `id=${item.id}&tmdb_id=${tmdb_id}&sid=${SID}` });
                const updateResult = await updateResponse.json();
                if (updateResult.success) { log(`[${tipo.slice(0,1).toUpperCase()}] ${item.name} → ID ${tmdb_id}`, 'success'); } 
                else { log(`[${tipo.slice(0,1).toUpperCase()}] ERRO ao salvar ID para '${item.name}': ${updateResult.message}`, 'error'); }
            }
        }
        log(`[${tipo.toUpperCase()}] Busca de IDs finalizada.`, 'success');
    } catch(e) { log(`ERRO FATAL ao buscar IDs de ${tipo.toUpperCase()}: ${e.message}`, 'error'); FilaDeTarefas[tipo].ativa = false; FilaDeTarefas[tipo].status = 'inativo'; atualizarStatusUI(tipo); }
}
async function processarBloco(bloco, tipo) { 
    for (const item of bloco) { 
        if (cancelarTudo) return; 
        try { 
            const res = await fetch(`?action=get_detalhes&tipo=${tipo}&tmdb_id=${item.tmdb_id}&sid=${SID}`); 
            const info = await res.json(); 
            let bodyParams = { sid: SID, id: item.id, titulo: info.nome, plot: info.plot, stream_icon: info.logo, cover: info.logo, backdrop_path: info.backdrop_path, release_date: info.releasedate, rating: info.rating, rating_5based: info.rating_5based, year: info.year, genre: info.genre, director: info.director, youtube_trailer: '' }; 
            if (tipo === 'filmes') { bodyParams.actors = info.actors; bodyParams.duration = info.duration; } 
            else { bodyParams.cast = info.cast; } 
            await fetch(`?action=salvar_detalhes&tipo=${tipo}`, { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: new URLSearchParams(bodyParams) }); 
            log(`[${tipo.slice(0,1).toUpperCase()}] ${item.name} atualizado.`, 'dim'); 
        } catch (e) { log(`Erro ao processar ${tipo} ${item.name}: ${e.message}`, 'error'); } 
    } 
    await new Promise(resolve => setTimeout(resolve, 200)); 
}
function limparNome_Filme(nome) { if (!nome) return ''; nome = nome.replace(/\(.*?\)/g, '').replace(/\[.*?\]/g, '').replace(/\b(19|20)\d{2}\b/g, '').normalize('NFD').replace(/[\u0300-\u036f]/g, '').replace(/[^a-zA-Z0-9\s]/g, '').replace(/\b(LEG|Leg|leg|Legendado)\b/g, '').replace(/\s+/g, ' ').trim(); return nome.toLowerCase(); }
function extrairAno_Filme(nome) { if (!nome) return null; const anoMatch = nome.match(/\b(19|20)\d{2}\b/); return anoMatch ? anoMatch[0] : null; }
async function buscarTMDBId_Filme(nomeOriginal) { const chave = '66d600a2e10bb528752724cddadf6f8c'; const nomeFiltrado = limparNome_Filme(nomeOriginal); const anoExtraido = extrairAno_Filme(nomeOriginal); let url = `https://api.themoviedb.org/3/search/movie?api_key=${chave}&query=${encodeURIComponent(nomeFiltrado)}&language=pt-BR&include_adult=true`; if (anoExtraido) { url += `&year=${anoExtraido}`; } const res = await fetch(url); const json = await res.json(); return json.results?.[0]?.id ?? null; }
function limparNome_Serie(nome) { if (!nome) return ''; nome = nome.replace(/\(.*?\)/g, '').replace(/\[.*?\]/g, '').replace(/\b(19|20)\d{2}\b/g, '').normalize('NFD').replace(/[\u0300-\u036f]/g, '').replace(/[^a-zA-Z0-9\s]/g, '').replace(/\s+/g, ' ').trim(); return nome.toLowerCase(); }
async function buscarTMDBId_Serie(nomeOriginal) { const chave = '66d600a2e10bb528752724cddadf6f8c'; const nomeFiltrado = limparNome_Serie(nomeOriginal); const url = `https://api.themoviedb.org/3/search/tv?api_key=${chave}&query=${encodeURIComponent(nomeFiltrado)}&language=pt-BR&include_adult=true`; const res = await fetch(url); const json = await res.json(); return json.results?.[0]?.id ?? null; }
document.addEventListener('DOMContentLoaded', () => { logConsole = document.getElementById('log-console'); if (!logConsole) { alert("ERRO CRÍTICO: O elemento do console de log com ID 'log-console' não foi encontrado na página."); return; } log('[TMDB] ✅ Sistema TMDB (Tudo-em-Um) carregado', 'success'); log('[INFO] ℹ️ Clique em "Iniciar Atualização" para adicionar uma tarefa à fila.', 'info'); atualizarStatusUI('filmes'); atualizarStatusUI('series'); });
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>