<?php
// session_start(); // Removido
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once(dirname(__DIR__, 2) . '/api/controles/db.php');

// Bloco 'if !isset' removido
$data = json_decode(file_get_contents("php://input"), true);

if (empty($data['id']) || empty($data['name']) || empty($data['usuario']) || empty($data['senha']) || empty($data['vencimento'])) {
    http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'Dados incompletos para atualização.']));
}

try {
    $pdo = conectar_bd();
    // CORREÇÃO: Usa 'name' e 'Vencimento'
    $sql = "UPDATE clientes SET name = :name, usuario = :usuario, senha = :senha, Vencimento = :vencimento WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':name' => $data['name'], ':usuario' => $data['usuario'], ':senha' => $data['senha'], ':vencimento' => $data['vencimento'], ':id' => $data['id']]);
    echo json_encode(['status' => 'success', 'message' => 'Cliente atualizado com sucesso.']);
} catch (PDOException $e) {
    if ($e->getCode() == 23000) { die(json_encode(['status' => 'error', 'message' => 'Usuário já existe.'])); }
    http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao atualizar cliente: ' . $e->getMessage()]));
}
?>