<?php
// session_start(); // Removido
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once(dirname(__DIR__, 2) . '/api/controles/db.php');

// Bloco 'if !isset' removido
if (!isset($_GET['id'])) { http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'ID do cliente não fornecido.'])); }

try {
    $pdo = conectar_bd();
    // CORREÇÃO: Seleciona 'name' e 'Vencimento'
    $stmt = $pdo->prepare("SELECT id, name, usuario, senha, Vencimento FROM clientes WHERE id = :id");
    $stmt->execute([':id' => $_GET['id']]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cliente) {
        echo json_encode(['status' => 'success', 'data' => $cliente]);
    } else { http_response_code(404); echo json_encode(['status' => 'error', 'message' => 'Cliente não encontrado.']); }
} catch (PDOException $e) { http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao buscar cliente: ' . $e->getMessage()])); }
?>