<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['admin_id'])) {
    http_response_code(403);
    die(json_encode(['status' => 'error', 'message' => 'Acesso negado.']));
}

require_once(dirname(__DIR__, 2) . '/api/controles/db.php');

$data = json_decode(file_get_contents("php://input"), true);

// Validação simples dos dados recebidos
if (empty($data['nome']) || empty($data['usuario']) || empty($data['senha']) || empty($data['vencimento'])) {
     http_response_code(400);
     die(json_encode(['status' => 'error', 'message' => 'Todos os campos são obrigatórios.']));
}

try {
    $pdo = conectar_bd();

    // Pega o ID do admin/revendedor que está logado na sessão
    $admin_id_logado = $_SESSION['admin_id'];

    // Prepara o comando INSERT, incluindo a coluna 'admin_id'
    $sql = "INSERT INTO clientes (name, usuario, senha, Vencimento, admin_id, Criado_em, is_trial) 
            VALUES (:name, :usuario, :senha, :vencimento, :admin_id, NOW(), 0)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name' => $data['nome'],
        ':usuario' => $data['usuario'],
        ':senha' => $data['senha'], // IMPORTANTE: Considere usar password_hash() para segurança
        ':vencimento' => $data['vencimento'],
        ':admin_id' => $admin_id_logado // Salva o ID de quem criou o cliente
    ]);

    echo json_encode(['status' => 'success', 'message' => 'Cliente criado com sucesso.']);

} catch (PDOException $e) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Erro ao criar cliente: ' . $e->getMessage()]));
}
?>