<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once '../controles/db.php';

try {
    $pdo = conectar_bd();

    // --- LÓGICA PARA GERAR DADOS DE TESTE ---

    // 1. Gera um usuário e senha únicos baseados no tempo atual para evitar repetição
    $sufixoUnico = time() % 100000; // Pega os últimos 5 dígitos do timestamp atual
    $usuario_teste = "teste" . $sufixoUnico;
    $senha_teste = rand(1000, 9999); // Gera uma senha numérica de 4 dígitos

    // 2. Define o nome e o vencimento (24 horas a partir de agora)
    $nome_teste = "Teste Rápido";
    $data = new DateTime(); // Pega a data e hora de agora, 26 de Setembro de 2025
    $data->add(new DateInterval('P1D')); // Adiciona 1 dia (Período de 1 Dia)
    $vencimento_teste = $data->format('Y-m-d');


    // --- INSERÇÃO NO BANCO DE DADOS ---
    $sql = "INSERT INTO clientes (nome, usuario, senha, vencimento, criado_em, status) VALUES (:nome, :usuario, :senha, :vencimento, NOW(), 'Ativo')";
    $stmt = $pdo->prepare($sql);
    
    $stmt->execute([
        ':nome' => $nome_teste, 
        ':usuario' => $usuario_teste, 
        ':senha' => $senha_teste, 
        ':vencimento' => $vencimento_teste
    ]);
    
    // Pega o ID do teste recém-criado para retornar ao front-end
    $novoId = $pdo->lastInsertId();

    echo json_encode(['status' => 'success', 'message' => 'Teste rápido criado com sucesso.', 'novoId' => $novoId]);

} catch (PDOException $e) {
    http_response_code(500); 
    die(json_encode(['status' => 'error', 'message' => 'Erro ao criar teste: ' . $e->getMessage()]));
}
?>