<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once '../controles/db.php';

$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['nome']) || empty($data['duracao_horas'])) {
    http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'Nome ou duração não fornecidos.']));
}

try {
    $pdo = conectar_bd();

    $nome_teste = $data['nome'];
    $duracao_horas = (int)$data['duracao_horas'];
    
    // Gera um usuário e senha únicos
    $sufixoUnico = time() % 100000;
    $usuario_teste = "teste" . $sufixoUnico;
    $senha_teste = rand(1000, 9999);

    // Calcula o vencimento baseado nas horas recebidas
    $data = new DateTime();
    // 'PT' significa Período de Tempo, e 'H' significa Horas
    $data->add(new DateInterval("PT{$duracao_horas}H"));
    $vencimento_teste = $data->format('Y-m-d H:i:s');

    // Insere no banco de dados
    $sql = "INSERT INTO clientes (nome, usuario, senha, vencimento, criado_em, status) VALUES (:nome, :usuario, :senha, :vencimento, NOW(), 'Ativo')";
    $stmt = $pdo->prepare($sql);
    
    $stmt->execute([
        ':nome' => $nome_teste, 
        ':usuario' => $usuario_teste, 
        ':senha' => $senha_teste, 
        ':vencimento' => $vencimento_teste
    ]);
    
    $novoId = $pdo->lastInsertId();

    echo json_encode(['status' => 'success', 'message' => 'Teste criado com sucesso.', 'novoId' => $novoId]);

} catch (PDOException $e) {
    http_response_code(500); 
    die(json_encode(['status' => 'error', 'message' => 'Erro ao criar teste: ' . $e->getMessage()]));
}
?>