<?php
// session_start(); // Removido
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once(dirname(__DIR__, 2) . '/api/controles/db.php');

// Bloco 'if !isset' removido
$data = json_decode(file_get_contents("php://input"), true);
if (empty($data['id'])) { http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'ID do cliente não fornecido.'])); }

try {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("DELETE FROM clientes WHERE id = :id");
    $stmt->execute([':id' => $data['id']]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Cliente excluído com sucesso.']);
    } else { http_response_code(404); echo json_encode(['status' => 'error', 'message' => 'Cliente não encontrado.']); }
} catch (PDOException $e) { http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao excluir cliente: ' . $e->getMessage()])); }
?>