document.addEventListener('DOMContentLoaded', () => {
    // --- LÓGICA DO TEMA ---
    const themeToggle = document.getElementById('theme-toggle');
    if (themeToggle) {
        const themeToggleIcon = themeToggle.querySelector('i');
        const applyTheme = (theme) => {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            themeToggleIcon.className = theme === 'dark' ? 'bi bi-sun-fill' : 'bi bi-moon-stars-fill';
        };
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) { applyTheme(currentTheme); }
        else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) { applyTheme('dark'); }
        const tooltip = new bootstrap.Tooltip(themeToggle);
        themeToggle.addEventListener('click', () => {
            const newTheme = document.documentElement.getAttribute('data-theme') === 'dark' ? 'light' : 'dark';
            applyTheme(newTheme);
        });
    }

    // --- INICIALIZAÇÃO DE ELEMENTOS (sempre verificar se existem) ---
    const tabelaClientes = document.getElementById('tabela-clientes');
    const campoBusca = document.getElementById('campo-busca');
    const formAdicionar = document.getElementById('form-adicionar-cliente');
    const adicionarClienteModal = document.getElementById('adicionarClienteModal') ? new bootstrap.Modal(document.getElementById('adicionarClienteModal')) : null;
    const formEditar = document.getElementById('form-editar-cliente');
    const editarClienteModal = document.getElementById('editarClienteModal') ? new bootstrap.Modal(document.getElementById('editarClienteModal')) : null;
    const formCriarTeste = document.getElementById('form-criar-teste');
    const criarTesteModal = document.getElementById('criarTesteModal') ? new bootstrap.Modal(document.getElementById('criarTesteModal')) : null;
    const infoClienteModal = document.getElementById('infoClienteModal') ? new bootstrap.Modal(document.getElementById('infoClienteModal')) : null;
    const infoClienteTexto = document.getElementById('info-cliente-texto');
    const btnCopiarInfo = document.getElementById('btn-copiar-info');
    const btnWhatsapp = document.getElementById('btn-whatsapp');
    const formRenovar = document.getElementById('form-renovar');
    const renovarModal = document.getElementById('renovarModal') ? new bootstrap.Modal(document.getElementById('renovarModal')) : null;
    const mensagemRenovacaoModal = document.getElementById('mensagemRenovacaoModal') ? new bootstrap.Modal(document.getElementById('mensagemRenovacaoModal')) : null;
    const mensagemRenovacaoTexto = document.getElementById('mensagem-renovacao-texto');
    const btnCopiarRenovacao = document.getElementById('btn-copiar-renovacao');
    const btnWhatsappRenovacao = document.getElementById('btn-whatsapp-renovacao');
    const opcoesDuracao = document.getElementById('opcoes-duracao');

    // --- FUNÇÕES GERAIS ---
    const exibirModalInfo = async (id) => {
        try {
            const response = await fetch(`/painel_api.php?action=gerar_mensagem&id=${id}`);
            const result = await response.json();
            if (result.status === 'success') {
                if(infoClienteTexto) infoClienteTexto.textContent = result.data.mensagem;
                if(infoClienteModal) infoClienteModal.show();
            } else { alert(`Erro: ${result.message}`); }
        } catch (error) { console.error("Erro ao buscar info:", error); }
    };

    const carregarClientes = async () => {
        if (!tabelaClientes) return; 
        try {
            // CORREÇÃO FINAL: Chamando o 'painel_api.php'
            const response = await fetch('/painel_api.php?action=listar_clientes');
            if (!response.ok) { throw new Error(`Erro de rede ou servidor: ${response.status}`); }
            const result = await response.json();
            tabelaClientes.innerHTML = '';

            if (result.status === 'success' && result.data.length > 0) {
                result.data.forEach(cliente => {
                    let dataFormatada = 'Não definido';
                    let statusBadge = '';

                    if (cliente.Vencimento) {
                        const dataVenc = new Date(cliente.Vencimento.replace(' ', 'T'));
                        dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                    }
                    if (cliente.status === 'Ativo') {
                        statusBadge = `<span class="badge bg-success">Ativo</span>`;
                    } else if (cliente.status === 'Vencido') {
                        statusBadge = `<span class="badge bg-danger">Vencido</span>`;
                    } else {
                        statusBadge = `<span class="badge bg-secondary">Inválido</span>`;
                    }

                    tabelaClientes.innerHTML += `<tr class="cliente-row">
                        <td class="cliente-nome">${cliente.name}</td>
                        <td class="cliente-usuario">${cliente.usuario}</td>
                        <td class="cliente-vencimento">${dataFormatada}</td>
                        <td>${statusBadge}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-success btn-renovar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Renovar"><i class="bi bi-calendar-plus-fill"></i></button>
                            <button class="btn btn-sm btn-outline-info btn-ver" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Ver Info"><i class="bi bi-eye-fill"></i></button>
                            <button class="btn btn-sm btn-outline-warning btn-editar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Editar"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger btn-excluir" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Excluir"><i class="bi bi-trash-fill"></i></button>
                        </td>
                    </tr>`;
                });
            } else {
                tabelaClientes.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum cliente encontrado.</td></tr>';
            }
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
        } catch (error) {
            console.error("ERRO ao carregar clientes:", error);
            tabelaClientes.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Falha ao carregar a lista. Detalhe: ${error.message}</td></tr>`;
        }
    };

    // --- EVENT LISTENERS (AGORA SÃO SEGUROS E CORRIGIDOS) ---
    
    if (formAdicionar && adicionarClienteModal) {
        formAdicionar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-adicionar').value, usuario: document.getElementById('usuario-adicionar').value, senha: document.getElementById('senha-adicionar').value, vencimento: document.getElementById('vencimento-adicionar').value };
            const response = await fetch('/painel_api.php?action=criar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                adicionarClienteModal.hide();
                await carregarClientes();
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formCriarTeste && criarTesteModal) {
        formCriarTeste.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-teste').value, usuario: document.getElementById('usuario-teste').value, senha: document.getElementById('senha-teste').value, duracao_horas: opcoesDuracao.querySelector('.btn.active').dataset.horas };
            const response = await fetch('/painel_api.php?action=criar_teste', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                criarTesteModal.hide();
                alert("Teste criado com sucesso!");
                // Se a página atual for a de testes, recarrega a lista de testes
                if (window.location.href.includes('gerenciar_testes')) {
                    // Assumindo que a função se chame carregarTestes()
                    if (typeof carregarTestes !== 'undefined') {
                        await carregarTestes();
                    }
                }
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formEditar && editarClienteModal) {
        formEditar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { id: document.getElementById('clienteId-editar').value, name: document.getElementById('nome-editar').value, usuario: document.getElementById('usuario-editar').value, senha: document.getElementById('senha-editar').value, vencimento: document.getElementById('vencimento-editar').value };
            const response = await fetch('/painel_api.php?action=atualizar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                editarClienteModal.hide();
                await carregarClientes();
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formRenovar && renovarModal) {
        formRenovar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const id = document.getElementById('renovarClienteId').value;
            const meses = document.getElementById('meses-renovacao').value;
            const response = await fetch('/painel_api.php?action=renovar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id, meses }) });
            const result = await response.json();
            if (result.status === 'success') {
                renovarModal.hide();
                await carregarClientes();
                const { usuario, senha, Vencimento } = result.data;
                const dataVenc = new Date(Vencimento.replace(' ', 'T'));
                const dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                mensagemRenovacaoTexto.textContent = `Plano renovado com sucesso!\n\n👤 Usuário: ${usuario}\n🔑 Senha: ${senha}\n📅 Próximo vencimento: ${dataFormatada}`;
                if(mensagemRenovacaoModal) mensagemRenovacaoModal.show();
            } else { alert(`Erro ao renovar: ${result.message}`); }
        });
    }
    
    if (tabelaClientes) {
        tabelaClientes.addEventListener('click', async (e) => {
            const target = e.target.closest('button');
            if (!target) return;
            const id = target.dataset.id;

            if (target.classList.contains('btn-ver')) {
                exibirModalInfo(id);
            } else if (target.classList.contains('btn-editar')) {
                try {
                    const response = await fetch(`/painel_api.php?action=buscar_cliente&id=${id}`);
                    if (!response.ok) { throw new Error(`Erro de rede: ${response.statusText}`); }
                    const result = await response.json();
                    
                    if (result.status === 'success' && result.data) {
                        const c = result.data;
                        document.getElementById('clienteId-editar').value = c.id;
                        document.getElementById('nome-editar').value = c.name;
                        document.getElementById('usuario-editar').value = c.usuario;
                        document.getElementById('senha-editar').value = c.senha;
                        if (c.Vencimento) {
                            document.getElementById('vencimento-editar').value = c.Vencimento.split(' ')[0];
                        }
                        if(editarClienteModal) editarClienteModal.show();
                    } else {
                        alert(`Erro ao buscar dados: ${result.message || 'Formato de resposta inválido.'}`);
                    }
                } catch (error) {
                    console.error('Falha na operação de edição:', error);
                    alert('Não foi possível carregar os dados para edição. Verifique o console (F12) para mais detalhes.');
                }
            } else if (target.classList.contains('btn-excluir')) {
                if (confirm('Tem certeza que deseja excluir este cliente?')) {
                    const response = await fetch('/painel_api.php?action=excluir_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id }) });
                    const result = await response.json();
                    alert(result.message);
                    if (result.status === 'success') { carregarClientes(); }
                }
            } else if (target.classList.contains('btn-renovar')) {
                document.getElementById('renovarClienteId').value = id;
                document.getElementById('meses-renovacao').value = 1;
                if(renovarModal) renovarModal.show();
            }
        });
    }

    const setupInfoActions = (btnCopy, btnWpp, textSource) => {
        if (!btnCopy || !btnWpp || !textSource) return;
        btnCopy.addEventListener('click', () => { navigator.clipboard.writeText(textSource.textContent).then(() => { const o = btnCopy.innerHTML; btnCopy.innerHTML = '<i class="bi bi-check-lg"></i> Copiado!'; setTimeout(() => { btnCopy.innerHTML = o; }, 2000); }); });
        btnWpp.addEventListener('click', () => { window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(textSource.textContent)}`, '_blank'); });
    };
    if(btnCopiarInfo) setupInfoActions(btnCopiarInfo, btnWhatsapp, infoClienteTexto);
    if(btnCopiarRenovacao) setupInfoActions(btnCopiarRenovacao, btnWhatsappRenovacao, mensagemRenovacaoTexto);
    
    if (campoBusca) {
        campoBusca.addEventListener('keyup', () => {
            const termo = campoBusca.value.toLowerCase();
            tabelaClientes.querySelectorAll('tr.cliente-row').forEach(linha => {
                const nome = linha.querySelector('.cliente-nome').textContent.toLowerCase();
                const usuario = linha.querySelector('.cliente-usuario').textContent.toLowerCase();
                linha.style.display = (nome.includes(termo) || usuario.includes(termo)) ? '' : 'none';
            });
        });
    }

    // --- CARGA INICIAL ---
    // A função a ser chamada depende da página. Podemos verificar a URL.
    if (window.location.href.includes('gerenciar_clientes') || window.location.href.endsWith('/')) {
        carregarClientes();
    }
    // Adicione um 'else if' para carregar testes se estiver na página de testes
});document.addEventListener('DOMContentLoaded', () => {
    // --- LÓGICA DO TEMA ---
    const themeToggle = document.getElementById('theme-toggle');
    if (themeToggle) {
        const themeToggleIcon = themeToggle.querySelector('i');
        const applyTheme = (theme) => {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            themeToggleIcon.className = theme === 'dark' ? 'bi bi-sun-fill' : 'bi bi-moon-stars-fill';
        };
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) { applyTheme(currentTheme); }
        else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) { applyTheme('dark'); }
        const tooltip = new bootstrap.Tooltip(themeToggle);
        themeToggle.addEventListener('click', () => {
            const newTheme = document.documentElement.getAttribute('data-theme') === 'dark' ? 'light' : 'dark';
            applyTheme(newTheme);
        });
    }

    // --- INICIALIZAÇÃO DE ELEMENTOS (sempre verificar se existem) ---
    const tabelaClientes = document.getElementById('tabela-clientes');
    const campoBusca = document.getElementById('campo-busca');
    const formAdicionar = document.getElementById('form-adicionar-cliente');
    const adicionarClienteModal = document.getElementById('adicionarClienteModal') ? new bootstrap.Modal(document.getElementById('adicionarClienteModal')) : null;
    const formEditar = document.getElementById('form-editar-cliente');
    const editarClienteModal = document.getElementById('editarClienteModal') ? new bootstrap.Modal(document.getElementById('editarClienteModal')) : null;
    const formCriarTeste = document.getElementById('form-criar-teste');
    const criarTesteModal = document.getElementById('criarTesteModal') ? new bootstrap.Modal(document.getElementById('criarTesteModal')) : null;
    const infoClienteModal = document.getElementById('infoClienteModal') ? new bootstrap.Modal(document.getElementById('infoClienteModal')) : null;
    const infoClienteTexto = document.getElementById('info-cliente-texto');
    const btnCopiarInfo = document.getElementById('btn-copiar-info');
    const btnWhatsapp = document.getElementById('btn-whatsapp');
    const formRenovar = document.getElementById('form-renovar');
    const renovarModal = document.getElementById('renovarModal') ? new bootstrap.Modal(document.getElementById('renovarModal')) : null;
    const mensagemRenovacaoModal = document.getElementById('mensagemRenovacaoModal') ? new bootstrap.Modal(document.getElementById('mensagemRenovacaoModal')) : null;
    const mensagemRenovacaoTexto = document.getElementById('mensagem-renovacao-texto');
    const btnCopiarRenovacao = document.getElementById('btn-copiar-renovacao');
    const btnWhatsappRenovacao = document.getElementById('btn-whatsapp-renovacao');
    const opcoesDuracao = document.getElementById('opcoes-duracao');

    // --- FUNÇÕES GERAIS ---
    const exibirModalInfo = async (id) => {
        try {
            const response = await fetch(`/painel_api.php?action=gerar_mensagem&id=${id}`);
            const result = await response.json();
            if (result.status === 'success') {
                if(infoClienteTexto) infoClienteTexto.textContent = result.data.mensagem;
                if(infoClienteModal) infoClienteModal.show();
            } else { alert(`Erro: ${result.message}`); }
        } catch (error) { console.error("Erro ao buscar info:", error); }
    };

    const carregarClientes = async () => {
        if (!tabelaClientes) return; 
        try {
            // CORREÇÃO FINAL: Chamando o 'painel_api.php'
            const response = await fetch('/painel_api.php?action=listar_clientes');
            if (!response.ok) { throw new Error(`Erro de rede ou servidor: ${response.status}`); }
            const result = await response.json();
            tabelaClientes.innerHTML = '';

            if (result.status === 'success' && result.data.length > 0) {
                result.data.forEach(cliente => {
                    let dataFormatada = 'Não definido';
                    let statusBadge = '';

                    if (cliente.Vencimento) {
                        const dataVenc = new Date(cliente.Vencimento.replace(' ', 'T'));
                        dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                    }
                    if (cliente.status === 'Ativo') {
                        statusBadge = `<span class="badge bg-success">Ativo</span>`;
                    } else if (cliente.status === 'Vencido') {
                        statusBadge = `<span class="badge bg-danger">Vencido</span>`;
                    } else {
                        statusBadge = `<span class="badge bg-secondary">Inválido</span>`;
                    }

                    tabelaClientes.innerHTML += `<tr class="cliente-row">
                        <td class="cliente-nome">${cliente.name}</td>
                        <td class="cliente-usuario">${cliente.usuario}</td>
                        <td class="cliente-vencimento">${dataFormatada}</td>
                        <td>${statusBadge}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-success btn-renovar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Renovar"><i class="bi bi-calendar-plus-fill"></i></button>
                            <button class="btn btn-sm btn-outline-info btn-ver" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Ver Info"><i class="bi bi-eye-fill"></i></button>
                            <button class="btn btn-sm btn-outline-warning btn-editar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Editar"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger btn-excluir" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Excluir"><i class="bi bi-trash-fill"></i></button>
                        </td>
                    </tr>`;
                });
            } else {
                tabelaClientes.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum cliente encontrado.</td></tr>';
            }
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
        } catch (error) {
            console.error("ERRO ao carregar clientes:", error);
            tabelaClientes.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Falha ao carregar a lista. Detalhe: ${error.message}</td></tr>`;
        }
    };

    // --- EVENT LISTENERS (AGORA SÃO SEGUROS E CORRIGIDOS) ---
    
    if (formAdicionar && adicionarClienteModal) {
        formAdicionar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-adicionar').value, usuario: document.getElementById('usuario-adicionar').value, senha: document.getElementById('senha-adicionar').value, vencimento: document.getElementById('vencimento-adicionar').value };
            const response = await fetch('/painel_api.php?action=criar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                adicionarClienteModal.hide();
                await carregarClientes();
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formCriarTeste && criarTesteModal) {
        formCriarTeste.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-teste').value, usuario: document.getElementById('usuario-teste').value, senha: document.getElementById('senha-teste').value, duracao_horas: opcoesDuracao.querySelector('.btn.active').dataset.horas };
            const response = await fetch('/painel_api.php?action=criar_teste', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                criarTesteModal.hide();
                alert("Teste criado com sucesso!");
                // Se a página atual for a de testes, recarrega a lista de testes
                if (window.location.href.includes('gerenciar_testes')) {
                    // Assumindo que a função se chame carregarTestes()
                    if (typeof carregarTestes !== 'undefined') {
                        await carregarTestes();
                    }
                }
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formEditar && editarClienteModal) {
        formEditar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { id: document.getElementById('clienteId-editar').value, name: document.getElementById('nome-editar').value, usuario: document.getElementById('usuario-editar').value, senha: document.getElementById('senha-editar').value, vencimento: document.getElementById('vencimento-editar').value };
            const response = await fetch('/painel_api.php?action=atualizar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                editarClienteModal.hide();
                await carregarClientes();
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formRenovar && renovarModal) {
        formRenovar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const id = document.getElementById('renovarClienteId').value;
            const meses = document.getElementById('meses-renovacao').value;
            const response = await fetch('/painel_api.php?action=renovar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id, meses }) });
            const result = await response.json();
            if (result.status === 'success') {
                renovarModal.hide();
                await carregarClientes();
                const { usuario, senha, Vencimento } = result.data;
                const dataVenc = new Date(Vencimento.replace(' ', 'T'));
                const dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                mensagemRenovacaoTexto.textContent = `Plano renovado com sucesso!\n\n👤 Usuário: ${usuario}\n🔑 Senha: ${senha}\n📅 Próximo vencimento: ${dataFormatada}`;
                if(mensagemRenovacaoModal) mensagemRenovacaoModal.show();
            } else { alert(`Erro ao renovar: ${result.message}`); }
        });
    }
    
    if (tabelaClientes) {
        tabelaClientes.addEventListener('click', async (e) => {
            const target = e.target.closest('button');
            if (!target) return;
            const id = target.dataset.id;

            if (target.classList.contains('btn-ver')) {
                exibirModalInfo(id);
            } else if (target.classList.contains('btn-editar')) {
                try {
                    const response = await fetch(`/painel_api.php?action=buscar_cliente&id=${id}`);
                    if (!response.ok) { throw new Error(`Erro de rede: ${response.statusText}`); }
                    const result = await response.json();
                    
                    if (result.status === 'success' && result.data) {
                        const c = result.data;
                        document.getElementById('clienteId-editar').value = c.id;
                        document.getElementById('nome-editar').value = c.name;
                        document.getElementById('usuario-editar').value = c.usuario;
                        document.getElementById('senha-editar').value = c.senha;
                        if (c.Vencimento) {
                            document.getElementById('vencimento-editar').value = c.Vencimento.split(' ')[0];
                        }
                        if(editarClienteModal) editarClienteModal.show();
                    } else {
                        alert(`Erro ao buscar dados: ${result.message || 'Formato de resposta inválido.'}`);
                    }
                } catch (error) {
                    console.error('Falha na operação de edição:', error);
                    alert('Não foi possível carregar os dados para edição. Verifique o console (F12) para mais detalhes.');
                }
            } else if (target.classList.contains('btn-excluir')) {
                if (confirm('Tem certeza que deseja excluir este cliente?')) {
                    const response = await fetch('/painel_api.php?action=excluir_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id }) });
                    const result = await response.json();
                    alert(result.message);
                    if (result.status === 'success') { carregarClientes(); }
                }
            } else if (target.classList.contains('btn-renovar')) {
                document.getElementById('renovarClienteId').value = id;
                document.getElementById('meses-renovacao').value = 1;
                if(renovarModal) renovarModal.show();
            }
        });
    }

    const setupInfoActions = (btnCopy, btnWpp, textSource) => {
        if (!btnCopy || !btnWpp || !textSource) return;
        btnCopy.addEventListener('click', () => { navigator.clipboard.writeText(textSource.textContent).then(() => { const o = btnCopy.innerHTML; btnCopy.innerHTML = '<i class="bi bi-check-lg"></i> Copiado!'; setTimeout(() => { btnCopy.innerHTML = o; }, 2000); }); });
        btnWpp.addEventListener('click', () => { window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(textSource.textContent)}`, '_blank'); });
    };
    if(btnCopiarInfo) setupInfoActions(btnCopiarInfo, btnWhatsapp, infoClienteTexto);
    if(btnCopiarRenovacao) setupInfoActions(btnCopiarRenovacao, btnWhatsappRenovacao, mensagemRenovacaoTexto);
    
    if (campoBusca) {
        campoBusca.addEventListener('keyup', () => {
            const termo = campoBusca.value.toLowerCase();
            tabelaClientes.querySelectorAll('tr.cliente-row').forEach(linha => {
                const nome = linha.querySelector('.cliente-nome').textContent.toLowerCase();
                const usuario = linha.querySelector('.cliente-usuario').textContent.toLowerCase();
                linha.style.display = (nome.includes(termo) || usuario.includes(termo)) ? '' : 'none';
            });
        });
    }

    // --- CARGA INICIAL ---
    // A função a ser chamada depende da página. Podemos verificar a URL.
    if (window.location.href.includes('gerenciar_clientes') || window.location.href.endsWith('/')) {
        carregarClientes();
    }
    // Adicione um 'else if' para carregar testes se estiver na página de testes
});document.addEventListener('DOMContentLoaded', () => {
    // --- LÓGICA DO TEMA ---
    const themeToggle = document.getElementById('theme-toggle');
    if (themeToggle) {
        const themeToggleIcon = themeToggle.querySelector('i');
        const applyTheme = (theme) => {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            themeToggleIcon.className = theme === 'dark' ? 'bi bi-sun-fill' : 'bi bi-moon-stars-fill';
        };
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) { applyTheme(currentTheme); }
        else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) { applyTheme('dark'); }
        const tooltip = new bootstrap.Tooltip(themeToggle);
        themeToggle.addEventListener('click', () => {
            const newTheme = document.documentElement.getAttribute('data-theme') === 'dark' ? 'light' : 'dark';
            applyTheme(newTheme);
        });
    }

    // --- INICIALIZAÇÃO DE ELEMENTOS (sempre verificar se existem) ---
    const tabelaClientes = document.getElementById('tabela-clientes');
    const campoBusca = document.getElementById('campo-busca');
    const formAdicionar = document.getElementById('form-adicionar-cliente');
    const adicionarClienteModal = document.getElementById('adicionarClienteModal') ? new bootstrap.Modal(document.getElementById('adicionarClienteModal')) : null;
    const formEditar = document.getElementById('form-editar-cliente');
    const editarClienteModal = document.getElementById('editarClienteModal') ? new bootstrap.Modal(document.getElementById('editarClienteModal')) : null;
    const formCriarTeste = document.getElementById('form-criar-teste');
    const criarTesteModal = document.getElementById('criarTesteModal') ? new bootstrap.Modal(document.getElementById('criarTesteModal')) : null;
    const infoClienteModal = document.getElementById('infoClienteModal') ? new bootstrap.Modal(document.getElementById('infoClienteModal')) : null;
    const infoClienteTexto = document.getElementById('info-cliente-texto');
    const btnCopiarInfo = document.getElementById('btn-copiar-info');
    const btnWhatsapp = document.getElementById('btn-whatsapp');
    const formRenovar = document.getElementById('form-renovar');
    const renovarModal = document.getElementById('renovarModal') ? new bootstrap.Modal(document.getElementById('renovarModal')) : null;
    const mensagemRenovacaoModal = document.getElementById('mensagemRenovacaoModal') ? new bootstrap.Modal(document.getElementById('mensagemRenovacaoModal')) : null;
    const mensagemRenovacaoTexto = document.getElementById('mensagem-renovacao-texto');
    const btnCopiarRenovacao = document.getElementById('btn-copiar-renovacao');
    const btnWhatsappRenovacao = document.getElementById('btn-whatsapp-renovacao');
    const opcoesDuracao = document.getElementById('opcoes-duracao');

    // --- FUNÇÕES GERAIS ---
    const exibirModalInfo = async (id) => {
        try {
            const response = await fetch(`/painel_api.php?action=gerar_mensagem&id=${id}`);
            const result = await response.json();
            if (result.status === 'success') {
                if(infoClienteTexto) infoClienteTexto.textContent = result.data.mensagem;
                if(infoClienteModal) infoClienteModal.show();
            } else { alert(`Erro: ${result.message}`); }
        } catch (error) { console.error("Erro ao buscar info:", error); }
    };

    const carregarClientes = async () => {
        if (!tabelaClientes) return; 
        try {
            // CORREÇÃO FINAL: Chamando o 'painel_api.php'
            const response = await fetch('/painel_api.php?action=listar_clientes');
            if (!response.ok) { throw new Error(`Erro de rede ou servidor: ${response.status}`); }
            const result = await response.json();
            tabelaClientes.innerHTML = '';

            if (result.status === 'success' && result.data.length > 0) {
                result.data.forEach(cliente => {
                    let dataFormatada = 'Não definido';
                    let statusBadge = '';

                    if (cliente.Vencimento) {
                        const dataVenc = new Date(cliente.Vencimento.replace(' ', 'T'));
                        dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                    }
                    if (cliente.status === 'Ativo') {
                        statusBadge = `<span class="badge bg-success">Ativo</span>`;
                    } else if (cliente.status === 'Vencido') {
                        statusBadge = `<span class="badge bg-danger">Vencido</span>`;
                    } else {
                        statusBadge = `<span class="badge bg-secondary">Inválido</span>`;
                    }

                    tabelaClientes.innerHTML += `<tr class="cliente-row">
                        <td class="cliente-nome">${cliente.name}</td>
                        <td class="cliente-usuario">${cliente.usuario}</td>
                        <td class="cliente-vencimento">${dataFormatada}</td>
                        <td>${statusBadge}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-success btn-renovar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Renovar"><i class="bi bi-calendar-plus-fill"></i></button>
                            <button class="btn btn-sm btn-outline-info btn-ver" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Ver Info"><i class="bi bi-eye-fill"></i></button>
                            <button class="btn btn-sm btn-outline-warning btn-editar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Editar"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger btn-excluir" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Excluir"><i class="bi bi-trash-fill"></i></button>
                        </td>
                    </tr>`;
                });
            } else {
                tabelaClientes.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum cliente encontrado.</td></tr>';
            }
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
        } catch (error) {
            console.error("ERRO ao carregar clientes:", error);
            tabelaClientes.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Falha ao carregar a lista. Detalhe: ${error.message}</td></tr>`;
        }
    };

    // --- EVENT LISTENERS (AGORA SÃO SEGUROS E CORRIGIDOS) ---
    
    if (formAdicionar && adicionarClienteModal) {
        formAdicionar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-adicionar').value, usuario: document.getElementById('usuario-adicionar').value, senha: document.getElementById('senha-adicionar').value, vencimento: document.getElementById('vencimento-adicionar').value };
            const response = await fetch('/painel_api.php?action=criar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                adicionarClienteModal.hide();
                await carregarClientes();
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formCriarTeste && criarTesteModal) {
        formCriarTeste.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-teste').value, usuario: document.getElementById('usuario-teste').value, senha: document.getElementById('senha-teste').value, duracao_horas: opcoesDuracao.querySelector('.btn.active').dataset.horas };
            const response = await fetch('/painel_api.php?action=criar_teste', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                criarTesteModal.hide();
                alert("Teste criado com sucesso!");
                // Se a página atual for a de testes, recarrega a lista de testes
                if (window.location.href.includes('gerenciar_testes')) {
                    // Assumindo que a função se chame carregarTestes()
                    if (typeof carregarTestes !== 'undefined') {
                        await carregarTestes();
                    }
                }
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formEditar && editarClienteModal) {
        formEditar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { id: document.getElementById('clienteId-editar').value, name: document.getElementById('nome-editar').value, usuario: document.getElementById('usuario-editar').value, senha: document.getElementById('senha-editar').value, vencimento: document.getElementById('vencimento-editar').value };
            const response = await fetch('/painel_api.php?action=atualizar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                editarClienteModal.hide();
                await carregarClientes();
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formRenovar && renovarModal) {
        formRenovar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const id = document.getElementById('renovarClienteId').value;
            const meses = document.getElementById('meses-renovacao').value;
            const response = await fetch('/painel_api.php?action=renovar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id, meses }) });
            const result = await response.json();
            if (result.status === 'success') {
                renovarModal.hide();
                await carregarClientes();
                const { usuario, senha, Vencimento } = result.data;
                const dataVenc = new Date(Vencimento.replace(' ', 'T'));
                const dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                mensagemRenovacaoTexto.textContent = `Plano renovado com sucesso!\n\n👤 Usuário: ${usuario}\n🔑 Senha: ${senha}\n📅 Próximo vencimento: ${dataFormatada}`;
                if(mensagemRenovacaoModal) mensagemRenovacaoModal.show();
            } else { alert(`Erro ao renovar: ${result.message}`); }
        });
    }
    
    if (tabelaClientes) {
        tabelaClientes.addEventListener('click', async (e) => {
            const target = e.target.closest('button');
            if (!target) return;
            const id = target.dataset.id;

            if (target.classList.contains('btn-ver')) {
                exibirModalInfo(id);
            } else if (target.classList.contains('btn-editar')) {
                try {
                    const response = await fetch(`/painel_api.php?action=buscar_cliente&id=${id}`);
                    if (!response.ok) { throw new Error(`Erro de rede: ${response.statusText}`); }
                    const result = await response.json();
                    
                    if (result.status === 'success' && result.data) {
                        const c = result.data;
                        document.getElementById('clienteId-editar').value = c.id;
                        document.getElementById('nome-editar').value = c.name;
                        document.getElementById('usuario-editar').value = c.usuario;
                        document.getElementById('senha-editar').value = c.senha;
                        if (c.Vencimento) {
                            document.getElementById('vencimento-editar').value = c.Vencimento.split(' ')[0];
                        }
                        if(editarClienteModal) editarClienteModal.show();
                    } else {
                        alert(`Erro ao buscar dados: ${result.message || 'Formato de resposta inválido.'}`);
                    }
                } catch (error) {
                    console.error('Falha na operação de edição:', error);
                    alert('Não foi possível carregar os dados para edição. Verifique o console (F12) para mais detalhes.');
                }
            } else if (target.classList.contains('btn-excluir')) {
                if (confirm('Tem certeza que deseja excluir este cliente?')) {
                    const response = await fetch('/painel_api.php?action=excluir_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id }) });
                    const result = await response.json();
                    alert(result.message);
                    if (result.status === 'success') { carregarClientes(); }
                }
            } else if (target.classList.contains('btn-renovar')) {
                document.getElementById('renovarClienteId').value = id;
                document.getElementById('meses-renovacao').value = 1;
                if(renovarModal) renovarModal.show();
            }
        });
    }

    const setupInfoActions = (btnCopy, btnWpp, textSource) => {
        if (!btnCopy || !btnWpp || !textSource) return;
        btnCopy.addEventListener('click', () => { navigator.clipboard.writeText(textSource.textContent).then(() => { const o = btnCopy.innerHTML; btnCopy.innerHTML = '<i class="bi bi-check-lg"></i> Copiado!'; setTimeout(() => { btnCopy.innerHTML = o; }, 2000); }); });
        btnWpp.addEventListener('click', () => { window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(textSource.textContent)}`, '_blank'); });
    };
    if(btnCopiarInfo) setupInfoActions(btnCopiarInfo, btnWhatsapp, infoClienteTexto);
    if(btnCopiarRenovacao) setupInfoActions(btnCopiarRenovacao, btnWhatsappRenovacao, mensagemRenovacaoTexto);
    
    if (campoBusca) {
        campoBusca.addEventListener('keyup', () => {
            const termo = campoBusca.value.toLowerCase();
            tabelaClientes.querySelectorAll('tr.cliente-row').forEach(linha => {
                const nome = linha.querySelector('.cliente-nome').textContent.toLowerCase();
                const usuario = linha.querySelector('.cliente-usuario').textContent.toLowerCase();
                linha.style.display = (nome.includes(termo) || usuario.includes(termo)) ? '' : 'none';
            });
        });
    }

    // --- CARGA INICIAL ---
    // A função a ser chamada depende da página. Podemos verificar a URL.
    if (window.location.href.includes('gerenciar_clientes') || window.location.href.endsWith('/')) {
        carregarClientes();
    }
    // Adicione um 'else if' para carregar testes se estiver na página de testes
});document.addEventListener('DOMContentLoaded', () => {
    // --- LÓGICA DO TEMA ---
    const themeToggle = document.getElementById('theme-toggle');
    if (themeToggle) {
        const themeToggleIcon = themeToggle.querySelector('i');
        const applyTheme = (theme) => {
            document.documentElement.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            themeToggleIcon.className = theme === 'dark' ? 'bi bi-sun-fill' : 'bi bi-moon-stars-fill';
        };
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme) { applyTheme(currentTheme); }
        else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) { applyTheme('dark'); }
        const tooltip = new bootstrap.Tooltip(themeToggle);
        themeToggle.addEventListener('click', () => {
            const newTheme = document.documentElement.getAttribute('data-theme') === 'dark' ? 'light' : 'dark';
            applyTheme(newTheme);
        });
    }

    // --- INICIALIZAÇÃO DE ELEMENTOS (sempre verificar se existem) ---
    const tabelaClientes = document.getElementById('tabela-clientes');
    const campoBusca = document.getElementById('campo-busca');
    const formAdicionar = document.getElementById('form-adicionar-cliente');
    const adicionarClienteModal = document.getElementById('adicionarClienteModal') ? new bootstrap.Modal(document.getElementById('adicionarClienteModal')) : null;
    const formEditar = document.getElementById('form-editar-cliente');
    const editarClienteModal = document.getElementById('editarClienteModal') ? new bootstrap.Modal(document.getElementById('editarClienteModal')) : null;
    const formCriarTeste = document.getElementById('form-criar-teste');
    const criarTesteModal = document.getElementById('criarTesteModal') ? new bootstrap.Modal(document.getElementById('criarTesteModal')) : null;
    const infoClienteModal = document.getElementById('infoClienteModal') ? new bootstrap.Modal(document.getElementById('infoClienteModal')) : null;
    const infoClienteTexto = document.getElementById('info-cliente-texto');
    const btnCopiarInfo = document.getElementById('btn-copiar-info');
    const btnWhatsapp = document.getElementById('btn-whatsapp');
    const formRenovar = document.getElementById('form-renovar');
    const renovarModal = document.getElementById('renovarModal') ? new bootstrap.Modal(document.getElementById('renovarModal')) : null;
    const mensagemRenovacaoModal = document.getElementById('mensagemRenovacaoModal') ? new bootstrap.Modal(document.getElementById('mensagemRenovacaoModal')) : null;
    const mensagemRenovacaoTexto = document.getElementById('mensagem-renovacao-texto');
    const btnCopiarRenovacao = document.getElementById('btn-copiar-renovacao');
    const btnWhatsappRenovacao = document.getElementById('btn-whatsapp-renovacao');
    const opcoesDuracao = document.getElementById('opcoes-duracao');

    // --- FUNÇÕES GERAIS ---
    const exibirModalInfo = async (id) => {
        try {
            const response = await fetch(`/painel_api.php?action=gerar_mensagem&id=${id}`);
            const result = await response.json();
            if (result.status === 'success') {
                if(infoClienteTexto) infoClienteTexto.textContent = result.data.mensagem;
                if(infoClienteModal) infoClienteModal.show();
            } else { alert(`Erro: ${result.message}`); }
        } catch (error) { console.error("Erro ao buscar info:", error); }
    };

    const carregarClientes = async () => {
        if (!tabelaClientes) return; 
        try {
            // CORREÇÃO FINAL: Chamando o 'painel_api.php'
            const response = await fetch('/painel_api.php?action=listar_clientes');
            if (!response.ok) { throw new Error(`Erro de rede ou servidor: ${response.status}`); }
            const result = await response.json();
            tabelaClientes.innerHTML = '';

            if (result.status === 'success' && result.data.length > 0) {
                result.data.forEach(cliente => {
                    let dataFormatada = 'Não definido';
                    let statusBadge = '';

                    if (cliente.Vencimento) {
                        const dataVenc = new Date(cliente.Vencimento.replace(' ', 'T'));
                        dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                    }
                    if (cliente.status === 'Ativo') {
                        statusBadge = `<span class="badge bg-success">Ativo</span>`;
                    } else if (cliente.status === 'Vencido') {
                        statusBadge = `<span class="badge bg-danger">Vencido</span>`;
                    } else {
                        statusBadge = `<span class="badge bg-secondary">Inválido</span>`;
                    }

                    tabelaClientes.innerHTML += `<tr class="cliente-row">
                        <td class="cliente-nome">${cliente.name}</td>
                        <td class="cliente-usuario">${cliente.usuario}</td>
                        <td class="cliente-vencimento">${dataFormatada}</td>
                        <td>${statusBadge}</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-outline-success btn-renovar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Renovar"><i class="bi bi-calendar-plus-fill"></i></button>
                            <button class="btn btn-sm btn-outline-info btn-ver" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Ver Info"><i class="bi bi-eye-fill"></i></button>
                            <button class="btn btn-sm btn-outline-warning btn-editar" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Editar"><i class="bi bi-pencil-square"></i></button>
                            <button class="btn btn-sm btn-outline-danger btn-excluir" data-id="${cliente.id}" data-bs-toggle="tooltip" title="Excluir"><i class="bi bi-trash-fill"></i></button>
                        </td>
                    </tr>`;
                });
            } else {
                tabelaClientes.innerHTML = '<tr><td colspan="5" class="text-center">Nenhum cliente encontrado.</td></tr>';
            }
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
        } catch (error) {
            console.error("ERRO ao carregar clientes:", error);
            tabelaClientes.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Falha ao carregar a lista. Detalhe: ${error.message}</td></tr>`;
        }
    };

    // --- EVENT LISTENERS (AGORA SÃO SEGUROS E CORRIGIDOS) ---
    
    if (formAdicionar && adicionarClienteModal) {
        formAdicionar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-adicionar').value, usuario: document.getElementById('usuario-adicionar').value, senha: document.getElementById('senha-adicionar').value, vencimento: document.getElementById('vencimento-adicionar').value };
            const response = await fetch('/painel_api.php?action=criar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                adicionarClienteModal.hide();
                await carregarClientes();
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formCriarTeste && criarTesteModal) {
        formCriarTeste.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { nome: document.getElementById('nome-teste').value, usuario: document.getElementById('usuario-teste').value, senha: document.getElementById('senha-teste').value, duracao_horas: opcoesDuracao.querySelector('.btn.active').dataset.horas };
            const response = await fetch('/painel_api.php?action=criar_teste', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                criarTesteModal.hide();
                alert("Teste criado com sucesso!");
                // Se a página atual for a de testes, recarrega a lista de testes
                if (window.location.href.includes('gerenciar_testes')) {
                    // Assumindo que a função se chame carregarTestes()
                    if (typeof carregarTestes !== 'undefined') {
                        await carregarTestes();
                    }
                }
                if (result.novoId) { exibirModalInfo(result.novoId); }
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formEditar && editarClienteModal) {
        formEditar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const dados = { id: document.getElementById('clienteId-editar').value, name: document.getElementById('nome-editar').value, usuario: document.getElementById('usuario-editar').value, senha: document.getElementById('senha-editar').value, vencimento: document.getElementById('vencimento-editar').value };
            const response = await fetch('/painel_api.php?action=atualizar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(dados) });
            const result = await response.json();
            if (result.status === 'success') {
                alert(result.message);
                editarClienteModal.hide();
                await carregarClientes();
            } else { alert(`Erro: ${result.message}`); }
        });
    }

    if (formRenovar && renovarModal) {
        formRenovar.addEventListener('submit', async (e) => {
            e.preventDefault();
            const id = document.getElementById('renovarClienteId').value;
            const meses = document.getElementById('meses-renovacao').value;
            const response = await fetch('/painel_api.php?action=renovar_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id, meses }) });
            const result = await response.json();
            if (result.status === 'success') {
                renovarModal.hide();
                await carregarClientes();
                const { usuario, senha, Vencimento } = result.data;
                const dataVenc = new Date(Vencimento.replace(' ', 'T'));
                const dataFormatada = dataVenc.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                mensagemRenovacaoTexto.textContent = `Plano renovado com sucesso!\n\n👤 Usuário: ${usuario}\n🔑 Senha: ${senha}\n📅 Próximo vencimento: ${dataFormatada}`;
                if(mensagemRenovacaoModal) mensagemRenovacaoModal.show();
            } else { alert(`Erro ao renovar: ${result.message}`); }
        });
    }
    
    if (tabelaClientes) {
        tabelaClientes.addEventListener('click', async (e) => {
            const target = e.target.closest('button');
            if (!target) return;
            const id = target.dataset.id;

            if (target.classList.contains('btn-ver')) {
                exibirModalInfo(id);
            } else if (target.classList.contains('btn-editar')) {
                try {
                    const response = await fetch(`/painel_api.php?action=buscar_cliente&id=${id}`);
                    if (!response.ok) { throw new Error(`Erro de rede: ${response.statusText}`); }
                    const result = await response.json();
                    
                    if (result.status === 'success' && result.data) {
                        const c = result.data;
                        document.getElementById('clienteId-editar').value = c.id;
                        document.getElementById('nome-editar').value = c.name;
                        document.getElementById('usuario-editar').value = c.usuario;
                        document.getElementById('senha-editar').value = c.senha;
                        if (c.Vencimento) {
                            document.getElementById('vencimento-editar').value = c.Vencimento.split(' ')[0];
                        }
                        if(editarClienteModal) editarClienteModal.show();
                    } else {
                        alert(`Erro ao buscar dados: ${result.message || 'Formato de resposta inválido.'}`);
                    }
                } catch (error) {
                    console.error('Falha na operação de edição:', error);
                    alert('Não foi possível carregar os dados para edição. Verifique o console (F12) para mais detalhes.');
                }
            } else if (target.classList.contains('btn-excluir')) {
                if (confirm('Tem certeza que deseja excluir este cliente?')) {
                    const response = await fetch('/painel_api.php?action=excluir_cliente', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ id }) });
                    const result = await response.json();
                    alert(result.message);
                    if (result.status === 'success') { carregarClientes(); }
                }
            } else if (target.classList.contains('btn-renovar')) {
                document.getElementById('renovarClienteId').value = id;
                document.getElementById('meses-renovacao').value = 1;
                if(renovarModal) renovarModal.show();
            }
        });
    }

    const setupInfoActions = (btnCopy, btnWpp, textSource) => {
        if (!btnCopy || !btnWpp || !textSource) return;
        btnCopy.addEventListener('click', () => { navigator.clipboard.writeText(textSource.textContent).then(() => { const o = btnCopy.innerHTML; btnCopy.innerHTML = '<i class="bi bi-check-lg"></i> Copiado!'; setTimeout(() => { btnCopy.innerHTML = o; }, 2000); }); });
        btnWpp.addEventListener('click', () => { window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(textSource.textContent)}`, '_blank'); });
    };
    if(btnCopiarInfo) setupInfoActions(btnCopiarInfo, btnWhatsapp, infoClienteTexto);
    if(btnCopiarRenovacao) setupInfoActions(btnCopiarRenovacao, btnWhatsappRenovacao, mensagemRenovacaoTexto);
    
    if (campoBusca) {
        campoBusca.addEventListener('keyup', () => {
            const termo = campoBusca.value.toLowerCase();
            tabelaClientes.querySelectorAll('tr.cliente-row').forEach(linha => {
                const nome = linha.querySelector('.cliente-nome').textContent.toLowerCase();
                const usuario = linha.querySelector('.cliente-usuario').textContent.toLowerCase();
                linha.style.display = (nome.includes(termo) || usuario.includes(termo)) ? '' : 'none';
            });
        });
    }

    // --- CARGA INICIAL ---
    // A função a ser chamada depende da página. Podemos verificar a URL.
    if (window.location.href.includes('gerenciar_clientes') || window.location.href.endsWith('/')) {
        carregarClientes();
    }
    // Adicione um 'else if' para carregar testes se estiver na página de testes
});