<?php
// Inclui o cabeçalho e menu do seu painel principal
require_once 'menu.php';

// --- LÓGICA PHP ATUALIZADA (COM CONTAGEM DE BLOQUEADOS) ---
require_once './api/controles/db.php'; 

$clientes_p2p = [];
$template_p2p_atual = '';
$cont_p2p_ativos = 0;
$cont_p2p_vencidos = 0;
$cont_p2p_bloqueados = 0; // Nova variável

$conexao = conectar_bd();
if ($conexao) {
    try {
        $stmt_template = $conexao->prepare("SELECT valor FROM configuracoes WHERE chave = 'p2p_message_template' LIMIT 1");
        $stmt_template->execute();
        $template_p2p_atual = $stmt_template->fetchColumn();

        // ==================================================
        // ### LÓGICA DE CONTAGEM (COM BLOQUEADOS) ###
        // ==================================================
        
        $agora_php = date("Y-m-d H:i:s");
        $sql_base_p2p = " FROM clientes WHERE is_p2p = 1 AND plano <> 'Teste P2P'";
        $params_contagem = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql_base_p2p .= " AND admin_id = :admin_id";
            $params_contagem[':admin_id'] = $_SESSION['admin_id'];
        }

        // 1. Contar P2P ATIVOS
        $sql_ativos = "SELECT COUNT(*) " . $sql_base_p2p . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora";
        $stmt_ativos = $conexao->prepare($sql_ativos);
        $stmt_ativos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_p2p_ativos = $stmt_ativos->fetchColumn();

        // 2. Contar P2P VENCIDOS
        $sql_vencidos = "SELECT COUNT(*) " . $sql_base_p2p . " AND (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora";
        $stmt_vencidos = $conexao->prepare($sql_vencidos);
        $stmt_vencidos->execute(array_merge($params_contagem, [':agora' => $agora_php]));
        $cont_p2p_vencidos = $stmt_vencidos->fetchColumn();
        
        // 3. Contar P2P BLOQUEADOS (NOVO)
        $sql_bloqueados = "SELECT COUNT(*) " . $sql_base_p2p . " AND is_banned = 1";
        $stmt_bloqueados = $conexao->prepare($sql_bloqueados);
        $stmt_bloqueados->execute($params_contagem);
        $cont_p2p_bloqueados = $stmt_bloqueados->fetchColumn();
        
        // ==================================================
        // ### LÓGICA DA TABELA (COM 'is_banned' ADICIONADO) ###
        // ==================================================
        
        $sql = "SELECT id, usuario, name, whatsapp, Vencimento, is_banned FROM clientes WHERE is_p2p = 1 AND plano <> 'Teste P2P'";
        $params = [];

        if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 0) {
            $sql .= " AND admin_id = :admin_id";
            $params[':admin_id'] = $_SESSION['admin_id'];
        }
        
        $sql .= " ORDER BY id DESC";

        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);
        $clientes_p2p = $stmt->fetchAll(PDO::FETCH_ASSOC);

    } catch(PDOException $e) {
        error_log("Erro na página P2P: " . $e->getMessage());
    }
}
?>

<style>
    /* Estilos do Tema Claro/Escuro (do seu ficheiro original) */
    .card { color: #212529; }
    .table { color: #212529; background-color: #fff; }
    .table-striped > tbody > tr:nth-of-type(odd) > * { --bs-table-accent-bg: rgba(0, 0, 0, 0.05); }
    .table-hover > tbody > tr:hover > * { --bs-table-accent-bg: rgba(0, 0, 0, 0.075); }
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .table,
    [data-theme="dark"] .table th,
    [data-theme="dark"] .table td {
        background-color: transparent !important; 
        color: #e4e6eb !important;
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .table-striped > tbody > tr:nth-of-type(odd) > * {
        --bs-table-accent-bg: rgba(255, 255, 255, 0.05) !important; 
        color: #e4e6eb !important;
    }
    [data-theme="dark"] .table-hover > tbody > tr:hover > * {
        --bs-table-accent-bg: rgba(255, 255, 255, 0.1) !important; 
        color: #e4e6eb !important;
    }
    [data-theme="dark"] .table > thead.bg-primary {
         background-color: #0d6efd !important; 
         color: #fff !important; 
    }
    
    /* CSS DOS CARDS PROFISSIONAIS (do Dashboard) */
    .stat-card {
        border: none;
        border-left-width: 5px;
        border-left-style: solid;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        border-radius: 8px; 
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
    }
    .stat-card .card-body {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem; 
    }
    .stat-info .stat-label {
        font-size: 0.9rem;
        color: #adb5bd; 
        text-transform: uppercase;
        font-weight: 700;
    }
    .stat-info .stat-value {
        font-size: 2.25rem;
        font-weight: 700;
        margin: 0;
        color: var(--bs-heading-color); 
    }
    .stat-icon {
        font-size: 3.5rem;
        opacity: 0.15;
    }
    
    /* Cores (Azul, Amarelo, Vermelho) */
    .stat-card.card-p2p-ativos { border-color: #0d6efd; } /* Azul */
    .stat-card.card-p2p-ativos .stat-label,
    .stat-card.card-p2p-ativos .stat-icon { color: #0d6efd; }

    .stat-card.card-p2p-vencidos { border-color: #ffc107; } /* Amarelo */
    .stat-card.card-p2p-vencidos .stat-label,
    .stat-card.card-p2p-vencidos .stat-icon { color: #ffc107; }

    .stat-card.card-p2p-bloqueados { border-color: #dc3545; } /* Vermelho */
    .stat-card.card-p2p-bloqueados .stat-label,
    .stat-card.card-p2p-bloqueados .stat-icon { color: #dc3545; }
    
    
    /* ================================================================== */
    /* ### NOVO CSS PARA OS EMBLEMAS DE STATUS (V20) ### */
    /* ================================================================== */
    .status-badge {
        padding: .3em .6em;
        border-radius: .375rem;
        font-size: 0.75em;
        font-weight: bold;
        text-transform: uppercase;
        display: inline-block;
        white-space: nowrap;
        line-height: 1;
        text-align: center;
    }
    /* Emblema Ativo (Verde) */
    .status-badge.status-ativo {
        background-color: #d4edda;
        color: #155724;
    }
    /* Emblema Expirado (Amarelo) */
    .status-badge.status-expirado {
        background-color: #fff3cd;
        color: #664d03;
    }
    /* Emblema Bloqueado (Vermelho) */
    .status-badge.status-bloqueado {
        background-color: #f8d7da;
        color: #721c24;
    }
    /* Cores dos emblemas no Tema Escuro */
    [data-theme="dark"] .status-badge.status-ativo {
        background-color: #198754; color: #fff;
    }
    [data-theme="dark"] .status-badge.status-expirado {
        background-color: #ffc107; color: #000;
    }
    [data-theme="dark"] .status-badge.status-bloqueado {
        background-color: #dc3545; color: #fff;
    }
        
</style>
<div class="container-fluid py-4">

    <div class="row mb-4">
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-ativos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Ativos</div>
                        <p class="stat-value"><?php echo $cont_p2p_ativos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-check"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-vencidos h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Vencidos</div>
                        <p class="stat-value"><?php echo $cont_p2p_vencidos; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-clock"></i></div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card stat-card card-p2p-bloqueados h-100">
                <div class="card-body">
                    <div class="stat-info">
                        <div class="stat-label">Clientes P2P Bloqueados</div>
                        <p class="stat-value"><?php echo $cont_p2p_bloqueados; ?></p>
                    </div>
                    <div class="stat-icon"><i class="fa-solid fa-user-lock"></i></div>
                </div>
            </div>
        </div>
    </div>
    <div class="card shadow-sm border-0 rounded-3 p-4">
        
        <h4 class="card-title text-primary d-flex justify-content-between align-items-center mb-4">
            <span class="fw-bold">Gerenciar Clientes P2P</span>
            <div>
                <a href="p2p_criar.php" class="btn btn-primary rounded-pill"><i class="fas fa-plus me-2"></i> Adicionar Cliente</a>
                <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
                <a href="p2p_config.php" class="btn btn-secondary rounded-pill"><i class="fas fa-cogs me-2"></i> Configurações</a>
                <?php endif; ?>
            </div>
        </h4>
        
        <?php if (isset($_SESSION['mensagem'])): ?>
            <div class="alert <?php echo strpos($_SESSION['msg_type'], 'success') !== false ? 'alert-success' : 'alert-danger'; ?> alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['mensagem']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php unset($_SESSION['mensagem']); unset($_SESSION['msg_type']); ?>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="display table table-striped table-hover border" style="width: 100%;">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>#</th>
                        <th>Nome / Descrição</th>
                        <th>Código (Usuário)</th>
                        <th>Vencimento</th>
                        <th>Status</th> <th class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($clientes_p2p)): ?>
                        <?php foreach ($clientes_p2p as $cliente): ?>
                            <?php
                                $is_banned = isset($cliente['is_banned']) ? $cliente['is_banned'] : 0;
                                $id = $cliente['id'];
                                $vencimento_time = strtotime($cliente['Vencimento']);
                            ?>
                            <tr>
                                <td><?php echo $id; ?></td>
                                <td><?php echo htmlspecialchars($cliente['name']); ?></td>
                                <td><?php echo htmlspecialchars($cliente['usuario']); ?></td>
                                <td><?php echo date('d/m/Y H:i', $vencimento_time); ?></td>
                                
                                <td>
                                    <?php
                                        if ($is_banned == 1) {
                                            echo '<span class="status-badge status-bloqueado">Bloqueado</span>';
                                        } elseif ($vencimento_time < time()) {
                                            echo '<span class="status-badge status-expirado">Expirado</span>';
                                        } else {
                                            echo '<span class="status-badge status-ativo">Ativo</span>';
                                        }
                                    ?>
                                </td>
                                <td class="text-end">
                                    
                                    <button class="btn btn-info btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Ver Informações"
                                        onclick="exibirModalP2P('Informações do Cliente', 
                                        `<?php 
                                            $venc_fmt = date('d/m/Y H:i', $vencimento_time);
                                            $mensagem_pronta = str_replace(
                                                ['#cliente#', '#codigo#', '#vencimento#'], 
                                                [htmlspecialchars($cliente['name']), $cliente['usuario'], $venc_fmt], 
                                                $template_p2p_atual
                                            );
                                            echo addslashes($mensagem_pronta); 
                                        ?>`, 
                                        '<?php echo $cliente['whatsapp']; ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <a href="p2p_renovar.php?id=<?php echo $id; ?>" class="btn btn-warning btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Renovar"><i class="fas fa-sync-alt"></i></a>
                                    
                                    <?php if ($is_banned == 1): ?>
                                        <button class="btn btn-outline-success btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Desbloquear"
                                            onclick="modalBloquearP2P('<?php echo $id; ?>', '<?php echo htmlspecialchars($cliente['usuario']); ?>', 1)">
                                            <i class="fas fa-unlock"></i>
                                        </button>
                                    <?php else: ?>
                                        <button class="btn btn-outline-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Bloquear"
                                            onclick="modalBloquearP2P('<?php echo $id; ?>', '<?php echo htmlspecialchars($cliente['usuario']); ?>', 0)">
                                            <i class="fas fa-lock"></i>
                                        </button>
                                    <?php endif; ?>

                                    <a href="action_p2p_excluir.php?id=<?php echo $id; ?>&from=codigos_p2p.php" class="btn btn-danger btn-sm rounded-circle" style="width: 32px; height: 32px; line-height: 1.5;" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este cliente?');"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Nenhum cliente P2P encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>

<script>
function exibirModalP2P(title, message, whatsappNumber) {
    const cleanMessage = message.replace(/\\'/g, "'").replace(/\\"/g, '"').replace(/\\`/g, '`');

    Swal.fire({
        title: title,
        html: `<pre style="white-space: pre-wrap; text-align: left; font-size: 0.9rem;">${cleanMessage}</pre>`,
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
        cancelButtonText: '<i class="fab fa-whatsapp"></i> WhatsApp',
        confirmButtonColor: '#0d6efd',
        cancelButtonColor: '#25D366',
        reverseButtons: true 
    }).then((result) => {
        if (result.isConfirmed) {
            navigator.clipboard.writeText(cleanMessage).then(() => {
                Swal.fire('Copiado!', 'A mensagem foi copiada para a área de transferência.', 'success');
            }).catch(err => {
                Swal.fire('Erro!', 'Não foi possível copiar a mensagem.', 'error');
            });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            if (whatsappNumber && whatsappNumber.trim() !== '') {
                const encodedMessage = encodeURIComponent(cleanMessage);
                const whatsappURL = `https://api.whatsapp.com/send?phone=${whatsappNumber}&text=${encodedMessage}`;
                window.open(whatsappURL, '_blank');
            } else {
                Swal.fire('Atenção!', 'O cliente não tem um número de WhatsApp cadastrado.', 'warning');
            }
        }
    });
}

/**
 * (V19) Função para o botão de bloquear/desbloquear.
 */
function modalBloquearP2P(clienteId, clienteUsuario, isBanned) {
    const acaoTexto = isBanned ? "DESBLOQUEAR" : "BLOQUEAR";
    const acaoIcon = isBanned ? "success" : "warning";
    const acaoBtn = isBanned ? "Sim, desbloquear!" : "Sim, bloquear!";
    const acaoBtnColor = isBanned ? '#198754' : '#dc3545';

    Swal.fire({
        title: acaoTexto + ' CLIENTE',
        html: `Tem certeza que deseja <strong>${acaoTexto}</strong> o cliente (<strong>${clienteUsuario}</strong>)?`,
        icon: acaoIcon,
        showCancelButton: true,
        confirmButtonText: acaoBtn,
        cancelButtonText: 'Cancelar',
        confirmButtonColor: acaoBtnColor,
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'A processar...',
                allowOutsideClick: false,
                didOpen: () => { Swal.showLoading(); }
            });

            // Chama a API de clientes (que já sabe como bloquear)
            $.ajax({
                url: '/api/clientes.php', // A API que já funciona
                type: 'POST',
                data: {
                    // Esta é a ação que o 'enviardados' chamaria
                    confirme_toggle_bloqueio_cliente: clienteId 
                },
                dataType: 'json',
                success: function(response) {
                    if (response && response.icon === 'success') {
                        Swal.fire(response.title, response.msg, 'success').then(() => {
                            // Recarrega a página para atualizar os cards e a tabela
                            location.reload(); 
                        });
                    } else {
                        Swal.fire(response.title || 'Erro!', response.msg || 'Não foi possível completar a ação.', 'error');
                    }
                },
                error: function(xhr) {
                    console.error("Erro AJAX:", xhr.responseText);
                    Swal.fire('Erro de Comunicação!', 'Não foi possível contactar a API.', 'error');
                }
            });
        }
    });
}


document.addEventListener('DOMContentLoaded', function() {
    <?php
    if (isset($_SESSION['show_p2p_modal_message'])) {
        echo "exibirModalP2P('" . addslashes($_SESSION['show_p2p_modal_title']) . "', `" . addslashes($_SESSION['show_p2p_modal_message']) . "`, '');";
        unset($_SESSION['show_p2p_modal_message']);
        unset($_SESSION['show_p2p_modal_title']);
    }
    ?>
});
</script>