<?php
// 1. Inclui o menu e cabeçalho
require_once 'menu.php';

// **Simulação de Leitura da Configuração do Banco de Dados**
// Em um ambiente real, você faria uma query aqui.
$cobrar_credito = 1; // 1 = Ativado (Padrão), 0 = Desativado
// $cobrar_credito = $db->get_setting('migracao_cobrar_credito');
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0"><i class="fa-solid fa-gear text-primary"></i> Configuração de Migração</h4>
            </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col-lg-8 col-md-10">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4"><i class="fa-solid fa-coins"></i> Política de Cobrança</h5>
                    
                    <div class="form-check form-switch form-switch-lg">
                        <input class="form-check-input" type="checkbox" id="toggle_cobrar_credito" 
                               <?= $cobrar_credito == 1 ? 'checked' : '' ?>>
                        <label class="form-check-label" for="toggle_cobrar_credito">
                            **Cobrar Crédito na Migração de Cliente**
                        </label>
                    </div>
                    
                    <p class="text-muted mt-2">
                        Se **ATIVADO**, um custo em créditos será descontado da sua conta ao importar um cliente.
                        Se **DESATIVADO**, a importação será gratuita, e o "Custo de Importação" será zerado.
                    </p>

                    <button id="btn_salvar_config" class="btn btn-primary mt-4">
                        <i class="fa-solid fa-save"></i> Salvar Configuração
                    </button>
                    <div id="status_msg" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// --- Lógica JavaScript para salvar a configuração ---
$(document).ready(function(){
    $('#btn_salvar_config').click(function(){
        const cobrar = $('#toggle_cobrar_credito').is(':checked') ? 1 : 0;
        const btn = $(this);
        const originalHtml = btn.html();
        
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Salvando...');

        // **Chamada AJAX para salvar no backend (Nova Action na API)**
        $.ajax({
            url: 'api/api_migracao.php', 
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'salvar_config',
                cobrar_credito: cobrar,
                token: (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '')
            },
            success: function(response){
                if(response.status === 'success'){
                    Swal.fire('Salvo!', 'A configuração foi atualizada com sucesso.', 'success');
                } else {
                    Swal.fire('Erro!', response.message || 'Não foi possível salvar a configuração.', 'error');
                }
            },
            error: function(){
                Swal.fire('Erro de Comunicação!', 'Verifique sua conexão.', 'error');
            },
            complete: function() {
                btn.prop('disabled', false).html(originalHtml);
            }
        });
    });
});
</script>

<?php
// 2. Inclui o rodapé
// require_once 'footer.php';
?>