<?php
// Inclua seu arquivo de conexão e verificação de login
require_once('api/controles/db.php');

// ===================================================================
// CORREÇÃO: O menu.php deve vir ANTES de qualquer HTML
// ===================================================================
require_once("menu.php"); 

$conn = conectar_bd();

// Se a conexão falhar, o script para.
if (!$conn) {
    die("Ocorreu um erro crítico e não foi possível conectar ao banco de dados. Verifique os logs do servidor.");
}

// --- CONSULTAS PARA OS CONTADORES (USANDO PDO) ---
$stmt_canais_total = $conn->query("SELECT COUNT(id) as total FROM streams WHERE stream_type = 'live'");
$total_canais = $stmt_canais_total->fetch(PDO::FETCH_ASSOC)['total'];

$stmt_filmes_total = $conn->query("SELECT COUNT(id) as total FROM streams WHERE stream_type = 'movie'");
$total_filmes = $stmt_filmes_total->fetch(PDO::FETCH_ASSOC)['total'];

$stmt_series_total = $conn->query("SELECT COUNT(id) as total FROM series");
$total_series = $stmt_series_total->fetch(PDO::FETCH_ASSOC)['total'];

// --- CONSULTAS PARA AS LISTAS DE NOVIDADES (USANDO PDO) ---

// [CORREÇÃO DATAS] Filtra datas inválidas (como 0000-00-00 ou 1970)
$data_minima = "'1971-01-01'"; // Ignora tudo de 1970 para trás

// Novos Canais
$novos_canais_stmt = $conn->query("SELECT name, added FROM streams 
                                   WHERE stream_type = 'live' AND added IS NOT NULL AND added > $data_minima 
                                   ORDER BY added DESC LIMIT 20");

// Novos Filmes
$novos_filmes_stmt = $conn->query("SELECT name, stream_icon, added FROM streams 
                                   WHERE stream_type = 'movie' AND added IS NOT NULL AND added > $data_minima 
                                   ORDER BY added DESC LIMIT 20");

// Novas Séries
$novas_series_stmt = $conn->query("SELECT name, cover, release_date FROM series 
                                   WHERE release_date IS NOT NULL AND release_date > $data_minima 
                                   ORDER BY release_date DESC LIMIT 20");

// Verificação de permissão
$isAdmin = isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1;

?>

<style>
    /* 1. Cores Padrão (Tema Claro) */
    .dashboard-container {
        padding: 20px;
        color: #212529; /* Texto escuro */
    }
    .counter-box {
        color: white; /* Texto dos contadores é sempre branco */
    }
    .content-list {
        background-color: #fff; /* Fundo do card claro */
        color: #212529; /* Texto do card escuro */
        border: 1px solid #dee2e6;
    }
    .content-list h3 {
        border-bottom: 1px solid #dee2e6;
    }
    .content-item img {
        background-color: #f1f1f1;
    }

    /* 2. Sobrescreve para o TEMA ESCURO */
    [data-theme="dark"] .dashboard-container {
        color: #e4e6eb; /* Texto claro */
    }
    [data-theme="dark"] .content-list {
        background-color: #2a2e33; /* Fundo do card escuro */
        color: #e4e6eb; /* Texto do card claro */
        border-color: #3a3f44;
    }
    [data-theme="dark"] .content-list h3 {
        border-bottom-color: #3a3f44;
    }
    [data-theme="dark"] .content-item img {
        background-color: #37484f; /* Fundo da imagem escura */
    }
    
    /* Estilos de Layout (do seu código) */
    .dashboard-container { display: flex; flex-wrap: wrap; gap: 20px; }
    .counter-box { flex: 1; min-width: 250px; padding: 20px; border-radius: 8px; text-align: center; box-shadow: 0 2px 5px rgba(0,0,0,0.2); }
    .counter-box h1 { font-size: 3em; margin: 0 0 10px 0; }
    .content-list { flex: 1; min-width: 320px; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.2); }
    .content-list h3 { padding-bottom: 10px; margin-top: 0; }
    .content-item { display: flex; align-items: center; margin-bottom: 12px; font-size: 0.9em; }
    .content-item img { width: 40px; height: 60px; margin-right: 15px; border-radius: 4px; object-fit: cover; }
    .content-item div { display: flex; flex-direction: column; }
    .content-list button { width: 100%; background-color: #3c8dbc; color: white; border: none; padding: 12px; border-radius: 5px; cursor: pointer; margin-top: 10px; font-size: 1em; }
    .content-list button:hover { background-color: #367fa9; }
</style>
<div class="container-fluid py-4"> <div class="dashboard-container" style="margin-bottom: 20px;">
        <div class="counter-box" style="background: linear-gradient(45deg, #0073b7, #0099d4);">
            <h1><?php echo $total_canais; ?></h1>
            <p>Total de Canais</p>
        </div>
        <div class="counter-box" style="background: linear-gradient(45deg, #00a65a, #00ca6d);">
            <h1><?php echo $total_filmes; ?></h1>
            <p>Total de Filmes</p>
        </div>
        <div class="counter-box" style="background: linear-gradient(45deg, #607d8b, #78909c);">
            <h1><?php echo $total_series; ?></h1>
            <p>Total de Séries</p>
        </div>
    </div>

    <div class="dashboard-container">
        <div class="content-list">
            <h3>Novos Canais</h3>
            <div id="lista-canais">
                <?php while($canal = $novos_canais_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <p><?php echo htmlspecialchars($canal['name']); ?> - <small><?php echo date('d/m/Y', strtotime($canal['added'])); ?></small></p>
                <?php endwhile; ?>
            </div>
            <?php if ($isAdmin): ?>
                <button onclick="copiarTexto('lista-canais')">Copiar Novidades</button>
            <?php endif; ?>
        </div>

        <div class="content-list">
            <h3>Novos Filmes</h3>
            <div id="lista-filmes">
                <?php while($filme = $novos_filmes_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <div class="content-item">
                        <img src="<?php echo htmlspecialchars($filme['stream_icon']); ?>" alt="">
                        <div>
                            <span><?php echo "🎥 " . htmlspecialchars($filme['name']); ?></span>
                            <small><?php echo date('d/m/Y', strtotime($filme['added'])); ?></small>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php if ($isAdmin): ?>
                <button onclick="copiarTexto('lista-filmes')">Copiar Novidades</button>
            <?php endif; ?>
        </div>

        <div class="content-list">
            <h3>Novas Séries</h3>
            <div id="lista-series">
                <?php while($serie = $novas_series_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <div class="content-item">
                        <img src="<?php echo htmlspecialchars($serie['cover']); ?>" alt="">
                        <div>
                            <span><?php echo "🎥 " . htmlspecialchars($serie['name']); ?></span>
                            <small><?php echo !empty($serie['release_date']) ? date('d/m/Y', strtotime($serie['release_date'])) : 'Sem data'; ?></small>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php if ($isAdmin): ?>
                <button onclick="copiarTexto('lista-series')">Copiar Novidades</button>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    function copiarTexto(elementId) {
        const listElement = document.getElementById(elementId);
        let textToCopy = '';
        
        listElement.querySelectorAll('.content-item, p').forEach(item => {
            let cleanText = item.innerText.trim().replace(/\s+/g, ' ');
            textToCopy += cleanText + '\n';
        });

        if (navigator.clipboard) {
            navigator.clipboard.writeText(textToCopy).then(() => {
                Swal.fire('Copiado!', 'Lista de novidades copiada!', 'success'); // Usa Swal.fire
            }).catch(err => {
                console.error('Erro ao copiar: ', err);
                Swal.fire('Erro!', 'Não foi possível copiar a lista.', 'error'); // Usa Swal.fire
            });
        } else {
             Swal.fire('Erro!', 'A função de copiar não é suportada neste navegador.', 'error'); // Usa Swal.fire
        }
    }
</script>

<?php
// Inclui o rodapé para carregar o SweetAlert (Swal) e fechar a página
require_once("footer.php"); 
?>