<?php
// Aumenta os limites de execução para arquivos grandes
@ini_set('memory_limit', '512M');
@set_time_limit(300); // 5 minutos

// Define o caminho para o arquivo de banco de dados
require_once(__DIR__ . '/api/controles/db.php');

// ########################################################
// ### SEU LINK DE EPG JÁ ESTÁ AQUI ###
// ########################################################
$xmltv_url = 'http://epgpainel.ddns.net/epg.xml';
// ########################################################

echo "Iniciando importação do EPG... (Isso pode demorar alguns minutos)\n<br>";
flush(); // Envia a primeira mensagem para o navegador

$conn = conectar_bd();
if (!$conn) {
    die("Falha ao conectar ao banco de dados.\n");
}

// Limpa dados antigos para manter a tabela otimizada
try {
    echo "Limpando dados antigos... ";
    $conn->exec("DELETE FROM epg_data WHERE end_time < NOW() - INTERVAL 1 DAY");
    echo "OK.\n<br>";
    flush();
} catch (PDOException $e) {
    if ($e->getCode() != '42S02') { // Ignora erro se a tabela não existir ainda
        die("Erro ao limpar dados antigos: " . $e->getMessage() . "\n");
    }
}

// Baixa o novo arquivo XMLTV
echo "Baixando o arquivo EPG do fornecedor... ";
$xml_content = @file_get_contents($xmltv_url);
if ($xml_content === FALSE) {
    die("Falha ao baixar o arquivo XMLTV. Verifique se o link está correto e acessível.\n");
}
echo "OK.\n<br>";
flush();

// Processa o XML
echo "Processando o XML e salvando no banco de dados... ";
try {
    $xml = new SimpleXMLElement($xml_content);
} catch (Exception $e) {
    die("Erro ao processar o arquivo XML. O conteúdo pode estar mal formatado: " . $e->getMessage() . "\n");
}

$stmt = $conn->prepare(
    "INSERT INTO epg_data (channel_id, start_time, end_time, title, description) 
     VALUES (:channel_id, :start_time, :end_time, :title, :description)"
);

$count = 0;
// Começa a transação para uma inserção em massa muito mais rápida
$conn->beginTransaction(); 
try {
    foreach ($xml->programme as $programme) {
        $channel_id = (string)$programme['channel'];
        $start = DateTime::createFromFormat('YmdHis O', (string)$programme['start'])->format('Y-m-d H:i:s');
        $end = DateTime::createFromFormat('YmdHis O', (string)$programme['stop'])->format('Y-m-d H:i:s');
        $title = (string)$programme->title;
        $desc = isset($programme->desc) ? (string)$programme->desc : null;

        $stmt->execute([
            ':channel_id' => $channel_id,
            ':start_time' => $start,
            ':end_time' => $end,
            ':title' => $title,
            ':description' => $desc
        ]);
        $count++;
    }
    $conn->commit(); 
} catch (Exception $e) {
    $conn->rollBack();
    die("Erro durante a inserção dos dados: " . $e->getMessage() . "\n");
}

echo "OK.\n<br>";
echo "<strong>Importação concluída! $count programas foram adicionados.</strong>\n";
?>