<?php
// ARQUIVO: /gerenciador/ajax/episodio_excluir_massa.php
header('Content-Type: application/json');
require_once('../../api/controles/db.php');

function responder($sucesso, $mensagem) {
    echo json_encode(['success' => $sucesso, 'message' => $mensagem]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    responder(false, 'Acesso negado.');
}

$ids = $_POST['ids'] ?? [];
if (!is_array($ids) || empty($ids)) {
    responder(false, 'Nenhum episódio foi selecionado.');
}

$ids_sanitizados = array_filter($ids, 'is_numeric');
if (empty($ids_sanitizados)) {
    responder(false, 'Os IDs fornecidos são inválidos.');
}

try {
    $pdo = conectar_bd();
    $placeholders = implode(',', array_fill(0, count($ids_sanitizados), '?'));

    $sql = "DELETE FROM series_episodes WHERE id IN ($placeholders)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($ids_sanitizados);

    $count = $stmt->rowCount();
    responder(true, "$count episódio(s) foram excluídos com sucesso!");

} catch (PDOException $e) {
    responder(false, 'Erro no banco de dados ao tentar excluir os episódios.');
}
?>