<?php
session_start();
if (!isset($_SESSION['logged_in_fxtream']) || $_SESSION['logged_in_fxtream'] !== true) {
    die("Acesso não autorizado.");
}
require_once '../api/controles/db.php';
$pdo = conectar_bd();
$mensagem_sucesso = '';
$mensagem_erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $novo_timeout = filter_input(INPUT_POST, 'timeout_segundos', FILTER_VALIDATE_INT);

    if ($novo_timeout !== false && $novo_timeout > 0) {
        try {
            // ATUALIZADO: Salva a chave em segundos
            $stmt = $pdo->prepare("UPDATE painel_config SET valor = :valor WHERE chave = 'timeout_conexoes_segundos'");
            $stmt->execute([':valor' => $novo_timeout]);
            $mensagem_sucesso = "Configuração salva com sucesso! O novo tempo é de {$novo_timeout} segundos.";
        } catch (Exception $e) {
            $mensagem_erro = "Erro ao salvar a configuração: " . $e->getMessage();
        }
    } else {
        $mensagem_erro = "Valor inválido. Por favor, insira apenas números inteiros maiores que zero.";
    }
}

try {
    // ATUALIZADO: Carrega a chave em segundos
    $stmt = $pdo->prepare("SELECT valor FROM painel_config WHERE chave = 'timeout_conexoes_segundos'");
    $stmt->execute();
    $timeout_atual = $stmt->fetchColumn();
} catch (Exception $e) {
    $mensagem_erro = "Erro ao carregar a configuração atual: " . $e->getMessage();
    $timeout_atual = '10800'; // Valor padrão em caso de erro
}
$pdo = null;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações do Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <script>
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'dark';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
    <style>
        /* CSS completo para tema claro/escuro */
        :root { --bg-main: #f0f2f5; --bg-card: #ffffff; --text-primary: #212529; --text-secondary: #6c757d; --border-color: #dee2e6; --input-bg: #ffffff; --input-text: #212529; --input-border: #ced4da; }
        [data-theme="dark"] { --bg-main: #212529; --bg-card: #343a40; --text-primary: #f8f9fa; --text-secondary: #adb5bd; --border-color: #495057; --input-bg: #495057; --input-text: #f8f9fa; --input-border: #6c757d; }
        body { background-color: var(--bg-main); color: var(--text-primary); transition: background-color 0.2s linear; }
        .card { background-color: var(--bg-card); border: 1px solid var(--border-color); color: var(--text-primary); }
        .card-header { border-bottom: 1px solid var(--border-color); }
        .card-footer { border-top: 1px solid var(--border-color); color: var(--text-secondary); }
        .form-control { background-color: var(--input-bg); color: var(--input-text); border: 1px solid var(--input-border); }
        .form-control:focus { background-color: var(--input-bg); color: var(--input-text); border-color: #0d6efd; box-shadow: none; }
        .form-text { color: var(--text-secondary); }
        .btn-theme-toggle { background: none; border: 1px solid var(--border-color); color: var(--text-secondary); border-radius: 50%; width: 38px; height: 38px; display: flex; align-items: center; justify-content: center; }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-cogs me-2"></i>Configurações do Painel</h4>
                        <button id="theme-toggle" class="btn-theme-toggle" title="Alternar Tema"><i class="fas fa-moon"></i></button>
                    </div>
                    <div class="card-body">
                        <?php if ($mensagem_sucesso): ?><div class="alert alert-success"><?= htmlspecialchars($mensagem_sucesso) ?></div><?php endif; ?>
                        <?php if ($mensagem_erro): ?><div class="alert alert-danger"><?= htmlspecialchars($mensagem_erro) ?></div><?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <label for="timeout_segundos" class="form-label">
                                    <strong>Tempo de Limpeza de Conexões Inativas (em SEGUNDOS)</strong>
                                </label>
                                <input type="number" class="form-control" id="timeout_segundos" name="timeout_segundos" value="<?= htmlspecialchars($timeout_atual) ?>" required>
                                <div class="form-text">
                                    Este é o tempo que uma conexão "fantasma" leva para ser removida.
                                    Recomendado: 10800 (para 3 horas).
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i>Salvar Configuração</button>
                        </form>
                    </div>
                    <div class="card-footer text-muted small">
                        Após salvar, o dashboard de atividade online já usará o novo valor automaticamente.
                    </div>
                </div>
            </div>
        </div>
    </div>
<script>
    // Script do tema permanece o mesmo
    const themeToggleBtn = document.getElementById('theme-toggle');
    const rootEl = document.documentElement;
    const sunIcon = 'fa-sun';
    const moonIcon = 'fa-moon';
    function applyTheme(theme) {
        rootEl.setAttribute('data-theme', theme);
        const icon = theme === 'dark' ? sunIcon : moonIcon;
        themeToggleBtn.querySelector('i').className = `fas ${icon}`;
    }
    themeToggleBtn.addEventListener('click', () => {
        const currentTheme = rootEl.getAttribute('data-theme');
        const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
        localStorage.setItem('theme', newTheme);
        applyTheme(newTheme);
    });
    const savedTheme = localStorage.getItem('theme') || 'dark';
    applyTheme(savedTheme);
</script>
</body>
</html>