<?php
// ARQUIVO: /gerenciador/ajax/episodio_excluir.php
header('Content-Type: application/json');
require_once('../../api/controles/db.php');

function responder($sucesso, $mensagem) {
    echo json_encode(['success' => $sucesso, 'message' => $mensagem]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    responder(false, 'Acesso negado.');
}

$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    responder(false, 'ID do episódio inválido.');
}

try {
    $pdo = conectar_bd();
    $stmt = $pdo->prepare("DELETE FROM series_episodes WHERE id = ?");
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        responder(true, 'Episódio excluído com sucesso!');
    } else {
        responder(false, 'Episódio não encontrado.');
    }
} catch (PDOException $e) {
    responder(false, 'Erro no banco de dados.');
}
?>