<?php
// ARQUIVO: /gerenciador/temporada_atualizar.php

// 1. CONECTAR AO BANCO DE DADOS
require_once('../api/controles/db.php');
$pdo = conectar_bd();

// 2. VERIFICAR SE OS DADOS FORAM ENVIADOS VIA POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso negado. Este script só pode ser acessado via formulário.");
}

// 3. PEGAR E VALIDAR OS DADOS DO FORMULÁRIO
$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
$series_id = filter_input(INPUT_POST, 'series_id', FILTER_VALIDATE_INT);
$name = trim($_POST['name'] ?? '');
$season_number = filter_input(INPUT_POST, 'season_number', FILTER_VALIDATE_INT);
$cover = trim($_POST['cover'] ?? '');

// Validação básica para garantir que os dados essenciais não estão faltando
if (!$id || !$series_id || !$name || $season_number === false) {
    die("Erro: Dados inválidos ou faltando. Por favor, preencha todos os campos obrigatórios.");
}

// 4. PREPARAR E EXECUTAR A QUERY SQL PARA ATUALIZAR (UPDATE)
try {
    // A query SQL para ATUALIZAR um registro existente
    $sql = "UPDATE series_seasons SET name = ?, season_number = ?, cover = ? WHERE id = ?";
    
    // Prepara a query para evitar injeção de SQL
    $stmt = $pdo->prepare($sql);
    
    // Executa a query, passando os novos valores e o ID para a cláusula WHERE
    $stmt->execute([
        $name,
        $season_number,
        $cover,
        $id 
    ]);

    // 5. REDIRECIONAR DE VOLTA PARA A PÁGINA DE TEMPORADAS
    // Após atualizar, o usuário é enviado de volta para a lista de temporadas da série
    header("Location: serie_episodios.php?id=" . $series_id);
    exit(); // É importante chamar exit() após um redirecionamento de header

} catch (PDOException $e) {
    // Se houver um erro com o banco de dados, exibe a mensagem de erro.
    die("Erro ao atualizar a temporada no banco de dados: " . $e->getMessage());
}