<?php
// ARQUIVO: /gerenciador/temporada_editar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

// 1. PEGAR O ID DA TEMPORADA DA URL
$temporada_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$temporada_id) {
    die("ID da temporada inválido.");
}

// 2. BUSCAR OS DADOS ATUAIS DA TEMPORADA NO BANCO
$stmt = $pdo->prepare("SELECT * FROM series_seasons WHERE id = ?");
$stmt->execute([$temporada_id]);
$temporada = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$temporada) {
    die("Temporada não encontrada.");
}

// (Opcional) Buscar nome da série para o título
$stmt_serie = $pdo->prepare("SELECT name FROM series WHERE id = ?");
$stmt_serie->execute([$temporada['series_id']]);
$serie = $stmt_serie->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Temporada</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header, body.dark-mode h4, body.dark-mode .form-label { color: #ffffff; }
        body.dark-mode .form-control { background-color: #2a2a2a; border-color: #3c3c3c; color: #e0e0e0; }
        body.dark-mode .form-control:focus { background-color: #2a2a2a; border-color: #0d6efd; color: #e0e0e0; }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="card">
            <div class="card-header">
                <h4><i class="fas fa-pencil-alt me-2"></i>Editar Temporada de: <strong><?= htmlspecialchars($serie['name'] ?? '') ?></strong></h4>
            </div>
            <div class="card-body">
                <form action="temporada_atualizar.php" method="POST">
                    
                    <input type="hidden" name="id" value="<?= htmlspecialchars($temporada['id']) ?>">
                    <input type="hidden" name="series_id" value="<?= htmlspecialchars($temporada['series_id']) ?>">

                    <div class="mb-3">
                        <label for="name" class="form-label">Nome da Temporada</label>
                        <input type="text" class="form-control" id="name" name="name" value="<?= htmlspecialchars($temporada['name']) ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="season_number" class="form-label">Número da Temporada</label>
                        <input type="number" class="form-control" id="season_number" name="season_number" value="<?= htmlspecialchars($temporada['season_number']) ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="cover" class="form-label">URL da Imagem de Capa</label>
                        <input type="text" class="form-control" id="cover" name="cover" value="<?= htmlspecialchars($temporada['cover']) ?>">
                    </div>

                    <a href="serie_episodios.php?id=<?= htmlspecialchars($temporada['series_id']) ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Atualizar Temporada
                    </button>
                </form>
            </div>
        </div>
    </div>
<script>
// Lógica do tema escuro
(function() { const themeKey = 'theme'; function applyTheme() { const savedTheme = localStorage.getItem(themeKey); document.body.classList.toggle('dark-mode', savedTheme === 'dark'); } applyTheme(); })();
</script>
</body>
</html>