<?php
// ARQUIVO: /gerenciador/temporada_salvar.php

// 1. CONECTAR AO BANCO DE DADOS
require_once('../api/controles/db.php');
$pdo = conectar_bd();

// 2. VERIFICAR SE OS DADOS FORAM ENVIADOS VIA POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // Se não for POST, encerra a execução.
    die("Acesso negado. Este script só pode ser acessado via formulário.");
}

// 3. PEGAR E VALIDAR OS DADOS DO FORMULÁRIO
// Usamos trim() para remover espaços em branco no início e no fim
$series_id = filter_input(INPUT_POST, 'series_id', FILTER_VALIDATE_INT);
$name = trim($_POST['name'] ?? '');
$season_number = filter_input(INPUT_POST, 'season_number', FILTER_VALIDATE_INT);
$cover = trim($_POST['cover'] ?? ''); // O link da capa pode ser vazio

// Validação básica
if (!$series_id || !$name || $season_number === false) {
    die("Erro: Dados inválidos ou faltando. Por favor, preencha todos os campos obrigatórios.");
}

// 4. PREPARAR E EXECUTAR A QUERY SQL PARA INSERIR OS DADOS
try {
    // A query SQL para inserir uma nova temporada na tabela `series_seasons`
    $sql = "INSERT INTO series_seasons (series_id, name, season_number, cover) VALUES (?, ?, ?, ?)";
    
    // Prepara a query para evitar injeção de SQL
    $stmt = $pdo->prepare($sql);
    
    // Executa a query, passando os valores de forma segura
    $stmt->execute([
        $series_id,
        $name,
        $season_number,
        $cover
    ]);

    // 5. REDIRECIONAR DE VOLTA PARA A PÁGINA DE TEMPORADAS
    // Após salvar, o usuário é enviado de volta para a lista de temporadas da série
    header("Location: serie_episodios.php?id=" . $series_id);
    exit(); // É importante chamar exit() após um redirecionamento de header

} catch (PDOException $e) {
    // Se houver um erro com o banco de dados, exibe a mensagem de erro.
    // Em um ambiente de produção, você poderia registrar esse erro em um log.
    die("Erro ao salvar a temporada no banco de dados: " . $e->getMessage());
}