<?php
/**
 * ARQUIVO: /gerenciador/ajax/temporadas_excluir_massa.php
 * DESCRIÇÃO: Script para exclusão em massa de temporadas e seus respectivos episódios.
 */

header('Content-Type: application/json');
require_once('../../api/controles/db.php');
$pdo = conectar_bd();

if (!$pdo) {
    echo json_encode(['success' => false, 'message' => 'Erro ao conectar com o banco de dados.']);
    exit;
}

$ids = $_POST['ids'] ?? null;

if (empty($ids) || !is_array($ids)) {
    echo json_encode(['success' => false, 'message' => 'Nenhum ID de temporada foi fornecido.']);
    exit;
}

$ids = array_filter($ids, 'is_numeric');

if (empty($ids)) {
    echo json_encode(['success' => false, 'message' => 'Nenhum ID de temporada válido foi fornecido.']);
    exit;
}

try {
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    
    $pdo->beginTransaction();

    // Passo 1: Excluir os episódios relacionados às temporadas.
    // **IMPORTANTE**: Assumindo que sua tabela de episódios tem uma coluna `season_id`.
    $sql_episodes = "DELETE FROM series_episodes WHERE season_id IN ($placeholders)";
    $stmt_episodes = $pdo->prepare($sql_episodes);
    $stmt_episodes->execute($ids);

    // Passo 2: Excluir as temporadas.
    $sql_seasons = "DELETE FROM series_seasons WHERE id IN ($placeholders)";
    $stmt_seasons = $pdo->prepare($sql_seasons);
    $stmt_seasons->execute($ids);

    $pdo->commit();

    echo json_encode(['success' => true, 'message' => $stmt_seasons->rowCount() . ' temporada(s) e seus episódios foram excluídos com sucesso!']);

} catch (PDOException $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'Erro no banco de dados: ' . $e->getMessage()]);
}
?>