<?php
// 1. Inclui o seu menu
require_once("menu.php");
?>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');

    .changelog-container {
        /* Cores do container */
        background-color: var(--bs-card-bg);
        border: 1px solid var(--bs-border-color);
        
        /* ================================================================== */
        /* ### CORREÇÃO DEFINITIVA (AGORA VAI) ### */
        /*
         * Força a cor-base do texto dentro deste container a ser 
         * a cor de TÍTULO (que é branca no tema escuro).
         */
        color: var(--bs-heading-color);
        /* ================================================================== */
        
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        width: 100%;
        max-width: 800px;
        overflow: hidden;
        margin: 0 auto; 
    }

    .changelog-header {
        text-align: center;
        padding: 40px 20px;
        background: var(--bs-tertiary-bg);
        border-bottom: 1px solid var(--bs-border-color);
    }

    .logo-wrapper {
        position: relative;
        width: 150px;
        height: 110px;
        margin: 0 auto;
        background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 150"><path d="M10 20 H190 V110 H10 Z" fill="none"/><path d="M10 20 Q5 20 5 25 V105 Q5 110 10 110 H190 Q195 110 195 105 V25 Q195 20 190 20 Z M100 120 H120 V140 H80 V120 Z" fill="%23333"/><rect x="15" y="25" width="170" height="80" rx="5" fill="%23000" stroke="%23555" stroke-width="2"/><text x="100" y="75" font-family="Roboto, sans-serif" font-size="20" fill="%2300aaff" font-weight="bold" text-anchor="middle">TOP IPTV</text></svg>');
        background-size: contain;
        background-repeat: no-repeat;
        background-position: center;
    }

    .changelog-header h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--bs-heading-color);
        margin: 20px 0 0;
    }

    .changelog-content {
        padding: 20px 25px;
    }
    
    .version-entry {
        padding-bottom: 30px;
        margin-bottom: 30px;
        border-bottom: 1px solid var(--bs-border-color);
    }
    .version-entry:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 10px;
    }

    .version-title {
        font-size: 20px;
        font-weight: 700;
        color: var(--bs-heading-color);
        margin-bottom: 5px;
    }

    /* ================================================================== */
    /* ### CORREÇÃO DEFINITIVA (TEXTO INVISÍVEL) ### */
    /* ================================================================== */
    
    /* 1. Define a cor do texto secundário (descrições, codename) */
    /*
     * MODIFICADO AQUI:
     * Removemos .version-description e li p desta regra.
     * Agora, apenas o .codename fica cinza. O resto herda o branco.
    */
    .version-title .codename {
        /* Usa a variável de texto "secundário" (cinza-claro no tema escuro) */
        color: var(--bs-secondary-color);  
    }

    .version-description {
        font-size: 15px;
        line-height: 1.5;
        margin-bottom: 25px;
        /* A cor agora é herdada do .changelog-container (branco) */
    }

    /* 2. Define a cor dos itens da lista (<li>) */
    li {
        display: flex;
        align-items: flex-start;
        margin-bottom: 12px;
        font-size: 15px;
        /* Força a cor principal do texto (branco no tema escuro) */
        color: var(--bs-heading-color) !important;  
    }
    
    /* 3. Define a cor dos parágrafos DENTRO dos <li> (as descrições) */
    li p {
        font-size: 14px;
        margin: 5px 0 0;
        /* A cor agora é herdada do <li> (branco) */
         color: var(--bs-heading-color); /* Garante o branco */
    }
    
    /* 4. Garante que os títulos DENTRO dos <li> fiquem claros */
    li strong {
        color: var(--bs-heading-color) !important;
    }
    
    /* ================================================================== */
    /* ### FIM DA CORREÇÃO ### */
    /* ================================================================== */


    .section-title {
        font-size: 16px;
        font-weight: 700;
        color: var(--bs-heading-color);
        margin-top: 30px;
        margin-bottom: 15px;
        border-bottom: 1px solid var(--bs-border-color);
        padding-bottom: 8px;
    }

    ul {
        list-style: none;
        padding-left: 0;
    }

    li i {
        color: #0d6efd; /* Azul do Bootstrap */
        margin-right: 12px;
        margin-top: 4px;
    }
    
    .tag {
        background-color: #e7f3ff;
        color: #1877f2;
        padding: 2px 6px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 700;
        margin-left: 8px;
        text-transform: uppercase;
    }
    
</style>

<div class="changelog-container">
    <div class="changelog-header">
        <div class="logo-wrapper"></div>
        <h1>Notas de Atualização</h1>
    </div>

    <div class="changelog-content">

        <div id="v4125" class="version-entry">
            <h2 class="version-title">Atualização 4.1.24 - Codename: <span class="codename">"Equilíbrio"</span></h2>
            <p class="version-description">
                Focada em robustez e performance, esta atualização introduz um sistema de Load Balance inteligente, projetado para distribuir o tráfego de forma eficiente, garantir a máxima estabilidade e melhorar a experiência do usuário final.
            </p>
            <h3 class="section-title">🚀 Novas Funcionalidades</h3>
            <ul>
                <li>
                    <i class="fas fa-server"></i>
                    <div>
                        <strong>Sistema de Load Balance Inteligente</strong><span class="tag">DESTAQUE</span>
                        <p>Implementado um poderoso sistema de Load Balance que distribui as requisições entre múltiplos servidores. É possível adicionar e gerenciar vários servidores de balanceamento para garantir alta disponibilidade e uma conexão mais estável para todos os clientes, mesmo em horários de pico.</p>
                    </div>
                </li>
            </ul>
        </div>
        
        <div id="v4124" class="version-entry">
            <h2 class="version-title">Atualização 4.1.23 - Codename: <span class="codename">"Conexão Direta"</span></h2>
            <p class="version-description">
                Esta grande atualização introduz um módulo completo e dedicado para o gerenciamento de clientes P2P por código. O sistema foi projetado para ser robusto, seguro e totalmente integrado ao painel, com permissões específicas para administradores e revendedores.
            </p>
            <h3 class="section-title">🚀 Novas Funcionalidades</h3>
            <ul>
                <li>
                    <i class="fas fa-network-wired"></i>
                    <div>
                        <strong>Módulo Dedicado de Clientes P2P por Código</strong><span class="tag">DESTAQUE</span>
                        <p>Implementado um sistema completo para criar e gerenciar usuários P2P que acessam o serviço através de um código numérico único e uma senha global. Inclui a criação de clientes, testes com duração personalizável e renovação de planos.</p>
                    </div>
                </li>
                <li>
                    <i class="fas fa-users-cog"></i>
                    <div>
                        <strong>Permissões para Administradores e Revendedores</strong>
                        <p>O módulo P2P distingue administradores e revendedores. Cada revendedor tem acesso apenas aos seus próprios clientes e testes P2P, garantindo a segurança e a organização das contas.</p>
                    </div>
                </li>
                <li>
                    <i class="fas fa-envelope-open-text"></i>
                    <div>
                        <strong>Templates de Mensagem Personalizáveis</strong>
                        <p>Adicionada uma nova área nas configurações para editar o template de mensagem que é gerado ao criar ou renovar um cliente/teste P2P, com botões para copiar e enviar via WhatsApp.</p>
                    </div>
                </li>
            </ul>
        </div>

        <div id="v4123" class="version-entry">
            <h2 class="version-title">Atualização 4.1.22 - Codename: <span class="codename">"Agilidade"</span></h2>
            <p class="version-description">
                Esta atualização foca em otimizar o fluxo de trabalho dos revendedores com a introdução do Teste Rápido, e solidifica a confiabilidade do sistema com uma reestruturação completa do módulo de EPG, garantindo dados precisos e sempre disponíveis para os seus clientes.
            </p>
            <h3 class="section-title">🚀 Novas Funcionalidades</h3>
            <ul>
                <li>
                    <i class="fas fa-bolt"></i>
                    <div>
                        <strong>Sistema de Teste Rápido Integrado</strong><span class="tag">DESTAQUE</span>
                        <p>Agora é possível gerar um teste completo para um novo cliente com um único clique, diretamente do cabeçalho do painel. O sistema cria o usuário, define a validade e exibe todos os dados de acesso em um novo modal, otimizado para copiar e enviar via WhatsApp.</p>
                    </div>
                </li>
            </ul>
             <h3 class="section-title">✨ Melhorias</h3>
            <ul>
                <li>
                    <i class="fas fa-calendar-alt"></i>
                    <div>
                        <strong>Reestruturação Completa do Sistema de EPG</strong><span class="tag">DESTAQUE</span>
                        <p>O módulo de EPG foi totalmente reescrito. A importação de dados agora é mais robusta, salvando toda a programação no banco de dados local. A entrega do guia aos aplicativos (`xmltv.php`) é instantânea e não depende mais de servidores externos, garantindo um EPG 100% funcional e confiável.</p>
                    </div>
                </li>
            </ul>
        </div>
        
        <div id="v4121" class="version-entry">
            <h2 class="version-title">Atualização 4.1.21 - Codename: <span class="codename">"Autonomia"</span></h2>
            <p class="version-description">
                Esta atualização tem como foco principal aprimorar a autonomia dos seus clientes, permitindo que eles renovem seus planos diretamente da área do cliente, de forma automática e segura.
            </p>
            <h3 class="section-title">🚀 Novas Funcionalidades</h3>
            <ul>
                <li>
                    <i class="fas fa-sync-alt"></i>
                    <div>
                        <strong>Renovação Automática por Pagamento</strong><span class="tag">DESTAQUE</span>
                        <p>Implementado um sistema de renovação automática que, após o cliente realizar o pagamento pela área do cliente, atualiza a data de vencimento do plano de forma instantânea, garantindo a continuidade do serviço sem a sua intervenção manual.</p>
                    </div>
                </li>
            </ul>
        </div>

        <div id="v4120" class="version-entry">
            <h2 class="version-title">Atualização 4.1.20 - Codename: <span class="codename">"Comunidade"</span></h2>
            <p class="version-description">
                Esta versão foca em aprimorar a interação e eficiência, introduzindo o novo sistema de Chatbot e a gestão de listas em massa.
            </p>
            <h3 class="section-title">🚀 Novas Funcionalidades</h3>
            <ul>
                <li>
                    <i class="fas fa-comments"></i>
                    <div>
                        <strong>Chatbot para Suporte em Tempo Real</strong><span class="tag">DESTAQUE</span>
                        <p>Implementação de um chatbot para suporte ao cliente, permitindo interações em tempo real e respostas automáticas para dúvidas comuns.</p>
                    </div>
                </li>
                <li>
                    <i class="fas fa-trash-alt"></i>
                    <div>
                        <strong>Exclusão de Listas em Massa</strong>
                        <p>Uma nova ferramenta para selecionar e excluir múltiplas listas de clientes de uma só vez, agilizando a limpeza do painel.</p>
                    </div>
                </li>
            </ul>
        </div>
        
    </div>
</div>
    
<?php
// 2. Inclui o seu rodapé
require_once("footer.php");
?>