<?php
// Define o fuso horário e requer o banco de dados
date_default_timezone_set('America/Sao_Paulo');
require_once "./api/controles/db.php";

// --- SUAS FUNÇÕES PERSONALIZADAS ORIGINAIS ---
function processarUrl($url) {
    $parsedUrl = parse_url($url);
    if (!isset($parsedUrl["path"])) return false;
    $path = $parsedUrl["path"];
    $pathParts = explode("/", trim($path, "/"));
    if (count($pathParts) >= 4) {
        $domain = $parsedUrl["host"]; $usuario = $pathParts[1];
        $senha = $pathParts[2]; $arquivo = pathinfo($pathParts[3], PATHINFO_FILENAME);
    } elseif (count($pathParts) == 3) {
        $domain = $parsedUrl["host"]; $usuario = $pathParts[0];
        $senha = $pathParts[1]; $arquivo = pathinfo($pathParts[2], PATHINFO_FILENAME);
    } else { return false; }
    if (empty($arquivo) || !is_numeric($arquivo)) { return false; }
    return ["dominio" => $domain, "usuario" => $usuario, "senha" => $senha, "arquivo" => $arquivo];
}
function getHeadersAsJson($url) {
    $options = ["http" => ["method" => "GET", "header" => "User-Agent: XCIPTV\r\n", "timeout" => 5]];
    $context = stream_context_create($options);
    $headers = @get_headers($url, 1, $context);
    if ($headers === false) return null;
    if (isset($headers["Location"])) {
        $location = is_array($headers["Location"]) ? end($headers["Location"]) : $headers["Location"];
        return ["Location" => $location];
    }
    if (isset($headers["URLsComToken"])) {
        $tokenUrl = is_array($headers["URLsComToken"]) ? end($headers["URLsComToken"]) : $headers["URLsComToken"];
        return ["URLsComToken" => $tokenUrl];
    }
    return null;
}

// --- PARÂMETROS E VALIDAÇÃO INICIAL ---
$username = $_GET["usuario"] ?? null;
$password = $_GET["senha"] ?? null;
$arquivo = $_GET["arquivo"] ?? null;
$type = $_GET["type_url"] ?? "live";
$stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
$extensao = pathinfo($arquivo, PATHINFO_EXTENSION);

if (empty($stream_id) || !$username || !$password) {
    http_response_code(400); exit("Parâmetros insuficientes.");
}

$conexao = null;
try {
    $conexao = conectar_bd();
    $conexao->beginTransaction();

    // --- LÓGICA UNIFICADA DE AUTENTICAÇÃO E CONTROLE DE CONEXÃO ---
    $stmt_cliente = $conexao->prepare("SELECT * FROM clientes WHERE usuario = :username AND senha = :password FOR UPDATE");
    $stmt_cliente->execute([':username' => $username, ':password' => $password]);
    $cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC);

    if (!$cliente) { throw new Exception("Usuário ou senha inválidos.", 401); }
    if (new DateTime() > new DateTime($cliente["Vencimento"])) {
        $conexao->rollBack();
        header("Location: http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4");
        exit();
    }
    
    $ip = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
    $limiteConexoes = (int) $cliente["conexoes"];

    // LIMPEZA: Remove conexões fantasmas do usuário atual. Idealmente, isso seria um trabalho agendado (cron job).
    $stmt_limpeza = $conexao->prepare("DELETE FROM conexoes WHERE usuario = :usuario AND ultima_atividade < NOW() - INTERVAL 25 SECOND");
    $stmt_limpeza->execute([':usuario' => $username]);

    // Tenta ATUALIZAR a conexão existente para manter o usuário ativo (keep-alive)
    $stmt_update = $conexao->prepare("UPDATE conexoes SET ultima_atividade = NOW(), stream_id = :stream_id WHERE usuario = :usuario AND ip = :ip AND user_agent = :user_agent");
    $stmt_update->execute([':stream_id' => $stream_id, ':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent]);

    // Se não atualizou nenhuma linha, significa que é uma NOVA conexão
    if ($stmt_update->rowCount() === 0) { 
        // Conta as conexões existentes PARA AQUELE USUÁRIO, travando o resultado para evitar "condição de corrida"
        // ▼▼▼ ESTA É A LINHA CORRIGIDA ▼▼▼
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :usuario FOR UPDATE");
        $stmt_count->execute([':usuario' => $username]);
        
        // Verifica se o limite foi atingido
        if ((int)$stmt_count->fetchColumn() >= $limiteConexoes) { 
            throw new Exception("Voce atingiu o limite de conexao contratado.", 403); 
        }
        
        // Se o limite não foi atingido, insere a nova conexão
        $stmt_insert = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:usuario, :ip, :user_agent, :stream_id, NOW())");
        $stmt_insert->execute([':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent, ':stream_id' => $stream_id]);
    }

    // --- LÓGICA DE BUSCA DE STREAM ---
    $tabela = '';
    switch ($type) {
        case 'live': case 'movie': $tabela = 'streams'; break;
        case 'series': $tabela = 'series_episodes'; break;
        default: throw new Exception("Tipo de conteúdo inválido.", 400);
    }
    
    $stmt_stream = $conexao->prepare("SELECT * FROM `{$tabela}` WHERE id = :id");
    $stmt_stream->execute([':id' => $stream_id]);
    $stream = $stmt_stream->fetch(PDO::FETCH_ASSOC);
    
    if (!$stream) { throw new Exception("Conteúdo não encontrado.", 404); }

    // COMMIT SÓ ACONTECE DEPOIS QUE TUDO FOI VERIFICADO E ENCONTRADO
    $conexao->commit();

    // --- LÓGICA DE REDIRECIONAMENTO ORIGINAL (MODO DIRECT) ---
    $location = $stream["link"];
    $tipo_link = $stream["tipo_link"] ?? 'link_direto';

    if ($tipo_link == "link_direto") { header("Location: " . $location); exit(); }

    $dados = @processarUrl($location);
    if ($location && $dados && $tipo_link !== "link_direto2") {
        $url = "http://{$dados["dominio"]}/{$type}/{$dados["usuario"]}/{$dados["senha"]}/{$dados["arquivo"]}.$extensao";
        if ($tipo_link == "padrao2") { header("Location: " . $location); exit(); }

        $location2 = getHeadersAsJson($url);
        if ($location2 && isset($location2["Location"])) {
            header("Location: " . $location2["Location"]);
            exit();
        }
        if ($location2 && isset($location2["URLsComToken"])) {
            header("Location: " . $location2["URLsComToken"]);
            exit();
        }
        header("Location: $url");
        exit();
    }

    $location3 = getHeadersAsJson($location);
    if ($location3 && isset($location3["Location"])) {
        header("Location: " . $location3["Location"]);
        exit();
    }
    if ($location3 && isset($location3["URLsComToken"])) {
        header("Location: " . $location3["URLsComToken"]);
        exit();
    }
    
    header("Location: $location");
    exit();

} catch (Exception $e) {
    if ($conexao && $conexao->inTransaction()) { $conexao->rollBack(); }
    $errorCode = $e->getCode() >= 400 ? $e->getCode() : 500;
    http_response_code($errorCode);

    // Se o erro for de cliente (limite atingido, não encontrado, etc.), redireciona para o vídeo de bloqueio
    if ($errorCode < 500) {
        // Redireciona para o vídeo de bloqueio com a mensagem como parâmetro (opcional)
        $message = urlencode($e->getMessage());
        header("Location: http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4?msg=" . $message);
    } else {
        // Se for erro de servidor, exibe mensagem genérica
        exit("Erro interno do servidor.");
    }
    exit();
}
?>