<?php
header("Content-Type: text/html; charset=UTF-8");
header("Cache-Control: no-store, no-cache, must-revalidate");

require_once('./api/controles/db.php');
date_default_timezone_set('America/Sao_Paulo');

// Suas funções personalizadas permanecem intactas
function processarUrl($url) {
    $parsedUrl = parse_url($url);
    $path = $parsedUrl['path'];
    $pathParts = explode('/', trim($path, '/'));
    if (count($pathParts) >= 4) {
        $domain = $parsedUrl['host'];
        $usuario = $pathParts[1];
        $senha = $pathParts[2];
        $arquivo = pathinfo($pathParts[3], PATHINFO_FILENAME);
    } elseif (count($pathParts) <= 3) {
        $domain = $parsedUrl['host'];
        $usuario = $pathParts[0];
        $senha = $pathParts[1];
        $arquivo = pathinfo($pathParts[2], PATHINFO_FILENAME);
    } else {
        return false;
    }
    if (empty($arquivo) || !is_numeric($arquivo)) {
        return false;
    }
    return [
        'dominio' => $domain,
        'usuario' => $usuario,
        'senha' => $senha,
        'arquivo' => $arquivo,
    ];
}
function getHeadersAsJson($url) {
    $options = ['http' => ['method' => 'GET', 'header' => "User-Agent: XCIPTV\r\n"]];
    $context = stream_context_create($options);
    $headers = @get_headers($url, 1, $context);
    if ($headers === false) {
        return json_encode(["error" => "Não foi possvel obter os cabeçalhos"], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    }
    if (isset($headers['Location'])) {
        $locations = is_array($headers['Location']) ? $headers['Location'] : [$headers['Location']];
        $urlsComToken = array_filter($locations, function($location) {
            return strpos($location, 'token=') !== false;
        });
        if (!empty($urlsComToken)) {
            return json_encode(["URLsComToken" => array_values($urlsComToken)], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        }
        return json_encode(["Location" => $locations], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    }
    return json_encode($headers, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
function getLocationFromURL($url) {
    $visitedUrls = [];
    $maxRedirects = 10;
    $redirectCount = 0;
    while ($redirectCount < $maxRedirects) {
        $options = ['http' => ['method' => 'GET', 'header' => "User-Agent: XCIPTV\r\n"]];
        $context = stream_context_create($options);
        $headers = @get_headers($url, 1, $context);
        if (!$headers) {
            return false;
        }
        if (isset($headers[0])) {
            if (strpos($headers[0], "401 Unauthorized") !== false || strpos($headers[0], "404 Not Found") !== false) {
                return false;
            }
        }
        if (isset($headers["Location"])) {
            $location = is_array($headers["Location"]) ? end($headers["Location"]) : $headers["Location"];
            if (in_array($location, $visitedUrls)) {
                return false;
            }
            $visitedUrls[] = $location;
            if (strpos($location, "token") !== false) {
                return trim($location);
            }
            $url = $location;
            $redirectCount++;
        } else {
            return false;
        }
    }
    return false;
}

// ---- Validação e Autenticação do Usuário ----
$type_url = $_GET['type_url'] ?? 'series';
$username = $_GET['usuario'] ?? null;
$password = $_GET['senha'] ?? null;
$arquivo = $_GET['arquivo'] ?? null;

if (!$username || !$password) {
    http_response_code(401);
    echo json_encode(['user_info' => ['auth' => 0, 'msg' => "username e password necessario!"]]);
    exit();
}

try {
    $conexao = conectar_bd();
    $query = "SELECT * FROM clientes WHERE usuario = :username AND senha = :password";
    $statement = $conexao->prepare($query);
    $statement->execute([':username' => $username, ':password' => $password]);
    $result = $statement->fetch(PDO::FETCH_ASSOC);

    if (!$result) {
        http_response_code(401);
        echo json_encode(["user_info" => ["auth" => 0]]);
        exit();
    }

    if (new DateTime($result["Vencimento"]) < new DateTime()) {
        $vencido = "http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4";
        header("Location: $vencido");
        exit();
    }
} catch (Exception $e) {
    http_response_code(503);
    echo json_encode(["user_info" => ["auth" => 0, "msg" => "Erro no servidor."]]);
    exit();
}


// ===== INÍCIO DO NOVO BLOCO DE CONTROLE DE CONEXÃO (VERSÃO SEGURA) =====
try {
    $conexao->beginTransaction();

    $ip = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
    $limiteConexoes = (int) $result["conexoes"];

    // 1. LIMPEZA: Remove conexões "fantasmas" do usuário que não se reportaram nos últimos 20 segundos.
    $stmt_limpeza = $conexao->prepare("DELETE FROM conexoes WHERE usuario = :usuario AND ultima_atividade < NOW() - INTERVAL 20 SECOND");
    $stmt_limpeza->execute([':usuario' => $username]);

    // 2. CONTAGEM: Conta as conexões REALMENTE ativas para o usuário (usando lock para evitar race condition)
    $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :usuario FOR UPDATE");
    $stmt_count->execute([':usuario' => $username]);
    $conexoes_ativas = (int) $stmt_count->fetchColumn();

    // 3. VERIFICAÇÃO E AÃO
    if ($conexoes_ativas >= $limiteConexoes) {
        $conexao->rollBack();
        $video_bloqueio = "http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4";
        header("Location: $video_bloqueio");
        exit();
    } else {
        // Ainda há espaço, insere a nova conexo
        $stmt_insert = $conexao->prepare(
            "INSERT INTO conexoes (usuario, ip, user_agent, ultima_atividade) VALUES (:usuario, :ip, :user_agent, NOW())"
        );
        $stmt_insert->execute([':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent]);
    }
    
    $conexao->commit();

} catch (Exception $e) {
    if ($conexao->inTransaction()) {
        $conexao->rollBack();
    }
    $video_bloqueio = "http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4";
    header("Location: $video_bloqueio");
    exit();
}
// ===== FIM DO NOVO BLOCO DE CONTROLE DE CONEXÃO =====


// ---- Lógica de busca e redirecionamento do Stream (Mantida) ----
if ($arquivo) {
    $arquivo_sem_extensao = pathinfo($arquivo, PATHINFO_FILENAME);
    $extensao = pathinfo($arquivo, PATHINFO_EXTENSION);
} else {
    exit();
}

// A única mudança é aqui: busca na tabela de episódios de séries
$query_streams = "SELECT * FROM series_episodes WHERE id = :id";
$stmt_streams = $conexao->prepare($query_streams);
$stmt_streams->bindParam(':id', $arquivo_sem_extensao, PDO::PARAM_INT);
$stmt_streams->execute();
$resultado_streams = $stmt_streams->fetch(PDO::FETCH_ASSOC);

if (empty($resultado_streams)) {
    $vod_nao_encontrado = "http://" . $_SERVER['HTTP_HOST'] . "/video/vod_nao_encontrado.mp4";
    header("Location: $vod_nao_encontrado");
    exit();
}

$location = $resultado_streams['link'];
$tipo_link = $resultado_streams['tipo_link'];

if ($tipo_link == 'link_direto') {
    header("Location: ".$location);
    exit;
}

// O restante da sua lógica de redirecionamento complexo...
$dados = @processarUrl($location);
if ($location && $dados && $tipo_link !== 'link_direto2') {
    $url = "http://{$dados['dominio']}/{$type_url}/{$dados['usuario']}/{$dados['senha']}/{$dados['arquivo']}.$extensao";
    if ($tipo_link == 'padrao2') {
        header("Location: ".$location);
        exit;
    }
    $location2 = json_decode(getHeadersAsJson($url), true);
    if ($location2) {
        if (isset($location2['location'])) {
            header("Location: " . (is_array($location2['location']) ? $location2['location'][0] : $location2['location']));
            exit;
        }
        if (isset($location2['URLsComToken'])) {
            header("Location: " . (is_array($location2['URLsComToken']) ? $location2['URLsComToken'][0] : $location2['URLsComToken']));
            exit;
        }
    }
    header("Location: $url");
    exit;
}

$location3 = json_decode(getHeadersAsJson($location), true);
if ($location3) {
    if (isset($location3['location'])) {
        header("Location: " . (is_array($location3['location']) ? $location3['location'][0] : $location3['location']));
        exit;
    }
    if (isset($location3['URLsComToken'])) {
        header("Location: " . (is_array($location3['URLsComToken']) ? $location3['URLsComToken'][0] : $location3['URLsComToken']));
        exit;
    }
}

header("Location: $location");
exit;
?>