<?php
// Define o fuso horário e requer o banco de dados
date_default_timezone_set('America/Sao_Paulo');
require_once "./api/controles/db.php";

// --- PARÂMETROS E VALIDAÇÃO INICIAL ---
$username = $_GET["usuario"] ?? null;
$password = $_GET["senha"] ?? null;
$arquivo = $_GET["arquivo"] ?? null;
$stream_id = pathinfo($arquivo, PATHINFO_FILENAME);

if (empty($stream_id) || !$username || !$password) {
    http_response_code(400); exit("Parâmetros insuficientes.");
}

$conexao = null; // Inicializa a variável de conexão

try {
    $conexao = conectar_bd();
    $conexao->beginTransaction();

    // --- LÓGICA UNIFICADA DE AUTENTICAÇÃO E CONTROLE DE CONEXÃO ---

    // 1. AUTENTICAÇÃO
    $stmt_cliente = $conexao->prepare("SELECT * FROM clientes WHERE usuario = :username AND senha = :password FOR UPDATE");
    $stmt_cliente->execute([':username' => $username, ':password' => $password]);
    $cliente = $stmt_cliente->fetch(PDO::FETCH_ASSOC);

    if (!$cliente) {
        throw new Exception("Usuário ou senha inválidos.", 401);
    }

    // 2. VERIFICAÇÃO DE VENCIMENTO
    if (new DateTime() > new DateTime($cliente["Vencimento"])) {
        $conexao->rollBack();
        $video_bloqueio = "http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4";
        header("Location: $video_bloqueio");
        exit();
    }

    // 3. LÓGICA DE CONEXÃO (UPSERT COM STREAM_ID)
    $ip = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
    $limiteConexoes = (int) $cliente["conexoes"];

    // LIMPEZA: Remove conexões fantasmas apenas do usuário atual
    $stmt_limpeza = $conexao->prepare("DELETE FROM conexoes WHERE usuario = :usuario AND ultima_atividade < NOW() - INTERVAL 25 SECOND");
    $stmt_limpeza->execute([':usuario' => $username]);

    // Tenta ATUALIZAR a conexão existente, gravando o stream_id que o usuário está acessando.
    $stmt_update = $conexao->prepare("UPDATE conexoes SET ultima_atividade = NOW(), stream_id = :stream_id WHERE usuario = :usuario AND ip = :ip AND user_agent = :user_agent");
    $stmt_update->execute([':stream_id' => $stream_id, ':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent]);

    // Se não atualizou nenhuma linha, é uma nova conexão.
    if ($stmt_update->rowCount() === 0) {
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :usuario");
        $stmt_count->execute([':usuario' => $username]);
        $conexoes_ativas = (int) $stmt_count->fetchColumn();

        if ($conexoes_ativas >= $limiteConexoes) {
            throw new Exception("Limite de conexões atingido.", 403);
        } else {
            // INSERE a nova conexão com o stream_id.
            $stmt_insert = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:usuario, :ip, :user_agent, :stream_id, NOW())");
            $stmt_insert->execute([':usuario' => $username, ':ip' => $ip, ':user_agent' => $user_agent, ':stream_id' => $stream_id]);
        }
    }
    
    // --- LÓGICA DE BUSCA E REDIRECIONAMENTO PARA FILMES ---
    
    // Busca o link do filme na tabela 'streams'
    $stmt_stream = $conexao->prepare("SELECT link FROM streams WHERE id = :id AND stream_type = 'movie'");
    $stmt_stream->execute([':id' => $stream_id]);
    $stream = $stmt_stream->fetch(PDO::FETCH_ASSOC);
    
    if (!$stream || empty($stream['link'])) {
        throw new Exception("Filme não encontrado.", 404);
    }

    // Se tudo deu certo até aqui, confirma todas as operações no banco de dados.
    $conexao->commit();

    // Redireciona o cliente para o link do filme.
    header("Location: " . $stream['link']);
    exit();

} catch (Exception $e) {
    if ($conexao && $conexao->inTransaction()) { $conexao->rollBack(); }
    
    $errorCode = $e->getCode() >= 400 ? $e->getCode() : 500;
    http_response_code($errorCode);

    if ($errorCode < 500) { // Erros de cliente (vencido, limite, etc.)
        $video_bloqueio = "http://" . $_SERVER["HTTP_HOST"] . "/video/block.mp4";
        header("Location: $video_bloqueio");
    } else { // Erros de servidor
        // error_log("Erro no gatekeeper de filmes: " . $e->getMessage());
        exit("Erro interno do servidor.");
    }
    exit();
}
?>