<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

// Mostra todos os erros possíveis
ini_set('display_errors', 1);
error_reporting(E_ALL);

// PASSO 1: VERIFICAR CAMINHO DO ARQUIVO DE CONEXÃO
$db_path = __DIR__ . '/controles/db.php';
if (!file_exists($db_path)) {
    http_response_code(500);
    // Se o erro for aqui, o caminho __DIR__ está errado para sua estrutura.
    die(json_encode(['data' => [], 'error' => 'DIAGNÓSTICO: ERRO GRAVE! O arquivo db.php não foi encontrado no caminho esperado: ' . $db_path]));
}
require_once($db_path);

// PASSO 2: VERIFICAR A FUNÇÃO DE CONEXÃO E AS CREDENCIAIS
try {
    $pdo = conectar_bd();
} catch (PDOException $e) {
    http_response_code(500);
    // Se o erro for aqui, suas credenciais (usuário, senha, nome do banco) no db.php estão erradas.
    die(json_encode(['data' => [], 'error' => 'DIAGNÓSTICO: A conexão com o banco de dados FALHOU! Verifique suas credenciais no arquivo db.php. Detalhes: ' . $e->getMessage()]));
}

// PASSO 3: VERIFICAR A SESSÃO DE LOGIN
// (Temporariamente desativado para o teste, para garantir que não seja a causa do bloqueio)
/*
if (!isset($_SESSION['admin_id'])) {
    http_response_code(403);
    die(json_encode(['data' => [], 'error' => 'DIAGNÓSTICO: Acesso negado. A sessão admin_id não existe.']));
}
*/
$admin_id = $_SESSION['admin_id'] ?? 0;

// PASSO 4: VERIFICAR A CONSULTA SQL
if (isset($_GET['listar_revendedores'])) {
    try {
        // A consulta para buscar revendedores
        $stmt = $pdo->query("SELECT id, nome, user, creditos, 'Revendedor' AS tipo, 0 AS total_revendedores, 0 AS total_clientes FROM admin WHERE nivel_admin != 1");
        $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // Se tudo der certo, ele envia os dados.
        echo json_encode(['data' => $dados]);

    } catch (PDOException $e) {
        http_response_code(500);
        // Se o erro for aqui, o nome de uma coluna na sua query (ex: 'nome', 'user', 'creditos', 'nivel_admin') está errado na tabela 'admin'.
        die(json_encode(['data' => [], 'error' => 'DIAGNÓSTICO: A consulta SQL para listar os revendedores FALHOU! Verifique os nomes das colunas. Erro: ' . $e->getMessage()]));
    }
    exit;
}

// Se nenhuma ação for encontrada, retorna um erro padrão
echo json_encode(['data' => [], 'error' => 'DIAGNÓSTICO: Nenhuma ação foi especificada (ex: ?listar_revendedores=1)']);
?>