<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

$data = json_decode(file_get_contents("php://input"), true);
if (empty($data['id']) || !isset($data['creditos']) || !is_numeric($data['creditos'])) { http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'ID ou valor de créditos inválido.'])); }
try {
    $pdo = conectar_bd();
    $pdo->beginTransaction();
    $revendedor_id = $data['id'];
    $creditos_para_add = (float)$data['creditos'];
    $stmtUpdate = $pdo->prepare("UPDATE admin SET creditos = creditos + :creditos WHERE id = :id");
    $stmtUpdate->execute([':creditos' => $creditos_para_add, ':id' => $revendedor_id]);
    $stmtSelect = $pdo->prepare("SELECT user FROM admin WHERE id = :id");
    $stmtSelect->execute([':id' => $revendedor_id]);
    $revendedor = $stmtSelect->fetch(PDO::FETCH_ASSOC);
    $nome_revendedor = $revendedor ? $revendedor['user'] : 'Revendedor';
    $stmt_log = $pdo->prepare("INSERT INTO credits_log (admin_id, target_id, amount, date, reason) VALUES (?, ?, ?, ?, ?)");
    $stmt_log->execute([1, $revendedor_id, $creditos_para_add, time(), "Adição/Remoção manual de créditos."]); // Usando ID 1 como admin padrão
    $pdo->commit();
    echo json_encode(['status' => 'success', 'message' => 'Créditos adicionados com sucesso!', 'dados_mensagem' => ['nome_revendedor' => $nome_revendedor, 'creditos_adicionados' => $creditos_para_add]]);
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao adicionar créditos: ' . $e->getMessage()]));
}
?>