<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

$data = json_decode(file_get_contents('php://input'), true);
if (empty($data['usuario']) || empty($data['senha'])) { http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'Usuário e senha são obrigatórios.'])); }
try {
    $pdo = conectar_bd();
    $sql = "INSERT INTO admin (user, pass) VALUES (:user, :pass)";
    $stmt = $pdo->prepare($sql);
    $senha_hash = password_hash($data['senha'], PASSWORD_DEFAULT);
    $stmt->execute([':user' => $data['usuario'], ':pass' => $senha_hash]);
    echo json_encode(['status' => 'success', 'message' => 'Revendedor criado com sucesso.', 'dados_mensagem' => ['usuario' => $data['usuario'], 'senha' => $data['senha']]]);
} catch (PDOException $e) {
    if ($e->getCode() == 23000) { die(json_encode(['status' => 'error', 'message' => 'Este nome de usuário já existe.'])); }
    http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao criar revendedor: ' . $e->getMessage()]));
}
?>