<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

/**
 * Medida de segurança CORRIGIDA:
 * Agora, este bloco verifica se a variável de sessão 'nivel_admin' existe e se o seu valor é 1,
 * que é o que o seu sistema de login define para o administrador.
 */
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] != 1) {
    http_response_code(403); // Acesso Negado
    die(json_encode(['status' => 'error', 'message' => 'Acesso negado. Apenas administradores (nível 1) podem ver esta lista.']));
}

require_once(dirname(__DIR__, 2) . '/api/controles/db.php');

try {
    $pdo = conectar_bd();
    
    // Busca os dados da sua tabela de revendedores ('admin')
    $stmt = $pdo->query("SELECT id, nome, user, creditos FROM admin ORDER BY nome ASC");
    
    $revendedores = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Adiciona uma coluna 'status' fixa para compatibilidade com o JavaScript
    foreach ($revendedores as &$revendedor) {
        $revendedor['status'] = 'Ativo';
    }
    unset($revendedor);

    echo json_encode(['status' => 'success', 'data' => $revendedores]);

} catch (PDOException $e) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Erro na Consulta SQL: ' . $e->getMessage()]));
}
?>