<?php
// Arquivo: api/verificar_sessao.php

// Inicia a sessão para poder ler os dados dela
session_start();

// Define o cabeçalho como texto simples para facilitar a leitura
header('Content-Type: text/plain; charset=utf-8');

echo "=== Diagnóstico da Sessão PHP ===\n\n";

if (isset($_SESSION) && !empty($_SESSION)) {
    echo "A sessão foi iniciada e contém as seguintes informações:\n\n";
    // Imprime todo o conteúdo da variável $_SESSION
    print_r($_SESSION);
} else {
    echo "A sessão foi iniciada, mas está VAZIA.\n";
    echo "Isso significa que o seu script de login não está salvando NENHUMA informação na sessão.";
}

echo "\n\n=== Análise para a Lista de Revendedores ===\n\n";

if (isset($_SESSION['user_role'])) {
    echo "A variável de permissão 'user_role' FOI ENCONTRADA.\n";
    echo "O valor dela é: '" . $_SESSION['user_role'] . "'\n\n";
    
    if ($_SESSION['user_role'] === 'admin') {
        echo "Resultado: SUCESSO! Você tem a permissão de 'admin' e deveria conseguir ver a lista.";
    } else {
        echo "Resultado: FALHA! Você NÃO tem a permissão de 'admin'. O valor atual é '" . $_SESSION['user_role'] . "'.\n";
        echo "O script 'listar.php' está te bloqueando corretamente por segurança.\n";
        echo "A SOLUÇÃO é corrigir o seu script de LOGIN DE ADMIN para que ele salve: \$_SESSION['user_role'] = 'admin';";
    }
} else {
    echo "Resultado: FALHA! A variável de permissão 'user_role' NÃO FOI ENCONTRADA na sessão.\n";
    echo "O script 'listar.php' está te bloqueando porque não sabe qual é o seu nível de acesso.\n";
    echo "A SOLUÇÃO é corrigir o seu script de LOGIN DE ADMIN para que ele salve: \$_SESSION['user_role'] = 'admin';";
}
?>