<?php
require_once 'api/controles/db.php';

$id = $_POST['id'];
$user = $_POST['user'];
$email = $_POST['email'];
$whatsapp = $_POST['whatsapp'];
$telegram = $_POST['telegram'];
$nova_senha = $_POST['nova_senha'];
$confirma_senha = $_POST['confirma_senha'];

$conexao = conectar_bd();

if (!$conexao) {
    die("Falha crítica: Não foi possível conectar ao banco de dados.");
}

$mensagem_status = "";
$status_ok = false;

try {
    if (!empty($nova_senha)) {
        if ($nova_senha !== $confirma_senha) {
            $mensagem_status = "As senhas não coincidem. Por favor, volte e tente novamente.";
        } else {
            // ===================================================================
            // MUDANÇA CRÍTICA AQUI: Salvando a senha como TEXTO PURO
            // Removemos a criptografia para ser compatível com o seu painel.
            $senha_hash = $nova_senha; 
            // ===================================================================
            
            $sql = "UPDATE admin SET user = :user, email = :email, whatsapp = :whatsapp, telegram = :telegram, pass = :pass WHERE id = :id";
            $stmt = $conexao->prepare($sql);
            $stmt->bindParam(':pass', $senha_hash);
            $stmt->bindParam(':user', $user);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':whatsapp', $whatsapp);
            $stmt->bindParam(':telegram', $telegram);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            $mensagem_status = "Informações e senha atualizadas com sucesso!";
            $status_ok = true;
        }
    } else {
        // Se não houver nova senha, apenas atualiza o resto
        $sql = "UPDATE admin SET user = :user, email = :email, whatsapp = :whatsapp, telegram = :telegram WHERE id = :id";
        $stmt = $conexao->prepare($sql);
        $stmt->bindParam(':user', $user);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':whatsapp', $whatsapp);
        $stmt->bindParam(':telegram', $telegram);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $mensagem_status = "Informações (sem senha) atualizadas com sucesso!";
        $status_ok = true;
    }

} catch (PDOException $e) {
    $mensagem_status = "Erro ao atualizar as informações: " . $e->getMessage();
}

$conexao = null;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status da Atualização</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-color: #f0f2f5;
            --card-bg: #ffffff;
            --text-color: #333;
            --border-color: #e0e0e0;
            --primary-color: #007bff;
            --primary-hover: #0056b3;
            --success-color: #28a745;
            --error-color: #dc3545;
        }
        body.dark-theme {
            --bg-color: #212529;
            --card-bg: #2d3436;
            --text-color: #f8f9fa;
            --border-color: #495057;
            --primary-color: #6a00ff;
            --primary-hover: #4e00b3;
        }
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: var(--bg-color);
            color: var(--text-color);
        }
        .container {
            background-color: var(--card-bg);
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 450px;
            text-align: center;
            border: 1px solid var(--border-color);
        }
        .icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px auto;
        }
        h1 {
            color: <?php echo $status_ok ? 'var(--success-color)' : 'var(--error-color)'; ?>;
            margin-bottom: 20px;
            font-size: 2em;
        }
        p {
            color: var(--text-color);
            margin-bottom: 30px;
            font-size: 1.1em;
            line-height: 1.6;
        }
        .back-link {
            display: inline-block;
            padding: 12px 25px;
            background-color: var(--primary-color);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 700;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        .back-link:hover {
            background-color: var(--primary-hover);
            transform: translateY(-2px);
        }
    </style>
</head>
<body> 
    <div class="container">
        <?php if ($status_ok): ?>
            <div class="icon">
                <svg viewBox="0 0 24 24" fill="<?php echo $status_ok ? '#28a745' : '#dc3545'; ?>" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2C6.49 2 2 6.49 2 12C2 17.51 6.49 22 12 22C17.51 22 22 17.51 22 12C22 6.49 17.51 2 12 2ZM16.78 9.7L11.11 15.37C10.97 15.51 10.78 15.59 10.58 15.59C10.38 15.59 10.19 15.51 10.05 15.37L7.22 12.54C6.93 12.25 6.93 11.77 7.22 11.48C7.51 11.19 7.99 11.19 8.28 11.48L10.58 13.78L15.72 8.64C16.01 8.35 16.49 8.35 16.78 8.64C17.07 8.93 17.07 9.4 16.78 9.7Z"/>
                </svg>
            </div>
            <h1>Sucesso!</h1>
        <?php else: ?>
            <div class="icon">
                <svg viewBox="0 0 24 24" fill="<?php echo $status_ok ? '#28a745' : '#dc3545'; ?>" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 13C11.45 13 11 12.55 11 12V8C11 7.45 11.45 7 12 7C12.55 7 13 7.45 13 8V12C13 12.55 12.55 13 12 13ZM13 17H11V15H13V17Z"/>
                </svg>
            </div>
            <h1>Ocorreu um Erro</h1>
        <?php endif; ?>
        
        <p><?php echo htmlspecialchars($mensagem_status); ?></p>
        <a href="editar_admin.php" class="back-link">Voltar para Edição</a>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark') {
                document.body.classList.add('dark-theme');
            } else {
                document.body.classList.remove('dark-theme');
            }
        });
    </script>
</body>
</html>