<?php
// Arquivo: api/clientes/buscar_um.php (VERSÃO FINAL CORRIGIDA)

header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../controles/db.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    http_response_code(400);
    die(json_encode(['status' => 'error', 'message' => 'ID do cliente não fornecido.']));
}

try {
    $pdo = conectar_bd();
    
    // CORRIGIDO: Seleciona "Vencimento" (com V maiúsculo) e todos os outros campos necessários
    $stmt = $pdo->prepare(
        "SELECT id, name, usuario, senha, Vencimento 
         FROM clientes 
         WHERE id = :id"
    );
    
    $stmt->execute([':id' => $_GET['id']]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($cliente) {
        echo json_encode(['status' => 'success', 'data' => $cliente]);
    } else {
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Cliente não encontrado.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Erro de servidor ao buscar cliente.']));
}
?>