<?php
/**
 * Arquivo de Configuração e Conexão com o Banco de Dados
 *
 * Centraliza as credenciais e a lógica de conexão, além de outras
 * configurações globais como chaves de API.
 */

// -------------------------------------------------------------------
// CHAVES DE API GLOBAIS
// -------------------------------------------------------------------

/**
 * Chave de API para o The Movie Database (TMDB)
 * Obtenha a sua em https://www.themoviedb.org/settings/api
 */
define('TMDB_API_KEY', 'f99aa9ae1fe7619969cc7db0938c1ae5');


// -------------------------------------------------------------------
// FUNÇÃO DE CONEXÃO COM O BANCO DE DADOS
// -------------------------------------------------------------------

/**
 * Estabelece e retorna uma conexão com o banco de dados usando PDO.
 * Esta função centraliza a lógica de conexão para ser reutilizada.
 *
 * @return PDO Retorna o objeto de conexão PDO em caso de sucesso.
 * @throws PDOException Encerra o script com uma mensagem de erro JSON em caso de falha.
 */
function conectar_bd() {
    // --- INFORMAÇÕES DE CONEXÃO ---
    // Para maior segurança em produção, considere usar variáveis de ambiente
    // em vez de colocar as credenciais diretamente no código.
    $endereco = 'localhost';
    $banco = 'geanrober_topiptv';
    $dbusuario = 'geanrober_topipt';
    $dbsenha = 'Jean#909110'; // ATENÇÃO: É recomendado ter uma senha mais forte.
    $charset = 'utf8mb4';     // Garante o suporte a emojis e caracteres especiais.

    // --- OPÇÕES AVANÇADAS DO PDO ---
    // Estas opções garantem uma conexão mais segura e previsível.
    $options = [
        // Lança exceções em caso de erro, permitindo capturá-los com o bloco try-catch.
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        // Define que os resultados das queries serão retornados como arrays associativos (ex: ['coluna' => 'valor']).
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        // Desativa a emulação de prepared statements, usando os prepares nativos do MySQL. É mais seguro.
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    // DSN (Data Source Name) - A "string de conexão" que o PDO usa para se conectar.
    $dsn = "mysql:host=$endereco;dbname=$banco;charset=$charset";

    try {
        // Tenta criar a nova instância do PDO para estabelecer a conexão.
        $conexao = new PDO($dsn, $dbusuario, $dbsenha, $options);
        // Retorna o objeto de conexão se tudo der certo.
        return $conexao;
    } catch(PDOException $e) {
        // Se a conexão falhar, o bloco catch é executado.
        
        // Define o código de status HTTP para "Erro Interno do Servidor".
        // Isso é útil para o front-end saber que algo deu errado no back-end.
        http_response_code(500);

        // Para o nosso importador (que usa JavaScript/AJAX), é crucial retornar um erro em JSON.
        // Em um ambiente de produção, o ideal seria registrar o erro em um arquivo de log em vez de exibi-lo.
        // Ex: error_log('Erro de conexão com o BD: ' . $e->getMessage());
        die(json_encode([
            'status' => 'error',
            'message' => 'Falha na conexão com o banco de dados.'
        ]));
    }
}